/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.date.RFC2616Date;
import com.ning.http.client.date.RFC2616DateParser;
import com.ning.http.client.date.TimeConverter;

class KeyValuePairsParser {
    private final TimeConverter timeBuilder;
    private String name;
    private String value;
    private String rawValue;
    private String domain;
    private String path;
    private long expires = -1L;
    private int maxAge = -1;
    private boolean secure;
    private boolean httpOnly;

    public KeyValuePairsParser(TimeConverter timeBuilder) {
        this.timeBuilder = timeBuilder;
    }

    public Cookie cookie() {
        return this.name != null ? new Cookie(this.name, this.value, this.rawValue, this.domain, this.path, this.expires, this.maxAge, this.secure, this.httpOnly) : null;
    }

    public void parseKeyValuePair(String header2, int keyStart, int keyEnd, String value2, String rawValue) {
        if (this.name == null) {
            this.setCookieNameValue(header2, keyStart, keyEnd, value2, rawValue);
        } else {
            this.setCookieAttribute(header2, keyStart, keyEnd, value2);
        }
    }

    private void setCookieNameValue(String header2, int keyStart, int keyEnd, String value2, String rawValue) {
        this.name = header2.substring(keyStart, keyEnd);
        this.value = value2;
        this.rawValue = rawValue;
    }

    private void setCookieAttribute(String header2, int keyStart, int keyEnd, String value2) {
        int length = keyEnd - keyStart;
        if (length == 4) {
            this.parse4(header2, keyStart, value2);
        } else if (length == 6) {
            this.parse6(header2, keyStart, value2);
        } else if (length == 7) {
            this.parse7(header2, keyStart, value2);
        } else if (length == 8) {
            this.parse8(header2, keyStart, value2);
        }
    }

    private boolean isPath(char c0, char c1, char c2, char c3) {
        return !(c0 != 'P' && c0 != 'p' || c1 != 'a' && c1 != 'A' || c2 != 't' && c2 != 'T' || c3 != 'h' && c3 != 'H');
    }

    private void parse4(String header2, int nameStart, String value2) {
        char c3;
        char c2;
        char c1;
        char c0 = header2.charAt(nameStart);
        if (this.isPath(c0, c1 = header2.charAt(nameStart + 1), c2 = header2.charAt(nameStart + 2), c3 = header2.charAt(nameStart + 3))) {
            this.path = value2;
        }
    }

    private boolean isDomain(char c0, char c1, char c2, char c3, char c4, char c5) {
        return !(c0 != 'D' && c0 != 'd' || c1 != 'o' && c1 != 'O' || c2 != 'm' && c2 != 'M' || c3 != 'a' && c3 != 'A' || c4 != 'i' && c4 != 'I' || c5 != 'n' && c5 != 'N');
    }

    private boolean isSecure(char c0, char c1, char c2, char c3, char c4, char c5) {
        return !(c0 != 'S' && c0 != 's' || c1 != 'e' && c1 != 'E' || c2 != 'c' && c2 != 'C' || c3 != 'u' && c3 != 'U' || c4 != 'r' && c4 != 'R' || c5 != 'e' && c5 != 'E');
    }

    private void parse6(String header2, int nameStart, String value2) {
        char c5;
        char c4;
        char c3;
        char c2;
        char c1;
        char c0 = header2.charAt(nameStart);
        if (this.isDomain(c0, c1 = header2.charAt(nameStart + 1), c2 = header2.charAt(nameStart + 2), c3 = header2.charAt(nameStart + 3), c4 = header2.charAt(nameStart + 4), c5 = header2.charAt(nameStart + 5))) {
            this.domain = value2;
        } else if (this.isSecure(c0, c1, c2, c3, c4, c5)) {
            this.secure = true;
        }
    }

    private boolean isExpires(char c0, char c1, char c2, char c3, char c4, char c5, char c6) {
        return !(c0 != 'E' && c0 != 'e' || c1 != 'x' && c1 != 'X' || c2 != 'p' && c2 != 'P' || c3 != 'i' && c3 != 'I' || c4 != 'r' && c4 != 'R' || c5 != 'e' && c5 != 'E' || c6 != 's' && c6 != 'S');
    }

    private boolean isMaxAge(char c0, char c1, char c2, char c3, char c4, char c5, char c6) {
        return !(c0 != 'M' && c0 != 'm' || c1 != 'a' && c1 != 'A' || c2 != 'x' && c2 != 'X' || c3 != '-' || c4 != 'A' && c4 != 'a' || c5 != 'g' && c5 != 'G' || c6 != 'e' && c6 != 'E');
    }

    private void setExpire(String value2) {
        RFC2616Date dateElements = new RFC2616DateParser(value2).parse();
        if (dateElements != null) {
            try {
                this.expires = this.timeBuilder.toTime(dateElements);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setMaxAge(String value2) {
        try {
            this.maxAge = Math.max(Integer.valueOf(value2), 0);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void parse7(String header2, int nameStart, String value2) {
        char c6;
        char c5;
        char c4;
        char c3;
        char c2;
        char c1;
        char c0 = header2.charAt(nameStart);
        if (this.isExpires(c0, c1 = header2.charAt(nameStart + 1), c2 = header2.charAt(nameStart + 2), c3 = header2.charAt(nameStart + 3), c4 = header2.charAt(nameStart + 4), c5 = header2.charAt(nameStart + 5), c6 = header2.charAt(nameStart + 6))) {
            this.setExpire(value2);
        } else if (this.isMaxAge(c0, c1, c2, c3, c4, c5, c6)) {
            this.setMaxAge(value2);
        }
    }

    private boolean isHttpOnly(char c0, char c1, char c2, char c3, char c4, char c5, char c6, char c7) {
        return !(c0 != 'H' && c0 != 'h' || c1 != 't' && c1 != 'T' || c2 != 't' && c2 != 'T' || c3 != 'p' && c3 != 'P' || c4 != 'O' && c4 != 'o' || c5 != 'n' && c5 != 'N' || c6 != 'l' && c6 != 'L' || c7 != 'y' && c7 != 'Y');
    }

    private void parse8(String header2, int nameStart, String value2) {
        char c7;
        char c6;
        char c5;
        char c4;
        char c3;
        char c2;
        char c1;
        char c0 = header2.charAt(nameStart);
        if (this.isHttpOnly(c0, c1 = header2.charAt(nameStart + 1), c2 = header2.charAt(nameStart + 2), c3 = header2.charAt(nameStart + 3), c4 = header2.charAt(nameStart + 4), c5 = header2.charAt(nameStart + 5), c6 = header2.charAt(nameStart + 6), c7 = header2.charAt(nameStart + 7))) {
            this.httpOnly = true;
        }
    }
}

