/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.generators;

import com.ning.http.client.BodyGenerator;
import com.ning.http.client.RandomAccessBody;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class FileBodyGenerator
implements BodyGenerator {
    private final File file;
    private final long regionSeek;
    private final long regionLength;

    public FileBodyGenerator(File file2) {
        if (file2 == null) {
            throw new NullPointerException("file");
        }
        this.file = file2;
        this.regionLength = file2.length();
        this.regionSeek = 0L;
    }

    public FileBodyGenerator(File file2, long regionSeek, long regionLength) {
        if (file2 == null) {
            throw new NullPointerException("file");
        }
        this.file = file2;
        this.regionLength = regionLength;
        this.regionSeek = regionSeek;
    }

    public RandomAccessBody createBody() throws IOException {
        return new FileBody(this.file, this.regionSeek, this.regionLength);
    }

    protected static class FileBody
    implements RandomAccessBody {
        private final RandomAccessFile file;
        private final FileChannel channel;
        private final long length;

        public FileBody(File file2) throws IOException {
            this.file = new RandomAccessFile(file2, "r");
            this.channel = this.file.getChannel();
            this.length = file2.length();
        }

        public FileBody(File file2, long regionSeek, long regionLength) throws IOException {
            this.file = new RandomAccessFile(file2, "r");
            this.channel = this.file.getChannel();
            this.length = regionLength;
            if (regionSeek > 0L) {
                this.file.seek(regionSeek);
            }
        }

        public long getContentLength() {
            return this.length;
        }

        public long read(ByteBuffer buffer2) throws IOException {
            return this.channel.read(buffer2);
        }

        public long transferTo(long position, long count2, WritableByteChannel target) throws IOException {
            if (count2 > this.length) {
                count2 = this.length;
            }
            return this.channel.transferTo(position, count2, target);
        }

        public void close() throws IOException {
            this.file.close();
        }
    }
}

