/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.listener;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.Response;
import com.ning.http.client.listener.TransferListener;
import com.ning.http.util.MiscUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferCompletionHandler
extends AsyncCompletionHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(TransferCompletionHandler.class);
    private final ConcurrentLinkedQueue<TransferListener> listeners = new ConcurrentLinkedQueue();
    private final boolean accumulateResponseBytes;
    private TransferAdapter transferAdapter;
    private AtomicLong bytesTransferred = new AtomicLong();
    private AtomicLong totalBytesToTransfer = new AtomicLong(0L);

    public TransferCompletionHandler() {
        this(false);
    }

    public TransferCompletionHandler(boolean accumulateResponseBytes) {
        this.accumulateResponseBytes = accumulateResponseBytes;
    }

    public TransferCompletionHandler addTransferListener(TransferListener t) {
        this.listeners.offer(t);
        return this;
    }

    public TransferCompletionHandler removeTransferListener(TransferListener t) {
        this.listeners.remove(t);
        return this;
    }

    public void transferAdapter(TransferAdapter transferAdapter) {
        this.transferAdapter = transferAdapter;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers2) throws Exception {
        this.fireOnHeaderReceived(headers2.getHeaders());
        return super.onHeadersReceived(headers2);
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        AsyncHandler.STATE s2 = AsyncHandler.STATE.CONTINUE;
        if (this.accumulateResponseBytes) {
            s2 = super.onBodyPartReceived(content);
        }
        this.fireOnBytesReceived(content.getBodyPartBytes());
        return s2;
    }

    public Response onCompleted(Response response) throws Exception {
        this.fireOnEnd();
        return response;
    }

    public AsyncHandler.STATE onHeaderWriteCompleted() {
        Object list2 = this.transferAdapter.getHeaders().get("Content-Length");
        if (MiscUtil.isNonEmpty(list2) && list2.get(0) != "") {
            this.totalBytesToTransfer.set(Long.valueOf((String)list2.get(0)));
        }
        this.fireOnHeadersSent(this.transferAdapter.getHeaders());
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onContentWriteCompleted() {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onContentWriteProgress(long amount, long current2, long total2) {
        if (this.bytesTransferred.get() == -1L) {
            return AsyncHandler.STATE.CONTINUE;
        }
        if (this.totalBytesToTransfer.get() == 0L) {
            this.totalBytesToTransfer.set(total2);
        }
        this.bytesTransferred.addAndGet(amount);
        if (this.transferAdapter != null) {
            byte[] bytes2 = new byte[(int)amount];
            this.transferAdapter.getBytes(bytes2);
            this.fireOnBytesSent(bytes2);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public void onThrowable(Throwable t) {
        this.fireOnThrowable(t);
    }

    private void fireOnHeadersSent(FluentCaseInsensitiveStringsMap headers2) {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestHeadersSent(headers2);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnHeaderReceived(FluentCaseInsensitiveStringsMap headers2) {
        for (TransferListener l : this.listeners) {
            try {
                l.onResponseHeadersReceived(headers2);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnEnd() {
        long count2 = this.bytesTransferred.getAndSet(-1L);
        if (count2 != this.totalBytesToTransfer.get() && this.transferAdapter != null) {
            byte[] bytes2 = new byte[8192];
            int leftBytes = (int)(this.totalBytesToTransfer.get() - count2);
            int length = 8192;
            while (leftBytes > 0) {
                if (leftBytes > 8192) {
                    leftBytes -= 8192;
                } else {
                    length = leftBytes;
                    leftBytes = 0;
                }
                if (length < 8192) {
                    bytes2 = new byte[length];
                }
                this.transferAdapter.getBytes(bytes2);
                this.fireOnBytesSent(bytes2);
            }
        }
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestResponseCompleted();
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesReceived(byte[] b) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesReceived(ByteBuffer.wrap(b));
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesSent(byte[] b) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesSent(ByteBuffer.wrap(b));
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnThrowable(Throwable t) {
        for (TransferListener l : this.listeners) {
            try {
                l.onThrowable(t);
            }
            catch (Throwable t2) {
                logger.warn("onThrowable", t2);
            }
        }
    }

    public static abstract class TransferAdapter {
        private final FluentCaseInsensitiveStringsMap headers;

        public TransferAdapter(FluentCaseInsensitiveStringsMap headers2) throws IOException {
            this.headers = headers2;
        }

        public FluentCaseInsensitiveStringsMap getHeaders() {
            return this.headers;
        }

        public abstract void getBytes(byte[] var1);
    }
}

