/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ntlm;

import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.util.Base64;
import com.ning.http.util.MiscUtil;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class NTLMEngine {
    protected static final int FLAG_UNICODE_ENCODING = 1;
    protected static final int FLAG_TARGET_DESIRED = 4;
    protected static final int FLAG_NEGOTIATE_SIGN = 16;
    protected static final int FLAG_NEGOTIATE_SEAL = 32;
    protected static final int FLAG_NEGOTIATE_NTLM = 512;
    protected static final int FLAG_NEGOTIATE_ALWAYS_SIGN = 32768;
    protected static final int FLAG_NEGOTIATE_NTLM2 = 524288;
    protected static final int FLAG_NEGOTIATE_128 = 0x20000000;
    protected static final int FLAG_NEGOTIATE_KEY_EXCH = 0x40000000;
    private static final SecureRandom RND_GEN;
    static final String DEFAULT_CHARSET = "ASCII";
    private String credentialCharset = "ASCII";
    private static byte[] SIGNATURE;

    final String getResponseFor(String message, String username2, String password, String host2, String domain2) throws NTLMEngineException {
        String response;
        if (MiscUtil.isNonEmpty(message)) {
            Type2Message t2m = new Type2Message(message);
            response = this.getType3Message(username2, password, host2, domain2, t2m.getChallenge(), t2m.getFlags(), t2m.getTarget(), t2m.getTargetInfo());
        } else {
            response = this.getType1Message(host2, domain2);
        }
        return response;
    }

    String getType1Message(String host2, String domain2) throws NTLMEngineException {
        try {
            return new Type1Message(domain2, host2).getResponse();
        }
        catch (UnsupportedEncodingException e) {
            throw new NTLMEngineException("Unsupported encoding", e);
        }
    }

    String getType3Message(String user, String password, String host2, String domain2, byte[] nonce, int type2Flags, String target, byte[] targetInformation) throws NTLMEngineException {
        try {
            return new Type3Message(domain2, host2, user, password, nonce, type2Flags, target, targetInformation).getResponse();
        }
        catch (UnsupportedEncodingException e) {
            throw new NTLMEngineException("Unsupported encoding", e);
        }
    }

    String getCredentialCharset() {
        return this.credentialCharset;
    }

    void setCredentialCharset(String credentialCharset) {
        this.credentialCharset = credentialCharset;
    }

    private static String stripDotSuffix(String value2) {
        int index2 = value2.indexOf(".");
        if (index2 != -1) {
            return value2.substring(0, index2);
        }
        return value2;
    }

    private static String convertHost(String host2) {
        return NTLMEngine.stripDotSuffix(host2);
    }

    private static String convertDomain(String domain2) {
        return NTLMEngine.stripDotSuffix(domain2);
    }

    private static int readULong(byte[] src, int index2) throws NTLMEngineException {
        if (src.length < index2 + 4) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for DWORD");
        }
        return src[index2] & 0xFF | (src[index2 + 1] & 0xFF) << 8 | (src[index2 + 2] & 0xFF) << 16 | (src[index2 + 3] & 0xFF) << 24;
    }

    private static int readUShort(byte[] src, int index2) throws NTLMEngineException {
        if (src.length < index2 + 2) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for WORD");
        }
        return src[index2] & 0xFF | (src[index2 + 1] & 0xFF) << 8;
    }

    private static byte[] readSecurityBuffer(byte[] src, int index2) throws NTLMEngineException {
        int length = NTLMEngine.readUShort(src, index2);
        int offset = NTLMEngine.readULong(src, index2 + 4);
        if (src.length < offset + length) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for data item");
        }
        byte[] buffer2 = new byte[length];
        System.arraycopy(src, offset, buffer2, 0, length);
        return buffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeRandomChallenge() throws NTLMEngineException {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] rval = new byte[8];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(rval);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeNTLM2RandomChallenge() throws NTLMEngineException {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] rval = new byte[24];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(rval);
        }
        Arrays.fill(rval, 8, 24, (byte)0);
        return rval;
    }

    static byte[] getLMResponse(String password, byte[] challenge) throws NTLMEngineException {
        byte[] lmHash = NTLMEngine.lmHash(password);
        return NTLMEngine.lmResponse(lmHash, challenge);
    }

    static byte[] getNTLMResponse(String password, byte[] challenge) throws NTLMEngineException {
        byte[] ntlmHash = NTLMEngine.ntlmHash(password);
        return NTLMEngine.lmResponse(ntlmHash, challenge);
    }

    static byte[] getNTLMv2Response(String target, String user, String password, byte[] challenge, byte[] clientChallenge, byte[] targetInformation) throws NTLMEngineException {
        byte[] ntlmv2Hash = NTLMEngine.ntlmv2Hash(target, user, password);
        byte[] blob = NTLMEngine.createBlob(clientChallenge, targetInformation);
        return NTLMEngine.lmv2Response(ntlmv2Hash, challenge, blob);
    }

    static byte[] getLMv2Response(String target, String user, String password, byte[] challenge, byte[] clientChallenge) throws NTLMEngineException {
        byte[] ntlmv2Hash = NTLMEngine.ntlmv2Hash(target, user, password);
        return NTLMEngine.lmv2Response(ntlmv2Hash, challenge, clientChallenge);
    }

    static byte[] getNTLM2SessionResponse(String password, byte[] challenge, byte[] clientChallenge) throws NTLMEngineException {
        try {
            byte[] ntlmHash = NTLMEngine.ntlmHash(password);
            MessageDigest md52 = MessageDigest.getInstance("MD5");
            md52.update(challenge);
            md52.update(clientChallenge);
            byte[] digest2 = md52.digest();
            byte[] sessionHash = new byte[8];
            System.arraycopy(digest2, 0, sessionHash, 0, 8);
            return NTLMEngine.lmResponse(ntlmHash, sessionHash);
        }
        catch (Exception e) {
            if (e instanceof NTLMEngineException) {
                throw (NTLMEngineException)e;
            }
            throw new NTLMEngineException(e.getMessage(), e);
        }
    }

    private static byte[] lmHash(String password) throws NTLMEngineException {
        try {
            byte[] oemPassword = password.toUpperCase(Locale.ENGLISH).getBytes("US-ASCII");
            int length = Math.min(oemPassword.length, 14);
            byte[] keyBytes = new byte[14];
            System.arraycopy(oemPassword, 0, keyBytes, 0, length);
            Key lowKey = NTLMEngine.createDESKey(keyBytes, 0);
            Key highKey = NTLMEngine.createDESKey(keyBytes, 7);
            byte[] magicConstant = "KGS!@#$%".getBytes("US-ASCII");
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, lowKey);
            byte[] lowHash = des.doFinal(magicConstant);
            des.init(1, highKey);
            byte[] highHash = des.doFinal(magicConstant);
            byte[] lmHash = new byte[16];
            System.arraycopy(lowHash, 0, lmHash, 0, 8);
            System.arraycopy(highHash, 0, lmHash, 8, 8);
            return lmHash;
        }
        catch (Exception e) {
            throw new NTLMEngineException(e.getMessage(), e);
        }
    }

    private static byte[] ntlmHash(String password) throws NTLMEngineException {
        try {
            byte[] unicodePassword = password.getBytes("UnicodeLittleUnmarked");
            MD4 md4 = new MD4();
            md4.update(unicodePassword);
            return md4.getOutput();
        }
        catch (UnsupportedEncodingException e) {
            throw new NTLMEngineException("Unicode not supported: " + e.getMessage(), e);
        }
    }

    private static byte[] ntlmv2Hash(String target, String user, String password) throws NTLMEngineException {
        try {
            byte[] ntlmHash = NTLMEngine.ntlmHash(password);
            HMACMD5 hmacMD5 = new HMACMD5(ntlmHash);
            hmacMD5.update(user.toUpperCase(Locale.ENGLISH).getBytes("UnicodeLittleUnmarked"));
            hmacMD5.update(target.getBytes("UnicodeLittleUnmarked"));
            return hmacMD5.getOutput();
        }
        catch (UnsupportedEncodingException e) {
            throw new NTLMEngineException("Unicode not supported! " + e.getMessage(), e);
        }
    }

    private static byte[] lmResponse(byte[] hash2, byte[] challenge) throws NTLMEngineException {
        try {
            byte[] keyBytes = new byte[21];
            System.arraycopy(hash2, 0, keyBytes, 0, 16);
            Key lowKey = NTLMEngine.createDESKey(keyBytes, 0);
            Key middleKey = NTLMEngine.createDESKey(keyBytes, 7);
            Key highKey = NTLMEngine.createDESKey(keyBytes, 14);
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, lowKey);
            byte[] lowResponse = des.doFinal(challenge);
            des.init(1, middleKey);
            byte[] middleResponse = des.doFinal(challenge);
            des.init(1, highKey);
            byte[] highResponse = des.doFinal(challenge);
            byte[] lmResponse = new byte[24];
            System.arraycopy(lowResponse, 0, lmResponse, 0, 8);
            System.arraycopy(middleResponse, 0, lmResponse, 8, 8);
            System.arraycopy(highResponse, 0, lmResponse, 16, 8);
            return lmResponse;
        }
        catch (Exception e) {
            throw new NTLMEngineException(e.getMessage(), e);
        }
    }

    private static byte[] lmv2Response(byte[] hash2, byte[] challenge, byte[] clientData) throws NTLMEngineException {
        HMACMD5 hmacMD5 = new HMACMD5(hash2);
        hmacMD5.update(challenge);
        hmacMD5.update(clientData);
        byte[] mac = hmacMD5.getOutput();
        byte[] lmv2Response = new byte[mac.length + clientData.length];
        System.arraycopy(mac, 0, lmv2Response, 0, mac.length);
        System.arraycopy(clientData, 0, lmv2Response, mac.length, clientData.length);
        return lmv2Response;
    }

    private static byte[] createBlob(byte[] clientChallenge, byte[] targetInformation) {
        byte[] blobSignature = new byte[]{1, 1, 0, 0};
        byte[] reserved = new byte[]{0, 0, 0, 0};
        byte[] unknown1 = new byte[]{0, 0, 0, 0};
        long time = System.currentTimeMillis();
        time += 11644473600000L;
        time *= 10000L;
        byte[] timestamp = new byte[8];
        for (int i = 0; i < 8; ++i) {
            timestamp[i] = (byte)time;
            time >>>= 8;
        }
        byte[] blob = new byte[blobSignature.length + reserved.length + timestamp.length + 8 + unknown1.length + targetInformation.length];
        int offset = 0;
        System.arraycopy(blobSignature, 0, blob, offset, blobSignature.length);
        System.arraycopy(reserved, 0, blob, offset += blobSignature.length, reserved.length);
        System.arraycopy(timestamp, 0, blob, offset += reserved.length, timestamp.length);
        System.arraycopy(clientChallenge, 0, blob, offset += timestamp.length, 8);
        System.arraycopy(unknown1, 0, blob, offset += 8, unknown1.length);
        System.arraycopy(targetInformation, 0, blob, offset += unknown1.length, targetInformation.length);
        return blob;
    }

    private static Key createDESKey(byte[] bytes2, int offset) {
        byte[] keyBytes = new byte[7];
        System.arraycopy(bytes2, offset, keyBytes, 0, 7);
        byte[] material = new byte[]{keyBytes[0], (byte)(keyBytes[0] << 7 | (keyBytes[1] & 0xFF) >>> 1), (byte)(keyBytes[1] << 6 | (keyBytes[2] & 0xFF) >>> 2), (byte)(keyBytes[2] << 5 | (keyBytes[3] & 0xFF) >>> 3), (byte)(keyBytes[3] << 4 | (keyBytes[4] & 0xFF) >>> 4), (byte)(keyBytes[4] << 3 | (keyBytes[5] & 0xFF) >>> 5), (byte)(keyBytes[5] << 2 | (keyBytes[6] & 0xFF) >>> 6), (byte)(keyBytes[6] << 1)};
        NTLMEngine.oddParity(material);
        return new SecretKeySpec(material, "DES");
    }

    private static void oddParity(byte[] bytes2) {
        for (int i = 0; i < bytes2.length; ++i) {
            boolean needsParity;
            byte b = bytes2[i];
            boolean bl = needsParity = ((b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ b >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                bytes2[n] = (byte)(bytes2[n] | 1);
                continue;
            }
            int n = i;
            bytes2[n] = (byte)(bytes2[n] & 0xFFFFFFFE);
        }
    }

    static void writeULong(byte[] buffer2, int value2, int offset) {
        buffer2[offset] = (byte)(value2 & 0xFF);
        buffer2[offset + 1] = (byte)(value2 >> 8 & 0xFF);
        buffer2[offset + 2] = (byte)(value2 >> 16 & 0xFF);
        buffer2[offset + 3] = (byte)(value2 >> 24 & 0xFF);
    }

    static int F(int x, int y, int z) {
        return x & y | ~x & z;
    }

    static int G(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    static int H(int x, int y, int z) {
        return x ^ y ^ z;
    }

    static int rotintlft(int val, int numbits) {
        return val << numbits | val >>> 32 - numbits;
    }

    public String generateType1Msg(String domain2, String workstation) throws NTLMEngineException {
        return this.getType1Message(workstation, domain2);
    }

    public String generateType3Msg(String username2, String password, String domain2, String workstation, String challenge) throws NTLMEngineException {
        Type2Message t2m = new Type2Message(challenge);
        return this.getType3Message(username2, password, workstation, domain2, t2m.getChallenge(), t2m.getFlags(), t2m.getTarget(), t2m.getTargetInfo());
    }

    static {
        SecureRandom rnd = null;
        try {
            rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        RND_GEN = rnd;
        byte[] bytesWithoutNull = new byte[]{};
        try {
            bytesWithoutNull = "NTLMSSP".getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        SIGNATURE = new byte[bytesWithoutNull.length + 1];
        System.arraycopy(bytesWithoutNull, 0, SIGNATURE, 0, bytesWithoutNull.length);
        NTLMEngine.SIGNATURE[bytesWithoutNull.length] = 0;
    }

    static class HMACMD5 {
        protected byte[] ipad;
        protected byte[] opad;
        protected MessageDigest md5;

        HMACMD5(byte[] key) throws NTLMEngineException {
            int i;
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception ex) {
                throw new NTLMEngineException("Error getting md5 message digest implementation: " + ex.getMessage(), ex);
            }
            this.ipad = new byte[64];
            this.opad = new byte[64];
            int keyLength = key.length;
            if (keyLength > 64) {
                this.md5.update(key);
                key = this.md5.digest();
                keyLength = key.length;
            }
            for (i = 0; i < keyLength; ++i) {
                this.ipad[i] = (byte)(key[i] ^ 0x36);
                this.opad[i] = (byte)(key[i] ^ 0x5C);
            }
            while (i < 64) {
                this.ipad[i] = 54;
                this.opad[i] = 92;
                ++i;
            }
            this.md5.reset();
            this.md5.update(this.ipad);
        }

        byte[] getOutput() {
            byte[] digest2 = this.md5.digest();
            this.md5.update(this.opad);
            return this.md5.digest(digest2);
        }

        void update(byte[] input2) {
            this.md5.update(input2);
        }

        void update(byte[] input2, int offset, int length) {
            this.md5.update(input2, offset, length);
        }
    }

    static class MD4 {
        protected int A = 1732584193;
        protected int B = -271733879;
        protected int C = -1732584194;
        protected int D = 271733878;
        protected long count = 0L;
        protected byte[] dataBuffer = new byte[64];

        MD4() {
        }

        void update(byte[] input2) {
            int transferAmt;
            int curBufferPos = (int)(this.count & 0x3FL);
            int inputIndex = 0;
            while (input2.length - inputIndex + curBufferPos >= this.dataBuffer.length) {
                transferAmt = this.dataBuffer.length - curBufferPos;
                System.arraycopy(input2, inputIndex, this.dataBuffer, curBufferPos, transferAmt);
                this.count += (long)transferAmt;
                curBufferPos = 0;
                inputIndex += transferAmt;
                this.processBuffer();
            }
            if (inputIndex < input2.length) {
                transferAmt = input2.length - inputIndex;
                System.arraycopy(input2, inputIndex, this.dataBuffer, curBufferPos, transferAmt);
                this.count += (long)transferAmt;
            }
        }

        byte[] getOutput() {
            int bufferIndex = (int)(this.count & 0x3FL);
            int padLen = bufferIndex < 56 ? 56 - bufferIndex : 120 - bufferIndex;
            byte[] postBytes = new byte[padLen + 8];
            postBytes[0] = -128;
            for (int i = 0; i < 8; ++i) {
                postBytes[padLen + i] = (byte)(this.count * 8L >>> 8 * i);
            }
            this.update(postBytes);
            byte[] result2 = new byte[16];
            NTLMEngine.writeULong(result2, this.A, 0);
            NTLMEngine.writeULong(result2, this.B, 4);
            NTLMEngine.writeULong(result2, this.C, 8);
            NTLMEngine.writeULong(result2, this.D, 12);
            return result2;
        }

        protected void processBuffer() {
            int[] d = new int[16];
            for (int i = 0; i < 16; ++i) {
                d[i] = (this.dataBuffer[i * 4] & 0xFF) + ((this.dataBuffer[i * 4 + 1] & 0xFF) << 8) + ((this.dataBuffer[i * 4 + 2] & 0xFF) << 16) + ((this.dataBuffer[i * 4 + 3] & 0xFF) << 24);
            }
            int AA = this.A;
            int BB = this.B;
            int CC = this.C;
            int DD = this.D;
            this.round1(d);
            this.round2(d);
            this.round3(d);
            this.A += AA;
            this.B += BB;
            this.C += CC;
            this.D += DD;
        }

        protected void round1(int[] d) {
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.F(this.B, this.C, this.D) + d[0], 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.F(this.A, this.B, this.C) + d[1], 7);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.F(this.D, this.A, this.B) + d[2], 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.F(this.C, this.D, this.A) + d[3], 19);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.F(this.B, this.C, this.D) + d[4], 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.F(this.A, this.B, this.C) + d[5], 7);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.F(this.D, this.A, this.B) + d[6], 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.F(this.C, this.D, this.A) + d[7], 19);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.F(this.B, this.C, this.D) + d[8], 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.F(this.A, this.B, this.C) + d[9], 7);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.F(this.D, this.A, this.B) + d[10], 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.F(this.C, this.D, this.A) + d[11], 19);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.F(this.B, this.C, this.D) + d[12], 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.F(this.A, this.B, this.C) + d[13], 7);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.F(this.D, this.A, this.B) + d[14], 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.F(this.C, this.D, this.A) + d[15], 19);
        }

        protected void round2(int[] d) {
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.G(this.B, this.C, this.D) + d[0] + 1518500249, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.G(this.A, this.B, this.C) + d[4] + 1518500249, 5);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.G(this.D, this.A, this.B) + d[8] + 1518500249, 9);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.G(this.C, this.D, this.A) + d[12] + 1518500249, 13);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.G(this.B, this.C, this.D) + d[1] + 1518500249, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.G(this.A, this.B, this.C) + d[5] + 1518500249, 5);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.G(this.D, this.A, this.B) + d[9] + 1518500249, 9);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.G(this.C, this.D, this.A) + d[13] + 1518500249, 13);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.G(this.B, this.C, this.D) + d[2] + 1518500249, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.G(this.A, this.B, this.C) + d[6] + 1518500249, 5);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.G(this.D, this.A, this.B) + d[10] + 1518500249, 9);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.G(this.C, this.D, this.A) + d[14] + 1518500249, 13);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.G(this.B, this.C, this.D) + d[3] + 1518500249, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.G(this.A, this.B, this.C) + d[7] + 1518500249, 5);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.G(this.D, this.A, this.B) + d[11] + 1518500249, 9);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.G(this.C, this.D, this.A) + d[15] + 1518500249, 13);
        }

        protected void round3(int[] d) {
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.H(this.B, this.C, this.D) + d[0] + 1859775393, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.H(this.A, this.B, this.C) + d[8] + 1859775393, 9);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.H(this.D, this.A, this.B) + d[4] + 1859775393, 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.H(this.C, this.D, this.A) + d[12] + 1859775393, 15);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.H(this.B, this.C, this.D) + d[2] + 1859775393, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.H(this.A, this.B, this.C) + d[10] + 1859775393, 9);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.H(this.D, this.A, this.B) + d[6] + 1859775393, 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.H(this.C, this.D, this.A) + d[14] + 1859775393, 15);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.H(this.B, this.C, this.D) + d[1] + 1859775393, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.H(this.A, this.B, this.C) + d[9] + 1859775393, 9);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.H(this.D, this.A, this.B) + d[5] + 1859775393, 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.H(this.C, this.D, this.A) + d[13] + 1859775393, 15);
            this.A = NTLMEngine.rotintlft(this.A + NTLMEngine.H(this.B, this.C, this.D) + d[3] + 1859775393, 3);
            this.D = NTLMEngine.rotintlft(this.D + NTLMEngine.H(this.A, this.B, this.C) + d[11] + 1859775393, 9);
            this.C = NTLMEngine.rotintlft(this.C + NTLMEngine.H(this.D, this.A, this.B) + d[7] + 1859775393, 11);
            this.B = NTLMEngine.rotintlft(this.B + NTLMEngine.H(this.C, this.D, this.A) + d[15] + 1859775393, 15);
        }
    }

    static class Type3Message
    extends NTLMMessage {
        protected int type2Flags;
        protected byte[] domainBytes;
        protected byte[] hostBytes;
        protected byte[] userBytes;
        protected byte[] lmResp;
        protected byte[] ntResp;

        Type3Message(String domain2, String host2, String user, String password, byte[] nonce, int type2Flags, String target, byte[] targetInformation) throws NTLMEngineException {
            this.type2Flags = type2Flags;
            host2 = NTLMEngine.convertHost(host2);
            domain2 = NTLMEngine.convertDomain(domain2);
            try {
                byte[] clientChallenge;
                if (targetInformation != null && target != null) {
                    clientChallenge = NTLMEngine.makeRandomChallenge();
                    this.ntResp = NTLMEngine.getNTLMv2Response(target, user, password, nonce, clientChallenge, targetInformation);
                    this.lmResp = NTLMEngine.getLMv2Response(target, user, password, nonce, clientChallenge);
                } else if ((type2Flags & 0x80000) != 0) {
                    clientChallenge = NTLMEngine.makeNTLM2RandomChallenge();
                    this.ntResp = NTLMEngine.getNTLM2SessionResponse(password, nonce, clientChallenge);
                    this.lmResp = clientChallenge;
                } else {
                    this.ntResp = NTLMEngine.getNTLMResponse(password, nonce);
                    this.lmResp = NTLMEngine.getLMResponse(password, nonce);
                }
            }
            catch (NTLMEngineException e) {
                this.ntResp = new byte[0];
                this.lmResp = NTLMEngine.getLMResponse(password, nonce);
            }
            try {
                this.domainBytes = domain2.toUpperCase(Locale.ENGLISH).getBytes("UnicodeLittleUnmarked");
                this.hostBytes = host2.getBytes("UnicodeLittleUnmarked");
                this.userBytes = user.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new NTLMEngineException("Unicode not supported: " + e.getMessage(), e);
            }
        }

        String getResponse() throws UnsupportedEncodingException {
            int ntRespLen = this.ntResp.length;
            int lmRespLen = this.lmResp.length;
            int domainLen = this.domainBytes.length;
            int hostLen = this.hostBytes.length;
            int userLen = this.userBytes.length;
            int lmRespOffset = 64;
            int ntRespOffset = lmRespOffset + lmRespLen;
            int domainOffset = ntRespOffset + ntRespLen;
            int userOffset = domainOffset + domainLen;
            int hostOffset = userOffset + userLen;
            int finalLength = hostOffset + hostLen;
            this.prepareResponse(finalLength, 3);
            this.addUShort(lmRespLen);
            this.addUShort(lmRespLen);
            this.addULong(lmRespOffset);
            this.addUShort(ntRespLen);
            this.addUShort(ntRespLen);
            this.addULong(ntRespOffset);
            this.addUShort(domainLen);
            this.addUShort(domainLen);
            this.addULong(domainOffset);
            this.addUShort(userLen);
            this.addUShort(userLen);
            this.addULong(userOffset);
            this.addUShort(hostLen);
            this.addUShort(hostLen);
            this.addULong(hostOffset);
            this.addULong(0);
            this.addULong(finalLength);
            this.addULong(0x20000205 | this.type2Flags & 0x80000 | this.type2Flags & 0x10 | this.type2Flags & 0x20 | this.type2Flags & 0x40000000 | this.type2Flags & 0x8000);
            this.addBytes(this.lmResp);
            this.addBytes(this.ntResp);
            this.addBytes(this.domainBytes);
            this.addBytes(this.userBytes);
            this.addBytes(this.hostBytes);
            return super.getResponse();
        }
    }

    static class Type2Message
    extends NTLMMessage {
        protected byte[] challenge = new byte[8];
        protected String target;
        protected byte[] targetInfo;
        protected int flags;

        Type2Message(String message) throws NTLMEngineException {
            super(message, 2);
            byte[] bytes2;
            this.readBytes(this.challenge, 24);
            this.flags = this.readULong(20);
            if ((this.flags & 1) == 0) {
                throw new NTLMEngineException("NTLM type 2 message has flags that make no sense: " + Integer.toString(this.flags));
            }
            this.target = null;
            if (this.getMessageLength() >= 20 && (bytes2 = this.readSecurityBuffer(12)).length != 0) {
                try {
                    this.target = new String(bytes2, "UnicodeLittleUnmarked");
                }
                catch (UnsupportedEncodingException e) {
                    throw new NTLMEngineException(e.getMessage(), e);
                }
            }
            this.targetInfo = null;
            if (this.getMessageLength() >= 48 && (bytes2 = this.readSecurityBuffer(40)).length != 0) {
                this.targetInfo = bytes2;
            }
        }

        byte[] getChallenge() {
            return this.challenge;
        }

        String getTarget() {
            return this.target;
        }

        byte[] getTargetInfo() {
            return this.targetInfo;
        }

        int getFlags() {
            return this.flags;
        }
    }

    static class Type1Message
    extends NTLMMessage {
        protected byte[] hostBytes;
        protected byte[] domainBytes;

        Type1Message(String domain2, String host2) throws NTLMEngineException {
            try {
                host2 = NTLMEngine.convertHost(host2);
                domain2 = NTLMEngine.convertDomain(domain2);
                this.hostBytes = host2.getBytes("UnicodeLittleUnmarked");
                this.domainBytes = domain2.toUpperCase(Locale.ENGLISH).getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new NTLMEngineException("Unicode unsupported: " + e.getMessage(), e);
            }
        }

        String getResponse() throws UnsupportedEncodingException {
            int finalLength = 32 + this.hostBytes.length + this.domainBytes.length;
            this.prepareResponse(finalLength, 1);
            this.addULong(537395765);
            this.addUShort(this.domainBytes.length);
            this.addUShort(this.domainBytes.length);
            this.addULong(this.hostBytes.length + 32);
            this.addUShort(this.hostBytes.length);
            this.addUShort(this.hostBytes.length);
            this.addULong(32);
            this.addBytes(this.hostBytes);
            this.addBytes(this.domainBytes);
            return super.getResponse();
        }
    }

    static class NTLMMessage {
        private byte[] messageContents = null;
        private int currentOutputPosition = 0;

        NTLMMessage() {
        }

        NTLMMessage(String messageBody, int expectedType) throws NTLMEngineException {
            this.messageContents = Base64.decode(messageBody);
            if (this.messageContents.length < SIGNATURE.length) {
                throw new NTLMEngineException("NTLM message decoding error - packet too short");
            }
            for (int i = 0; i < SIGNATURE.length; ++i) {
                if (this.messageContents[i] == SIGNATURE[i]) continue;
                throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
            }
            int type = this.readULong(SIGNATURE.length);
            if (type != expectedType) {
                throw new NTLMEngineException("NTLM type " + Integer.toString(expectedType) + " message expected - instead got type " + Integer.toString(type));
            }
            this.currentOutputPosition = this.messageContents.length;
        }

        protected int getPreambleLength() {
            return SIGNATURE.length + 4;
        }

        protected int getMessageLength() {
            return this.currentOutputPosition;
        }

        protected byte readByte(int position) throws NTLMEngineException {
            if (this.messageContents.length < position + 1) {
                throw new NTLMEngineException("NTLM: Message too short");
            }
            return this.messageContents[position];
        }

        protected void readBytes(byte[] buffer2, int position) throws NTLMEngineException {
            if (this.messageContents.length < position + buffer2.length) {
                throw new NTLMEngineException("NTLM: Message too short");
            }
            System.arraycopy(this.messageContents, position, buffer2, 0, buffer2.length);
        }

        protected int readUShort(int position) throws NTLMEngineException {
            return NTLMEngine.readUShort(this.messageContents, position);
        }

        protected int readULong(int position) throws NTLMEngineException {
            return NTLMEngine.readULong(this.messageContents, position);
        }

        protected byte[] readSecurityBuffer(int position) throws NTLMEngineException {
            return NTLMEngine.readSecurityBuffer(this.messageContents, position);
        }

        protected void prepareResponse(int maxlength, int messageType) {
            this.messageContents = new byte[maxlength];
            this.currentOutputPosition = 0;
            this.addBytes(SIGNATURE);
            this.addULong(messageType);
        }

        protected void addByte(byte b) {
            this.messageContents[this.currentOutputPosition] = b;
            ++this.currentOutputPosition;
        }

        protected void addBytes(byte[] bytes2) {
            for (int i = 0; i < bytes2.length; ++i) {
                this.messageContents[this.currentOutputPosition] = bytes2[i];
                ++this.currentOutputPosition;
            }
        }

        protected void addUShort(int value2) {
            this.addByte((byte)(value2 & 0xFF));
            this.addByte((byte)(value2 >> 8 & 0xFF));
        }

        protected void addULong(int value2) {
            this.addByte((byte)(value2 & 0xFF));
            this.addByte((byte)(value2 >> 8 & 0xFF));
            this.addByte((byte)(value2 >> 16 & 0xFF));
            this.addByte((byte)(value2 >> 24 & 0xFF));
        }

        String getResponse() throws UnsupportedEncodingException {
            byte[] resp;
            if (this.messageContents.length > this.currentOutputPosition) {
                byte[] tmp = new byte[this.currentOutputPosition];
                for (int i = 0; i < this.currentOutputPosition; ++i) {
                    tmp[i] = this.messageContents[i];
                }
                resp = tmp;
            } else {
                resp = this.messageContents;
            }
            return Base64.encode(resp);
        }
    }
}

