/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Part;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.UpgradeHandler;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyConnectionsPool;
import com.ning.http.client.providers.grizzly.GrizzlyResponse;
import com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.GrizzlyResponseHeaders;
import com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.ning.http.client.providers.grizzly.TransportCustomizer;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketCloseCodeReasonListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketPingListener;
import com.ning.http.client.websocket.WebSocketPongListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.multipart.MultipartBody;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtil;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.SslUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.BufferOutputStream;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.glassfish.grizzly.websockets.Version;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyAsyncHttpProvider.class);
    private static final boolean SEND_FILE_SUPPORT = false;
    private static final Attribute<HttpTransactionContext> REQUEST_STATE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpTransactionContext.class.getName());
    private static final NTLMEngine ntlmEngine = new NTLMEngine();
    public static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Remotely Closed");
    private final BodyHandlerFactory bodyHandlerFactory = new BodyHandlerFactory();
    private final TCPNIOTransport clientTransport;
    private final AsyncHttpClientConfig clientConfig;
    private final ConnectionManager connectionManager;
    DelayedExecutor.Resolver<Connection> resolver;
    private DelayedExecutor timeoutExecutor;

    public GrizzlyAsyncHttpProvider(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        this.clientTransport = builder.build();
        this.initializeTransport(clientConfig);
        this.connectionManager = new ConnectionManager(this, this.clientTransport);
        try {
            this.clientTransport.start();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public <T> ListenableFuture<T> execute(final Request request, final AsyncHandler<T> handler) throws IOException {
        GrizzlyResponseFuture future2;
        block5: {
            if (this.clientTransport.isStopped()) {
                throw new IOException("AsyncHttpClient has been closed.");
            }
            ProxyServer proxy = ProxyUtils.getProxyServer(this.clientConfig, request);
            future2 = new GrizzlyResponseFuture(this, request, handler, proxy);
            future2.setDelegate(SafeFutureImpl.create());
            CompletionHandler<Connection> connectHandler = new CompletionHandler<Connection>(){

                public void cancelled() {
                    future2.cancel(true);
                }

                public void failed(Throwable throwable) {
                    future2.abort(throwable);
                }

                public void completed(Connection c) {
                    block5: {
                        try {
                            GrizzlyAsyncHttpProvider.this.execute(c, request, handler, future2, true);
                        }
                        catch (Exception e) {
                            if (e instanceof RuntimeException) {
                                this.failed(e);
                            } else if (e instanceof IOException) {
                                this.failed(e);
                            }
                            if (!LOGGER.isWarnEnabled()) break block5;
                            LOGGER.warn(e.toString(), e);
                        }
                    }
                }

                public void updated(Connection c) {
                }
            };
            try {
                this.connectionManager.doAsyncTrackedConnection(request, future2, connectHandler);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn(e.toString(), e);
            }
        }
        return future2;
    }

    @Override
    public void close() {
        try {
            this.connectionManager.destroy();
            this.clientTransport.shutdownNow();
            ExecutorService service = this.clientConfig.executorService();
            if (service != null) {
                service.shutdown();
            }
            if (this.timeoutExecutor != null) {
                this.timeoutExecutor.stop();
                this.timeoutExecutor.getThreadPool().shutdownNow();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers2, List<HttpResponseBodyPart> bodyParts) {
        return new GrizzlyResponse(status, headers2, bodyParts);
    }

    protected <T> ListenableFuture<T> execute(Connection c, Request request, AsyncHandler<T> handler, GrizzlyResponseFuture<T> future2, boolean forceTxContextExist) throws IOException {
        block5: {
            try {
                if (forceTxContextExist && HttpTransactionContext.get(c) == null) {
                    HttpTransactionContext.set(c, new HttpTransactionContext(this, future2, request, handler));
                }
                c.write((Object)request, this.createWriteCompletionHandler(future2));
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn(e.toString(), e);
            }
        }
        return future2;
    }

    protected void initializeTransport(final AsyncHttpClientConfig clientConfig) {
        SSLContext context;
        boolean defaultSecState;
        FilterChainBuilder fcb = FilterChainBuilder.stateless();
        fcb.add((Filter)new TransportFilter());
        final int timeout2 = clientConfig.getRequestTimeoutInMs();
        if (timeout2 > 0) {
            int delay = 500;
            if (timeout2 < delay) {
                delay = timeout2 - 10;
            }
            this.timeoutExecutor = IdleTimeoutFilter.createDefaultIdleDelayedExecutor((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
            this.timeoutExecutor.start();
            IdleTimeoutFilter.TimeoutResolver timeoutResolver = new IdleTimeoutFilter.TimeoutResolver(){

                public long getTimeout(FilterChainContext ctx) {
                    HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
                    if (context != null) {
                        long timeout22;
                        if (context.isWSRequest) {
                            return clientConfig.getWebSocketIdleTimeoutInMs();
                        }
                        PerRequestConfig config2 = context.request.getPerRequestConfig();
                        if (config2 != null && (timeout22 = (long)config2.getRequestTimeoutInMs()) > 0L) {
                            return timeout22;
                        }
                    }
                    return timeout2;
                }
            };
            IdleTimeoutFilter timeoutFilter = new IdleTimeoutFilter(this.timeoutExecutor, timeoutResolver, new IdleTimeoutFilter.TimeoutHandler(){

                public void onTimeout(Connection connection) {
                    GrizzlyAsyncHttpProvider.this.timeout(connection);
                }
            });
            fcb.add((Filter)timeoutFilter);
            this.resolver = timeoutFilter.getResolver();
        }
        boolean bl = defaultSecState = (context = clientConfig.getSSLContext()) != null;
        if (context == null) {
            try {
                context = SslUtils.getSSLContext();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        SSLEngineConfigurator configurator2 = new SSLEngineConfigurator(context, true, false, false);
        SwitchingSSLFilter filter2 = new SwitchingSSLFilter(configurator2, defaultSecState);
        fcb.add((Filter)filter2);
        GrizzlyAsyncHttpProviderConfig providerConfig = clientConfig.getAsyncHttpProviderConfig() instanceof GrizzlyAsyncHttpProviderConfig ? (GrizzlyAsyncHttpProviderConfig)clientConfig.getAsyncHttpProviderConfig() : new GrizzlyAsyncHttpProviderConfig();
        AsyncHttpClientEventFilter eventFilter = new AsyncHttpClientEventFilter(this, (Integer)providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.MAX_HTTP_PACKET_HEADER_SIZE));
        AsyncHttpClientFilter clientFilter = new AsyncHttpClientFilter(clientConfig);
        ContentEncoding[] encodings = eventFilter.getContentEncodings();
        if (encodings.length > 0) {
            for (ContentEncoding encoding : encodings) {
                eventFilter.removeContentEncoding(encoding);
            }
        }
        if (clientConfig.isCompressionEnabled()) {
            eventFilter.addContentEncoding((ContentEncoding)new GZipContentEncoding(512, 512, (EncodingFilter)new ClientEncodingFilter()));
        }
        fcb.add((Filter)eventFilter);
        fcb.add((Filter)clientFilter);
        this.clientTransport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(-2);
        this.clientTransport.setNIOChannelDistributor((NIOChannelDistributor)new RoundRobinConnectionDistributor((NIOTransport)this.clientTransport, false, false));
        int kernelThreadsCount = clientConfig.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
        this.clientTransport.setSelectorRunnersCount(kernelThreadsCount);
        this.clientTransport.setKernelThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(kernelThreadsCount).setMaxPoolSize(kernelThreadsCount).setPoolName("grizzly-ahc-kernel"));
        TransportCustomizer customizer = (TransportCustomizer)providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER);
        if (customizer != null) {
            customizer.customize(this.clientTransport, fcb);
        } else {
            this.doDefaultTransportConfig();
        }
        fcb.add((Filter)new WebSocketFilter());
        this.clientTransport.setProcessor((Processor)fcb.build());
    }

    void touchConnection(Connection c, Request request) {
        PerRequestConfig config2 = request.getPerRequestConfig();
        if (config2 != null) {
            long timeout2 = config2.getRequestTimeoutInMs();
            if (timeout2 > 0L) {
                long newTimeout = System.currentTimeMillis() + timeout2;
                if (this.resolver != null) {
                    this.resolver.setTimeoutMillis((Object)c, newTimeout);
                }
            }
        } else {
            long timeout3 = this.clientConfig.getRequestTimeoutInMs();
            if (timeout3 > 0L && this.resolver != null) {
                this.resolver.setTimeoutMillis((Object)c, System.currentTimeMillis() + timeout3);
            }
        }
    }

    private static boolean configSendFileSupport() {
        return (!System.getProperty("os.name").equalsIgnoreCase("linux") || GrizzlyAsyncHttpProvider.linuxSendFileSupported()) && !System.getProperty("os.name").equalsIgnoreCase("HP-UX");
    }

    private static boolean linuxSendFileSupported() {
        String version2 = System.getProperty("java.version");
        if (version2.startsWith("1.6")) {
            int idx = version2.indexOf(95);
            if (idx == -1) {
                return false;
            }
            int patchRev = Integer.parseInt(version2.substring(idx + 1));
            return patchRev >= 18;
        }
        return version2.startsWith("1.7") || version2.startsWith("1.8");
    }

    private void doDefaultTransportConfig() {
        ExecutorService service = this.clientConfig.executorService();
        if (service != null) {
            this.clientTransport.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
            this.clientTransport.setWorkerThreadPool(service);
        } else {
            this.clientTransport.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
        }
    }

    private <T> CompletionHandler<WriteResult> createWriteCompletionHandler(final GrizzlyResponseFuture<T> future2) {
        return new CompletionHandler<WriteResult>(){

            public void cancelled() {
                future2.cancel(true);
            }

            public void failed(Throwable throwable) {
                future2.abort(throwable);
            }

            public void completed(WriteResult result2) {
            }

            public void updated(WriteResult result2) {
            }
        };
    }

    void timeout(Connection c) {
        HttpTransactionContext context = HttpTransactionContext.remove(c);
        context.abort(new TimeoutException("Timeout exceeded"));
    }

    static int getPort(URI uri, int p) {
        int port = p;
        if (port == -1) {
            String protocol = uri.getScheme().toLowerCase(Locale.ENGLISH);
            if ("http".equals(protocol) || "ws".equals(protocol)) {
                port = 80;
            } else if ("https".equals(protocol) || "wss".equals(protocol)) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown protocol: " + protocol);
            }
        }
        return port;
    }

    boolean sendRequest(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket, BodyHandler bodyHandler) throws IOException {
        boolean isWriteComplete = true;
        if (bodyHandler != null) {
            HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
            context.bodyHandler = bodyHandler;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            isWriteComplete = bodyHandler.doHandle(ctx, request, requestPacket);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            ctx.write((Object)requestPacket, ctx.getTransportContext().getCompletionHandler());
        }
        return isWriteComplete;
    }

    public static void main(String[] args) {
        SecureRandom secureRandom = new SecureRandom();
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, secureRandom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AsyncHttpClientConfig config2 = new AsyncHttpClientConfig.Builder().setConnectionTimeoutInMs(5000).setSSLContext(sslContext).build();
        AsyncHttpClient client2 = new AsyncHttpClient(new GrizzlyAsyncHttpProvider(config2), config2);
        try {
            long start2 = System.currentTimeMillis();
            try {
                client2.executeRequest(client2.prepareGet("http://www.google.com").build()).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            System.out.println("COMPLETE: " + (System.currentTimeMillis() - start2) + "ms");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        REMOTELY_CLOSED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }

    private static final class AHCWebSocketListenerAdapter
    implements org.glassfish.grizzly.websockets.WebSocketListener {
        private final WebSocketListener ahcListener;
        private final GrizzlyWebSocketAdapter webSocket;
        private final StringBuilder stringBuffer;
        private final ByteArrayOutputStream byteArrayOutputStream;

        AHCWebSocketListenerAdapter(WebSocketListener ahcListener, GrizzlyWebSocketAdapter webSocket) {
            this.ahcListener = ahcListener;
            this.webSocket = webSocket;
            if (webSocket.bufferFragments) {
                this.stringBuffer = new StringBuilder();
                this.byteArrayOutputStream = new ByteArrayOutputStream();
            } else {
                this.stringBuffer = null;
                this.byteArrayOutputStream = null;
            }
        }

        public void onClose(WebSocket gWebSocket, DataFrame dataFrame) {
            try {
                if (this.ahcListener instanceof WebSocketCloseCodeReasonListener) {
                    ClosingFrame cf = (ClosingFrame)ClosingFrame.class.cast(dataFrame);
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(this.ahcListener)).onClose(this.webSocket, cf.getCode(), cf.getReason());
                } else {
                    this.ahcListener.onClose(this.webSocket);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onConnect(WebSocket gWebSocket) {
            try {
                this.ahcListener.onOpen(this.webSocket);
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onMessage(WebSocket webSocket, String s2) {
            try {
                if (this.ahcListener instanceof WebSocketTextListener) {
                    ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onMessage(s2);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onMessage(WebSocket webSocket, byte[] bytes2) {
            try {
                if (this.ahcListener instanceof WebSocketByteListener) {
                    ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onMessage(bytes2);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onPing(WebSocket webSocket, byte[] bytes2) {
            try {
                if (this.ahcListener instanceof WebSocketPingListener) {
                    ((WebSocketPingListener)WebSocketPingListener.class.cast(this.ahcListener)).onPing(bytes2);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onPong(WebSocket webSocket, byte[] bytes2) {
            try {
                if (this.ahcListener instanceof WebSocketPongListener) {
                    ((WebSocketPongListener)WebSocketPongListener.class.cast(this.ahcListener)).onPong(bytes2);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFragment(WebSocket webSocket, String s2, boolean last2) {
            block8: {
                try {
                    if (this.webSocket.bufferFragments) {
                        GrizzlyWebSocketAdapter grizzlyWebSocketAdapter = this.webSocket;
                        synchronized (grizzlyWebSocketAdapter) {
                            this.stringBuffer.append(s2);
                            if (last2 && this.ahcListener instanceof WebSocketTextListener) {
                                String message = this.stringBuffer.toString();
                                this.stringBuffer.setLength(0);
                                ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onMessage(message);
                            }
                            break block8;
                        }
                    }
                    if (this.ahcListener instanceof WebSocketTextListener) {
                        ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onFragment(s2, last2);
                    }
                }
                catch (Throwable e) {
                    this.ahcListener.onError(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFragment(WebSocket webSocket, byte[] bytes2, boolean last2) {
            block8: {
                try {
                    if (this.webSocket.bufferFragments) {
                        GrizzlyWebSocketAdapter grizzlyWebSocketAdapter = this.webSocket;
                        synchronized (grizzlyWebSocketAdapter) {
                            this.byteArrayOutputStream.write(bytes2);
                            if (last2 && this.ahcListener instanceof WebSocketByteListener) {
                                byte[] bytesLocal = this.byteArrayOutputStream.toByteArray();
                                this.byteArrayOutputStream.reset();
                                ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onMessage(bytesLocal);
                            }
                            break block8;
                        }
                    }
                    if (this.ahcListener instanceof WebSocketByteListener) {
                        ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onFragment(bytes2, last2);
                    }
                }
                catch (Throwable e) {
                    this.ahcListener.onError(e);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AHCWebSocketListenerAdapter that = (AHCWebSocketListenerAdapter)o;
            if (this.ahcListener != null ? !this.ahcListener.equals(that.ahcListener) : that.ahcListener != null) {
                return false;
            }
            return !(this.webSocket != null ? !this.webSocket.equals(that.webSocket) : that.webSocket != null);
        }

        public int hashCode() {
            int result2 = this.ahcListener != null ? this.ahcListener.hashCode() : 0;
            result2 = 31 * result2 + (this.webSocket != null ? this.webSocket.hashCode() : 0);
            return result2;
        }
    }

    private static final class GrizzlyWebSocketAdapter
    implements com.ning.http.client.websocket.WebSocket {
        final SimpleWebSocket gWebSocket;
        final boolean bufferFragments;

        GrizzlyWebSocketAdapter(SimpleWebSocket gWebSocket, boolean bufferFragments) {
            this.gWebSocket = gWebSocket;
            this.bufferFragments = bufferFragments;
        }

        public com.ning.http.client.websocket.WebSocket sendMessage(byte[] message) {
            this.gWebSocket.send(message);
            return this;
        }

        public com.ning.http.client.websocket.WebSocket stream(byte[] fragment, boolean last2) {
            if (MiscUtil.isNonEmpty(fragment)) {
                this.gWebSocket.stream(last2, fragment, 0, fragment.length);
            }
            return this;
        }

        public com.ning.http.client.websocket.WebSocket stream(byte[] fragment, int offset, int len2, boolean last2) {
            if (MiscUtil.isNonEmpty(fragment)) {
                this.gWebSocket.stream(last2, fragment, offset, len2);
            }
            return this;
        }

        public com.ning.http.client.websocket.WebSocket sendTextMessage(String message) {
            this.gWebSocket.send(message);
            return this;
        }

        public com.ning.http.client.websocket.WebSocket streamText(String fragment, boolean last2) {
            this.gWebSocket.stream(last2, fragment);
            return this;
        }

        public com.ning.http.client.websocket.WebSocket sendPing(byte[] payload) {
            this.gWebSocket.sendPing(payload);
            return this;
        }

        public com.ning.http.client.websocket.WebSocket sendPong(byte[] payload) {
            this.gWebSocket.sendPong(payload);
            return this;
        }

        public com.ning.http.client.websocket.WebSocket addWebSocketListener(WebSocketListener l) {
            this.gWebSocket.add((org.glassfish.grizzly.websockets.WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
            return this;
        }

        public com.ning.http.client.websocket.WebSocket removeWebSocketListener(WebSocketListener l) {
            this.gWebSocket.remove((org.glassfish.grizzly.websockets.WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
            return this;
        }

        public boolean isOpen() {
            return this.gWebSocket.isConnected();
        }

        public void close() {
            this.gWebSocket.close();
        }
    }

    private static final class GrizzlyTransferAdapter
    extends TransferCompletionHandler.TransferAdapter {
        public GrizzlyTransferAdapter(FluentCaseInsensitiveStringsMap headers2) throws IOException {
            super(headers2);
        }

        public void getBytes(byte[] bytes2) {
        }
    }

    static final class SwitchingSSLFilter
    extends SSLFilter {
        private final boolean secureByDefault;
        final Attribute<Boolean> CONNECTION_IS_SECURE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(SwitchingSSLFilter.class.getName());

        SwitchingSSLFilter(SSLEngineConfigurator clientConfig, boolean secureByDefault) {
            super(null, clientConfig);
            this.secureByDefault = secureByDefault;
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (event.type() == SSLSwitchingEvent.class) {
                SSLSwitchingEvent se = (SSLSwitchingEvent)event;
                this.CONNECTION_IS_SECURE.set((AttributeStorage)se.connection, (Object)se.secure);
                return ctx.getStopAction();
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            if (this.isSecure(ctx.getConnection())) {
                return super.handleRead(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            if (this.isSecure(ctx.getConnection())) {
                return super.handleWrite(ctx);
            }
            return ctx.getInvokeAction();
        }

        public void onFilterChainChanged(FilterChain filterChain) {
        }

        private boolean isSecure(Connection c) {
            Boolean secStatus = (Boolean)this.CONNECTION_IS_SECURE.get((AttributeStorage)c);
            if (secStatus == null) {
                secStatus = this.secureByDefault;
            }
            return secStatus;
        }

        static final class SSLSwitchingEvent
        implements FilterChainEvent {
            final boolean secure;
            final Connection connection;

            SSLSwitchingEvent(boolean secure2, Connection c) {
                this.secure = secure2;
                this.connection = c;
            }

            public Object type() {
                return SSLSwitchingEvent.class;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionManager {
        private static final Attribute<Boolean> DO_NOT_CACHE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(ConnectionManager.class.getName());
        private final ConnectionsPool<String, Connection> pool;
        private final TCPNIOConnectorHandler connectionHandler;
        private final ConnectionMonitor connectionMonitor;
        private final GrizzlyAsyncHttpProvider provider;

        ConnectionManager(GrizzlyAsyncHttpProvider provider, TCPNIOTransport transport) {
            ConnectionsPool<?, ?> pool;
            this.provider = provider;
            AsyncHttpClientConfig config2 = provider.clientConfig;
            ConnectionsPool<String, Connection> connectionPool = config2.getAllowPoolingConnection() ? ((pool = config2.getConnectionsPool()) != null ? pool : new GrizzlyConnectionsPool(config2)) : new NonCachingPool();
            this.pool = connectionPool;
            this.connectionHandler = TCPNIOConnectorHandler.builder((TCPNIOTransport)transport).build();
            int maxConns = provider.clientConfig.getMaxTotalConnections();
            this.connectionMonitor = new ConnectionMonitor(maxConns);
        }

        static void markConnectionAsDoNotCache(Connection c) {
            DO_NOT_CACHE.set((AttributeStorage)c, (Object)Boolean.TRUE);
        }

        static boolean isConnectionCacheable(Connection c) {
            Boolean canCache = (Boolean)DO_NOT_CACHE.get((AttributeStorage)c);
            return canCache != null ? canCache : false;
        }

        void doAsyncTrackedConnection(Request request, GrizzlyResponseFuture requestFuture, CompletionHandler<Connection> connectHandler) throws IOException, ExecutionException, InterruptedException {
            Connection c = this.pool.poll(ConnectionManager.getPoolKey(request, requestFuture.getProxy()));
            if (c == null) {
                if (!this.connectionMonitor.acquire()) {
                    throw new IOException("Max connections exceeded");
                }
                this.doAsyncConnect(request, requestFuture, connectHandler);
            } else {
                this.provider.touchConnection(c, request);
                connectHandler.completed((Object)c);
            }
        }

        Connection obtainConnection(Request request, GrizzlyResponseFuture requestFuture) throws IOException, ExecutionException, InterruptedException, TimeoutException {
            Connection c = this.obtainConnection0(request, requestFuture);
            DO_NOT_CACHE.set((AttributeStorage)c, (Object)Boolean.TRUE);
            return c;
        }

        void doAsyncConnect(Request request, GrizzlyResponseFuture requestFuture, CompletionHandler<Connection> connectHandler) throws IOException, ExecutionException, InterruptedException {
            int port;
            ProxyServer proxy = requestFuture.getProxy();
            URI uri = request.getURI();
            String host2 = proxy != null ? proxy.getHost() : uri.getHost();
            int n = port = proxy != null ? proxy.getPort() : uri.getPort();
            if (request.getLocalAddress() != null) {
                this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host2, GrizzlyAsyncHttpProvider.getPort(uri, port)), (SocketAddress)new InetSocketAddress(request.getLocalAddress(), 0), this.createConnectionCompletionHandler(request, requestFuture, connectHandler));
            } else {
                this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host2, GrizzlyAsyncHttpProvider.getPort(uri, port)), this.createConnectionCompletionHandler(request, requestFuture, connectHandler));
            }
        }

        private Connection obtainConnection0(Request request, GrizzlyResponseFuture requestFuture) throws IOException, ExecutionException, InterruptedException, TimeoutException {
            URI uri = request.getURI();
            ProxyServer proxy = requestFuture.getProxy();
            String host2 = proxy != null ? proxy.getHost() : uri.getHost();
            int port = proxy != null ? proxy.getPort() : uri.getPort();
            int cTimeout = this.provider.clientConfig.getConnectionTimeoutInMs();
            FutureImpl future2 = Futures.createSafeFuture();
            CompletionHandler ch = Futures.toCompletionHandler((FutureImpl)future2, this.createConnectionCompletionHandler(request, requestFuture, null));
            if (cTimeout > 0) {
                this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host2, GrizzlyAsyncHttpProvider.getPort(uri, port)), ch);
                return (Connection)future2.get((long)cTimeout, TimeUnit.MILLISECONDS);
            }
            this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host2, GrizzlyAsyncHttpProvider.getPort(uri, port)), ch);
            return (Connection)future2.get();
        }

        boolean returnConnection(Request request, Connection c) {
            boolean result2;
            ProxyServer proxyServer = ProxyUtils.getProxyServer(this.provider.clientConfig, request);
            boolean bl = result2 = DO_NOT_CACHE.get((AttributeStorage)c) == null && this.pool.offer(ConnectionManager.getPoolKey(request, proxyServer), c);
            if (result2 && this.provider.resolver != null) {
                this.provider.resolver.setTimeoutMillis((Object)c, IdleTimeoutFilter.FOREVER.longValue());
            }
            return result2;
        }

        boolean canReturnConnection(Connection c) {
            return DO_NOT_CACHE.get((AttributeStorage)c) != null || this.pool.canCacheConnection();
        }

        void destroy() {
            this.pool.destroy();
        }

        CompletionHandler<Connection> createConnectionCompletionHandler(final Request request, final GrizzlyResponseFuture future2, final CompletionHandler<Connection> wrappedHandler) {
            return new CompletionHandler<Connection>(){

                public void cancelled() {
                    if (wrappedHandler != null) {
                        wrappedHandler.cancelled();
                    } else {
                        future2.cancel(true);
                    }
                }

                public void failed(Throwable throwable) {
                    if (wrappedHandler != null) {
                        wrappedHandler.failed(throwable);
                    } else {
                        future2.abort(throwable);
                    }
                }

                public void completed(Connection connection) {
                    future2.setConnection(connection);
                    ConnectionManager.this.provider.touchConnection(connection, request);
                    if (wrappedHandler != null) {
                        connection.addCloseListener((Connection.CloseListener)ConnectionManager.this.connectionMonitor);
                        wrappedHandler.completed((Object)connection);
                    }
                }

                public void updated(Connection result2) {
                    if (wrappedHandler != null) {
                        wrappedHandler.updated((Object)result2);
                    }
                }
            };
        }

        private static String getPoolKey(Request request, ProxyServer proxyServer) {
            String serverPart = request.getConnectionPoolKeyStrategy().getKey(request.getURI());
            return proxyServer != null ? proxyServer.getUrl() + serverPart : serverPart;
        }

        private static class ConnectionMonitor
        implements Connection.CloseListener {
            private final Semaphore connections;

            ConnectionMonitor(int maxConnections) {
                this.connections = maxConnections != -1 ? new Semaphore(maxConnections) : null;
            }

            public boolean acquire() {
                return this.connections == null || this.connections.tryAcquire();
            }

            public void onClosed(Connection connection, Connection.CloseType closeType) throws IOException {
                if (this.connections != null) {
                    this.connections.release();
                }
            }
        }
    }

    private static final class BodyGeneratorBodyHandler
    extends BodyHandler {
        private BodyGeneratorBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getBodyGenerator() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            BodyGenerator generator = request.getBodyGenerator();
            Body bodyLocal = generator.createBody();
            long len2 = bodyLocal.getContentLength();
            if (len2 >= 0L) {
                requestPacket.setContentLengthLong(len2);
            } else {
                requestPacket.setChunked(true);
            }
            MemoryManager mm = ctx.getMemoryManager();
            boolean last2 = false;
            while (!last2) {
                Buffer buffer2 = mm.allocate(MAX_CHUNK_SIZE);
                buffer2.allowBufferDispose(true);
                long readBytes = bodyLocal.read(buffer2.toByteBuffer());
                if (readBytes > 0L) {
                    buffer2.position((int)readBytes);
                    buffer2.trim();
                } else {
                    buffer2.dispose();
                    if (readBytes < 0L) {
                        last2 = true;
                        buffer2 = Buffers.EMPTY_BUFFER;
                    } else {
                        if (generator instanceof FeedableBodyGenerator) {
                            ((FeedableBodyGenerator)generator).initializeAsynchronousTransfer(ctx, requestPacket);
                            return false;
                        }
                        throw new IllegalStateException("BodyGenerator unexpectedly returned 0 bytes available");
                    }
                }
                HttpContent content = requestPacket.httpContentBuilder().content(buffer2).last(last2).build();
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class FileBodyHandler
    extends BodyHandler {
        private FileBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getFile() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doHandle(FilterChainContext ctx, Request request, final HttpRequestPacket requestPacket) throws IOException {
            File f2 = request.getFile();
            requestPacket.setContentLengthLong(f2.length());
            final HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
            if (!SEND_FILE_SUPPORT || requestPacket.isSecure()) {
                FileInputStream fis = new FileInputStream(request.getFile());
                MemoryManager mm = ctx.getMemoryManager();
                AtomicInteger written = new AtomicInteger();
                boolean last2 = false;
                try {
                    byte[] buf = new byte[MAX_CHUNK_SIZE];
                    while (!last2) {
                        Buffer b = null;
                        int read2 = fis.read(buf);
                        if (read2 < 0) {
                            last2 = true;
                            b = Buffers.EMPTY_BUFFER;
                        }
                        if (b != Buffers.EMPTY_BUFFER) {
                            written.addAndGet(read2);
                            b = Buffers.wrap((MemoryManager)mm, (byte[])buf, (int)0, (int)read2);
                        }
                        HttpContent content = requestPacket.httpContentBuilder().content(b).last(last2).build();
                        ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
                    }
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            ctx.write((Object)new FileTransfer(f2), (CompletionHandler)new EmptyCompletionHandler<WriteResult>(){

                public void updated(WriteResult result2) {
                    AsyncHandler handler = context.handler;
                    if (handler instanceof TransferCompletionHandler) {
                        long written = result2.getWrittenSize();
                        long total2 = context.totalBodyWritten.addAndGet(written);
                        ((TransferCompletionHandler)handler).onContentWriteProgress(written, total2, requestPacket.getContentLength());
                    }
                }
            });
            return true;
        }

        protected long getContentLength(Request request) {
            return request.getContentLength() >= 0L ? request.getContentLength() : request.getFile().length();
        }
    }

    private static final class PartsBodyHandler
    extends BodyHandler {
        private PartsBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return MiscUtil.isNonEmpty(request.getParts());
        }

        public boolean doHandle(final FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            final List<Part> parts = request.getParts();
            MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(parts, request.getHeaders());
            final long contentLength = mre.getContentLength();
            final String contentType2 = mre.getContentType();
            requestPacket.setContentLengthLong(contentLength);
            requestPacket.setContentType(contentType2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST(modified): contentLength={}, contentType={}", new Object[]{requestPacket.getContentLength(), requestPacket.getContentType()});
            }
            FeedableBodyGenerator generator = new FeedableBodyGenerator(){

                public Body createBody() throws IOException {
                    return new MultipartBody(parts, contentType2, contentLength);
                }
            };
            generator.setFeeder(new FeedableBodyGenerator.BaseFeeder(generator){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void flush() throws IOException {
                    Body bodyLocal = this.feedableBodyGenerator.createBody();
                    try {
                        MemoryManager mm = ctx.getMemoryManager();
                        boolean last2 = false;
                        while (!last2) {
                            Buffer buffer2 = mm.allocate(BodyHandler.MAX_CHUNK_SIZE);
                            buffer2.allowBufferDispose(true);
                            long readBytes = bodyLocal.read(buffer2.toByteBuffer());
                            if (readBytes > 0L) {
                                buffer2.position((int)readBytes);
                                buffer2.trim();
                            } else {
                                buffer2.dispose();
                                if (readBytes < 0L) {
                                    last2 = true;
                                    buffer2 = Buffers.EMPTY_BUFFER;
                                } else {
                                    throw new IllegalStateException("MultipartBody unexpectedly returned 0 bytes available");
                                }
                            }
                            this.feed(buffer2, last2);
                        }
                    }
                    finally {
                        if (bodyLocal != null) {
                            try {
                                bodyLocal.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            generator.initializeAsynchronousTransfer(ctx, requestPacket);
            return false;
        }
    }

    private static final class StreamDataBodyHandler
    extends BodyHandler {
        private StreamDataBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getStreamData() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            int read2;
            InputStream in;
            byte[] b;
            Buffer buffer2;
            MemoryManager mm;
            block6: {
                mm = ctx.getMemoryManager();
                buffer2 = mm.allocate(512);
                b = new byte[512];
                in = request.getStreamData();
                try {
                    in.reset();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug(ioe.toString(), ioe);
                }
            }
            if (in.markSupported()) {
                in.mark(0);
            }
            while ((read2 = in.read(b)) != -1) {
                if (read2 > buffer2.remaining()) {
                    buffer2 = mm.reallocate(buffer2, buffer2.capacity() + 512);
                }
                buffer2.put(b, 0, read2);
            }
            buffer2.trim();
            if (buffer2.hasRemaining()) {
                HttpContent content = requestPacket.httpContentBuilder().content(buffer2).last(true).build();
                buffer2.allowBufferDispose(false);
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private static final class EntityWriterBodyHandler
    extends BodyHandler {
        private EntityWriterBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getEntityWriter() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            MemoryManager mm = ctx.getMemoryManager();
            Buffer b = mm.allocate(512);
            BufferOutputStream o = new BufferOutputStream(mm, b, true);
            Request.EntityWriter writer = request.getEntityWriter();
            writer.writeEntity((OutputStream)o);
            b = o.getBuffer();
            b.trim();
            if (b.hasRemaining()) {
                HttpContent content = requestPacket.httpContentBuilder().content(b).last(true).build();
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class ParamsBodyHandler
    extends BodyHandler {
        private ParamsBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return MiscUtil.isNonEmpty(request.getParams());
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            FluentStringsMap params2;
            if (requestPacket.getContentType() == null) {
                requestPacket.setContentType("application/x-www-form-urlencoded");
            }
            StringBuilder sb = null;
            String charset2 = request.getBodyEncoding();
            if (charset2 == null) {
                charset2 = Charsets.ASCII_CHARSET.name();
            }
            if (!(params2 = request.getParams()).isEmpty()) {
                for (Map.Entry<String, List<String>> entry : params2.entrySet()) {
                    String name2 = entry.getKey();
                    List<String> values2 = entry.getValue();
                    if (!MiscUtil.isNonEmpty(values2)) continue;
                    if (sb == null) {
                        sb = new StringBuilder(128);
                    }
                    for (String value2 : values2) {
                        if (sb.length() > 0) {
                            sb.append('&');
                        }
                        sb.append(URLEncoder.encode(name2, charset2)).append('=').append(URLEncoder.encode(value2, charset2));
                    }
                }
            }
            if (sb != null) {
                byte[] data = sb.toString().getBytes(charset2);
                MemoryManager mm = ctx.getMemoryManager();
                Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
                HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
                if (requestPacket.getContentLength() == -1L) {
                    requestPacket.setContentLengthLong((long)data.length);
                }
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class StringBodyHandler
    extends BodyHandler {
        private StringBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getStringData() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            String charset2 = request.getBodyEncoding();
            if (charset2 == null) {
                charset2 = Charsets.ASCII_CHARSET.name();
            }
            byte[] data = request.getStringData().getBytes(charset2);
            MemoryManager mm = ctx.getMemoryManager();
            Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
            if (requestPacket.getContentLength() == -1L) {
                requestPacket.setContentLengthLong((long)data.length);
            }
            HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }
    }

    private final class ByteArrayBodyHandler
    extends BodyHandler {
        private ByteArrayBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getByteData() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            MemoryManager mm = ctx.getMemoryManager();
            byte[] data = request.getByteData();
            Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
            if (requestPacket.getContentLength() == -1L) {
                requestPacket.setContentLengthLong((long)data.length);
            }
            HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }

        protected long getContentLength(Request request) {
            return request.getContentLength() >= 0L ? request.getContentLength() : (long)request.getByteData().length;
        }
    }

    private static final class ExpectHandler
    extends BodyHandler {
        private final BodyHandler delegate;
        private Request request;
        private HttpRequestPacket requestPacket;

        private ExpectHandler(BodyHandler delegate) {
            this.delegate = delegate;
        }

        public boolean handlesBodyType(Request request) {
            return this.delegate.handlesBodyType(request);
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            this.request = request;
            this.requestPacket = requestPacket;
            long contentLength = this.delegate.getContentLength(request);
            if (contentLength != -1L) {
                requestPacket.setContentLengthLong(contentLength);
            }
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }

        public void finish(FilterChainContext ctx) throws IOException {
            this.delegate.doHandle(ctx, this.request, this.requestPacket);
        }
    }

    private final class BodyHandlerFactory {
        private final BodyHandler[] HANDLERS;

        private BodyHandlerFactory() {
            this.HANDLERS = new BodyHandler[]{new StringBodyHandler(), new ByteArrayBodyHandler(), new ParamsBodyHandler(), new EntityWriterBodyHandler(), new StreamDataBodyHandler(), new PartsBodyHandler(), new FileBodyHandler(), new BodyGeneratorBodyHandler()};
        }

        public BodyHandler getBodyHandler(Request request) {
            for (BodyHandler h2 : this.HANDLERS) {
                if (!h2.handlesBodyType(request)) continue;
                return h2;
            }
            return null;
        }
    }

    public static abstract class BodyHandler {
        public static int MAX_CHUNK_SIZE = 8192;

        public abstract boolean handlesBodyType(Request var1);

        public abstract boolean doHandle(FilterChainContext var1, Request var2, HttpRequestPacket var3) throws IOException;

        protected long getContentLength(Request request) {
            return request.getContentLength();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NonCachingPool
    implements ConnectionsPool<String, Connection> {
        private NonCachingPool() {
        }

        @Override
        public boolean offer(String uri, Connection connection) {
            return false;
        }

        @Override
        public Connection poll(String uri) {
            return null;
        }

        @Override
        public boolean removeAll(Connection connection) {
            return false;
        }

        @Override
        public boolean canCacheConnection() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    private static final class ClientEncodingFilter
    implements EncodingFilter {
        private ClientEncodingFilter() {
        }

        public boolean applyEncoding(HttpHeader httpPacket) {
            httpPacket.addHeader(Header.AcceptEncoding, "gzip");
            return false;
        }

        public boolean applyDecoding(HttpHeader httpPacket) {
            HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
            DataChunk bc = httpResponse.getHeaders().getValue(Header.ContentEncoding);
            return bc != null && bc.indexOf("gzip", 0) != -1;
        }
    }

    private static final class AsyncHttpClientEventFilter
    extends HttpClientFilter {
        private final Map<Integer, StatusHandler> HANDLER_MAP = new HashMap<Integer, StatusHandler>();
        private final GrizzlyAsyncHttpProvider provider;

        AsyncHttpClientEventFilter(GrizzlyAsyncHttpProvider provider, int maxHerdersSizeProperty) {
            super(maxHerdersSizeProperty);
            this.provider = provider;
            this.HANDLER_MAP.put(HttpStatus.UNAUTHORIZED_401.getStatusCode(), AuthorizationHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.MOVED_PERMANENTLY_301.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.FOUND_302.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.SEE_OTHER_303.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.TEMPORARY_REDIRECT_307.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.PERMANENT_REDIRECT_308.getStatusCode(), RedirectHandler.INSTANCE);
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (event.type() == GracefulCloseEvent.class) {
                GracefulCloseEvent closeEvent = (GracefulCloseEvent)event;
                HttpResponsePacket response = closeEvent.getHttpTxContext().responseStatus.getResponse();
                response.getProcessingState().getHttpContext().attach(ctx);
                this.onHttpPacketParsed((HttpHeader)response, ctx);
                return ctx.getStopAction();
            }
            return ctx.getInvokeAction();
        }

        public void exceptionOccurred(FilterChainContext ctx, Throwable error2) {
            HttpTransactionContext.get(ctx.getConnection()).abort(error2);
        }

        protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
            HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler != null && context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    context.currentState = handler.onBodyPartReceived(new GrizzlyResponseBodyPart(content, null, ctx.getConnection(), this.provider));
                }
                catch (Exception e) {
                    handler.onThrowable(e);
                }
            }
        }

        protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
            HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler instanceof TransferCompletionHandler) {
                ((TransferCompletionHandler)handler).onHeaderWriteCompleted();
            }
            if (handler instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)((Object)handler)).onRequestSent();
            }
        }

        protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
            HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler instanceof TransferCompletionHandler) {
                int written = content.getContent().remaining();
                long total2 = context.totalBodyWritten.addAndGet(written);
                ((TransferCompletionHandler)handler).onContentWriteProgress(written, total2, content.getHttpHeader().getContentLength());
            }
        }

        protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            GrizzlyResponseStatus responseStatus;
            super.onInitialLineParsed(httpHeader, ctx);
            if (httpHeader.isSkipRemainder()) {
                return;
            }
            HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
            int status = ((HttpResponsePacket)httpHeader).getStatus();
            if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(status)) {
                return;
            }
            if (HttpStatus.CONINTUE_100.statusMatches(status)) {
                ctx.notifyUpstream((FilterChainEvent)new ContinueEvent(context));
                return;
            }
            if (context.statusHandler != null && !context.statusHandler.handlesStatus(status)) {
                context.statusHandler = null;
                context.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
            } else {
                context.statusHandler = null;
            }
            if (context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE) {
                if (this.HANDLER_MAP.containsKey(status)) {
                    context.statusHandler = this.HANDLER_MAP.get(status);
                }
                if (context.statusHandler instanceof RedirectHandler && !AsyncHttpClientEventFilter.isRedirectAllowed(context)) {
                    context.statusHandler = null;
                }
            }
            if (AsyncHttpClientEventFilter.isRedirectAllowed(context)) {
                if (AsyncHttpClientEventFilter.isRedirect(status)) {
                    if (context.statusHandler == null) {
                        context.statusHandler = RedirectHandler.INSTANCE;
                    }
                    context.redirectCount.incrementAndGet();
                    if (AsyncHttpClientEventFilter.redirectCountExceeded(context)) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(new MaxRedirectException());
                    }
                } else if (context.redirectCount.get() > 0) {
                    context.redirectCount.set(0);
                }
            }
            context.responseStatus = responseStatus = new GrizzlyResponseStatus((HttpResponsePacket)httpHeader, context.request.getURI(), this.provider);
            if (context.statusHandler != null) {
                return;
            }
            if (context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    AsyncHandler handler = context.handler;
                    if (handler != null) {
                        context.currentState = handler.onStatusReceived(responseStatus);
                        if (context.isWSRequest && context.currentState == AsyncHandler.STATE.ABORT) {
                            httpHeader.setSkipRemainder(true);
                            try {
                                context.result(handler.onCompleted());
                                context.done();
                            }
                            catch (Throwable e) {
                                context.abort(e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(e);
                }
            }
        }

        protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
            httpHeader.setSkipRemainder(true);
            HttpTransactionContext.get(ctx.getConnection()).abort(t);
        }

        protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
            httpHeader.setSkipRemainder(true);
            HttpTransactionContext.get(ctx.getConnection()).abort(t);
        }

        protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            block20: {
                boolean result2;
                super.onHttpHeadersParsed(httpHeader, ctx);
                LOGGER.debug("RESPONSE: {}", (Object)httpHeader);
                HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
                if (httpHeader.containsHeader(Header.Connection) && "close".equals(httpHeader.getHeader(Header.Connection))) {
                    ConnectionManager.markConnectionAsDoNotCache(ctx.getConnection());
                }
                if (httpHeader.isSkipRemainder() || context.establishingTunnel) {
                    return;
                }
                AsyncHandler handler = context.handler;
                List<ResponseFilter> filters = context.provider.clientConfig.getResponseFilters();
                GrizzlyResponseHeaders responseHeaders = new GrizzlyResponseHeaders((HttpResponsePacket)httpHeader, context.request.getURI(), this.provider);
                if (!filters.isEmpty()) {
                    FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(context.request).responseHeaders(responseHeaders).responseStatus(context.responseStatus).build();
                    try {
                        for (ResponseFilter f2 : filters) {
                            fc = f2.filter(fc);
                        }
                    }
                    catch (Exception e) {
                        context.abort(e);
                    }
                    if (fc.replayRequest()) {
                        httpHeader.setSkipRemainder(true);
                        Request newRequest = fc.getRequest();
                        AsyncHandler newHandler = fc.getAsyncHandler();
                        try {
                            ConnectionManager m = context.provider.connectionManager;
                            Connection c = m.obtainConnection(newRequest, context.future);
                            HttpTransactionContext newContext = context.copy();
                            context.future = null;
                            HttpTransactionContext.set(c, newContext);
                            try {
                                context.provider.execute(c, newRequest, newHandler, context.future, false);
                            }
                            catch (IOException ioe) {
                                newContext.abort(ioe);
                            }
                        }
                        catch (Exception e) {
                            context.abort(e);
                        }
                        return;
                    }
                }
                if (context.statusHandler != null && context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE && !(result2 = context.statusHandler.handleStatus((HttpResponsePacket)httpHeader, context, ctx))) {
                    httpHeader.setSkipRemainder(true);
                    return;
                }
                if (context.isWSRequest) {
                    try {
                        context.protocolHandler.setConnection(ctx.getConnection());
                        GrizzlyWebSocketAdapter webSocketAdapter = AsyncHttpClientEventFilter.createWebSocketAdapter(context);
                        context.webSocket = webSocketAdapter;
                        SimpleWebSocket ws = webSocketAdapter.gWebSocket;
                        if (context.currentState == AsyncHandler.STATE.UPGRADE) {
                            httpHeader.setChunked(false);
                            ws.onConnect();
                            WebSocketHolder.set((Connection)ctx.getConnection(), (ProtocolHandler)context.protocolHandler, (WebSocket)ws);
                            ((WebSocketUpgradeHandler)context.handler).onSuccess(context.webSocket);
                            int wsTimeout = context.provider.clientConfig.getWebSocketIdleTimeoutInMs();
                            IdleTimeoutFilter.setCustomTimeout((Connection)ctx.getConnection(), (long)(wsTimeout <= 0 ? IdleTimeoutFilter.FOREVER : (long)wsTimeout), (TimeUnit)TimeUnit.MILLISECONDS);
                            context.result(handler.onCompleted());
                            break block20;
                        }
                        httpHeader.setSkipRemainder(true);
                        ((WebSocketUpgradeHandler)context.handler).onClose(context.webSocket, 1002, "WebSocket protocol error: unexpected HTTP response status during handshake.");
                        context.result(null);
                    }
                    catch (Throwable e) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(e);
                    }
                } else if (context.currentState != AsyncHandler.STATE.ABORT) {
                    try {
                        context.currentState = handler.onHeadersReceived(responseHeaders);
                    }
                    catch (Exception e) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(e);
                    }
                }
            }
        }

        protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer2, FilterChainContext ctx) {
            super.onHttpHeaderParsed(httpHeader, buffer2, ctx);
            HttpRequestPacket request = ((HttpResponsePacket)httpHeader).getRequest();
            if (Method.CONNECT.equals(request.getMethod())) {
                httpHeader.setExpectContent(false);
            }
            return false;
        }

        protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            if (httpHeader.isSkipRemainder()) {
                this.clearResponse(ctx.getConnection());
                AsyncHttpClientEventFilter.cleanup(ctx, this.provider);
                return false;
            }
            boolean result2 = super.onHttpPacketParsed(httpHeader, ctx);
            HttpTransactionContext context = HttpTransactionContext.get(ctx.getConnection());
            if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(((HttpResponsePacket)httpHeader).getStatus())) {
                context.establishingTunnel = false;
                Connection c = ctx.getConnection();
                context.tunnelEstablished(c);
                try {
                    context.provider.execute(c, context.request, context.handler, context.future, false);
                    return result2;
                }
                catch (IOException e) {
                    context.abort(e);
                    return result2;
                }
            }
            AsyncHttpClientEventFilter.cleanup(ctx, this.provider);
            AsyncHandler handler = context.handler;
            if (handler != null) {
                try {
                    context.result(handler.onCompleted());
                }
                catch (Throwable e) {
                    context.abort(e);
                }
            } else {
                context.done();
            }
            return result2;
        }

        private static GrizzlyWebSocketAdapter createWebSocketAdapter(HttpTransactionContext context) {
            SimpleWebSocket ws = new SimpleWebSocket(context.protocolHandler, new org.glassfish.grizzly.websockets.WebSocketListener[0]);
            AsyncHttpProviderConfig<?, ?> config2 = context.provider.clientConfig.getAsyncHttpProviderConfig();
            boolean bufferFragments = true;
            if (config2 instanceof GrizzlyAsyncHttpProviderConfig) {
                bufferFragments = (Boolean)((GrizzlyAsyncHttpProviderConfig)config2).getProperty(GrizzlyAsyncHttpProviderConfig.Property.BUFFER_WEBSOCKET_FRAGMENTS);
            }
            return new GrizzlyWebSocketAdapter(ws, bufferFragments);
        }

        private static boolean isRedirectAllowed(HttpTransactionContext ctx) {
            boolean allowed = ctx.request.isRedirectEnabled();
            if (ctx.request.isRedirectOverrideSet()) {
                return allowed;
            }
            if (!allowed) {
                allowed = ctx.redirectsAllowed;
            }
            return allowed;
        }

        private static HttpTransactionContext cleanup(FilterChainContext ctx, GrizzlyAsyncHttpProvider provider) {
            Connection c = ctx.getConnection();
            HttpTransactionContext context = HttpTransactionContext.remove(c);
            if (!context.provider.connectionManager.canReturnConnection(c)) {
                context.abort(new IOException("Maximum pooled connections exceeded"));
            } else if (!context.provider.connectionManager.returnConnection(context.request, c)) {
                ctx.getConnection().close();
            }
            return context;
        }

        private static boolean redirectCountExceeded(HttpTransactionContext context) {
            return context.redirectCount.get() > context.maxRedirectCount;
        }

        private static boolean isRedirect(int status) {
            return HttpStatus.MOVED_PERMANENTLY_301.statusMatches(status) || HttpStatus.FOUND_302.statusMatches(status) || HttpStatus.SEE_OTHER_303.statusMatches(status) || HttpStatus.TEMPORARY_REDIRECT_307.statusMatches(status) || HttpStatus.PERMANENT_REDIRECT_308.statusMatches(status);
        }

        private static Request newRequest(URI uri, HttpResponsePacket response, HttpTransactionContext ctx, boolean asGet) {
            RequestBuilder builder = new RequestBuilder(ctx.request);
            if (asGet) {
                builder.setMethod("GET");
            }
            builder.setUrl(uri.toString());
            if (ctx.provider.clientConfig.isRemoveQueryParamOnRedirect()) {
                builder.setQueryParameters(null);
            }
            for (String cookieStr : response.getHeaders().values(Header.Cookie)) {
                builder.addOrReplaceCookie(CookieDecoder.decode(cookieStr));
            }
            return builder.build();
        }

        private static final class RedirectHandler
        implements StatusHandler {
            private static final RedirectHandler INSTANCE = new RedirectHandler();

            private RedirectHandler() {
            }

            public boolean handlesStatus(int statusCode) {
                return AsyncHttpClientEventFilter.isRedirect(statusCode);
            }

            public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
                String redirectURL2 = responsePacket.getHeader(Header.Location);
                if (redirectURL2 == null) {
                    throw new IllegalStateException("redirect received, but no location header was present");
                }
                URI orig = httpTransactionContext.lastRedirectURI == null ? httpTransactionContext.request.getURI() : AsyncHttpProviderUtils.getRedirectUri(httpTransactionContext.request.getURI(), httpTransactionContext.lastRedirectURI);
                httpTransactionContext.lastRedirectURI = redirectURL2;
                URI uri = AsyncHttpProviderUtils.getRedirectUri(orig, redirectURL2);
                if (uri.toString().equalsIgnoreCase(orig.toString())) {
                    httpTransactionContext.statusHandler = null;
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    try {
                        httpTransactionContext.handler.onStatusReceived(httpTransactionContext.responseStatus);
                    }
                    catch (Exception e) {
                        httpTransactionContext.abort(e);
                    }
                    return true;
                }
                Request requestToSend = AsyncHttpClientEventFilter.newRequest(uri, responsePacket, httpTransactionContext, this.sendAsGet(responsePacket, httpTransactionContext));
                ConnectionManager m = httpTransactionContext.provider.connectionManager;
                try {
                    Connection c = m.obtainConnection(requestToSend, httpTransactionContext.future);
                    if (this.switchingSchemes(orig, uri)) {
                        try {
                            this.notifySchemeSwitch(ctx, c, uri);
                        }
                        catch (IOException ioe) {
                            httpTransactionContext.abort(ioe);
                        }
                    }
                    HttpTransactionContext newContext = httpTransactionContext.copy();
                    httpTransactionContext.future = null;
                    newContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    newContext.request = requestToSend;
                    newContext.requestUrl = requestToSend.getUrl();
                    HttpTransactionContext.set(c, newContext);
                    httpTransactionContext.provider.execute(c, requestToSend, newContext.handler, newContext.future, false);
                    return false;
                }
                catch (Exception e) {
                    httpTransactionContext.abort(e);
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    return true;
                }
            }

            private boolean sendAsGet(HttpResponsePacket response, HttpTransactionContext ctx) {
                int statusCode = response.getStatus();
                return statusCode >= 302 && statusCode <= 303 && (statusCode != 302 || !ctx.provider.clientConfig.isStrict302Handling());
            }

            private boolean switchingSchemes(URI oldUri, URI newUri) {
                return !oldUri.getScheme().equals(newUri.getScheme());
            }

            private void notifySchemeSwitch(FilterChainContext ctx, Connection c, URI uri) throws IOException {
                ctx.notifyDownstream((FilterChainEvent)new SwitchingSSLFilter.SSLSwitchingEvent("https".equals(uri.getScheme()), c));
            }
        }

        private static final class AuthorizationHandler
        implements StatusHandler {
            private static final AuthorizationHandler INSTANCE = new AuthorizationHandler();

            private AuthorizationHandler() {
            }

            public boolean handlesStatus(int statusCode) {
                return HttpStatus.UNAUTHORIZED_401.statusMatches(statusCode);
            }

            public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
                String auth = responsePacket.getHeader(Header.WWWAuthenticate);
                if (auth == null) {
                    throw new IllegalStateException("401 response received, but no WWW-Authenticate header was present");
                }
                Realm realm = httpTransactionContext.request.getRealm();
                if (realm == null) {
                    realm = httpTransactionContext.provider.clientConfig.getRealm();
                }
                if (realm == null) {
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    if (httpTransactionContext.handler != null) {
                        try {
                            httpTransactionContext.handler.onStatusReceived(httpTransactionContext.responseStatus);
                        }
                        catch (Exception e) {
                            httpTransactionContext.abort(e);
                        }
                    }
                    return true;
                }
                responsePacket.setSkipRemainder(true);
                Request req = httpTransactionContext.request;
                realm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(httpTransactionContext.request.getURI().getPath()).setMethodName(req.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(auth).build();
                String lowerCaseAuth = auth.toLowerCase(Locale.ENGLISH);
                if (lowerCaseAuth.startsWith("basic")) {
                    req.getHeaders().remove(Header.Authorization.toString());
                    try {
                        req.getHeaders().add(Header.Authorization.toString(), AuthenticatorUtils.computeBasicAuthentication(realm));
                    }
                    catch (UnsupportedEncodingException ignored) {}
                } else if (lowerCaseAuth.startsWith("digest")) {
                    req.getHeaders().remove(Header.Authorization.toString());
                    try {
                        req.getHeaders().add(Header.Authorization.toString(), AuthenticatorUtils.computeDigestAuthentication(realm));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("Digest authentication not supported", e);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException("Unsupported encoding.", e);
                    }
                } else {
                    throw new IllegalStateException("Unsupported authorization method: " + auth);
                }
                ConnectionManager m = httpTransactionContext.provider.connectionManager;
                try {
                    Connection c = m.obtainConnection(req, httpTransactionContext.future);
                    HttpTransactionContext newContext = httpTransactionContext.copy();
                    httpTransactionContext.future = null;
                    HttpTransactionContext.set(c, newContext);
                    newContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    try {
                        httpTransactionContext.provider.execute(c, req, httpTransactionContext.handler, httpTransactionContext.future, false);
                        return false;
                    }
                    catch (IOException ioe) {
                        newContext.abort(ioe);
                        return false;
                    }
                }
                catch (Exception e) {
                    httpTransactionContext.abort(e);
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    return false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AsyncHttpClientFilter
    extends BaseFilter {
        private final AsyncHttpClientConfig config;

        AsyncHttpClientFilter(AsyncHttpClientConfig config2) {
            this.config = config2;
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            Object message = ctx.getMessage();
            if (message instanceof Request) {
                ctx.setMessage(null);
                if (!this.sendAsGrizzlyRequest((Request)message, ctx)) {
                    return ctx.getSuspendAction();
                }
            } else if (message instanceof Buffer) {
                return ctx.getInvokeAction();
            }
            return ctx.getStopAction();
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            Object type = event.type();
            if (type == ContinueEvent.class) {
                ContinueEvent continueEvent = (ContinueEvent)event;
                ((ExpectHandler)((ContinueEvent)continueEvent).context.bodyHandler).finish(ctx);
            }
            return ctx.getStopAction();
        }

        private boolean sendAsGrizzlyRequest(Request request, FilterChainContext ctx) throws IOException {
            AsyncHandler h2;
            HttpRequestPacket requestPacket;
            BodyHandler bodyHandler;
            ProxyServer proxy;
            boolean useProxy;
            Request req;
            Connection connection = ctx.getConnection();
            HttpTransactionContext httpCtx = HttpTransactionContext.get(connection);
            if (this.isUpgradeRequest(httpCtx.handler) && this.isWSRequest(httpCtx.requestUrl)) {
                httpCtx.isWSRequest = true;
                this.convertToUpgradeRequest(httpCtx);
            }
            URI uri = (req = httpCtx.request).isUseRawUrl() ? req.getRawURI() : req.getURI();
            Method method = Method.valueOf((String)request.getMethod());
            HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
            boolean secure2 = "https".equals(uri.getScheme());
            builder.method(method);
            builder.protocol(Protocol.HTTP_1_1);
            if (!request.getHeaders().containsKey(Header.Host.toString())) {
                String host2 = request.getVirtualHost();
                if (host2 != null) {
                    builder.header(Header.Host, host2);
                } else if (uri.getPort() == -1) {
                    builder.header(Header.Host, uri.getHost());
                } else {
                    builder.header(Header.Host, uri.getHost() + ':' + uri.getPort());
                }
            }
            boolean bl = useProxy = (proxy = ProxyUtils.getProxyServer(this.config, request)) != null;
            if (useProxy) {
                if ((secure2 || httpCtx.isWSRequest) && !httpCtx.isTunnelEstablished(connection)) {
                    secure2 = false;
                    httpCtx.establishingTunnel = true;
                    builder.method(Method.CONNECT);
                    builder.uri(AsyncHttpProviderUtils.getAuthority(uri));
                } else if ((secure2 || httpCtx.isWSRequest) && this.config.isUseRelativeURIsWithConnectProxies()) {
                    builder.uri(uri.getRawPath());
                } else {
                    builder.uri(uri.toString());
                }
            } else {
                builder.uri(uri.getRawPath());
            }
            BodyHandler bodyHandler2 = bodyHandler = this.isPayloadAllowed(method) ? GrizzlyAsyncHttpProvider.this.bodyHandlerFactory.getBodyHandler(request) : null;
            if (bodyHandler != null) {
                long contentLength = request.getContentLength();
                if (contentLength >= 0L) {
                    builder.contentLength(contentLength);
                    builder.chunked(false);
                } else {
                    builder.chunked(true);
                }
            }
            if (httpCtx.isWSRequest && !httpCtx.establishingTunnel) {
                try {
                    URI wsURI = new URI(httpCtx.wsRequestURI);
                    secure2 = "wss".equalsIgnoreCase(wsURI.getScheme());
                    httpCtx.protocolHandler = Version.RFC6455.createHandler(true);
                    httpCtx.handshake = httpCtx.protocolHandler.createHandShake(wsURI);
                    requestPacket = (HttpRequestPacket)httpCtx.handshake.composeHeaders().getHttpHeader();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid WS URI: " + httpCtx.wsRequestURI);
                }
            } else {
                requestPacket = builder.build();
            }
            requestPacket.setSecure(secure2);
            ctx.notifyDownstream((FilterChainEvent)new SwitchingSSLFilter.SSLSwitchingEvent(secure2, connection));
            if (!useProxy && !httpCtx.isWSRequest) {
                requestPacket.setQueryString(uri.getRawQuery());
            }
            this.addHeaders(request, requestPacket);
            this.addCookies(request, requestPacket);
            this.addAuthorizationHeader(request, requestPacket);
            if (useProxy) {
                if (!requestPacket.getHeaders().contains(Header.ProxyConnection)) {
                    requestPacket.setHeader(Header.ProxyConnection, "keep-alive");
                }
                if (proxy.getPrincipal() != null) {
                    requestPacket.setHeader(Header.ProxyAuthorization, AuthenticatorUtils.computeBasicAuthentication(proxy));
                }
            }
            if ((h2 = httpCtx.handler) instanceof TransferCompletionHandler) {
                FluentCaseInsensitiveStringsMap map2 = new FluentCaseInsensitiveStringsMap(request.getHeaders());
                ((TransferCompletionHandler)TransferCompletionHandler.class.cast(h2)).transferAdapter(new GrizzlyTransferAdapter(map2));
            }
            requestPacket.setConnection(connection);
            return GrizzlyAsyncHttpProvider.this.sendRequest(ctx, request, requestPacket, this.wrapWithExpectHandlerIfNeeded(bodyHandler, requestPacket));
        }

        private BodyHandler wrapWithExpectHandlerIfNeeded(BodyHandler bodyHandler, HttpRequestPacket requestPacket) {
            if (bodyHandler == null) {
                return null;
            }
            MimeHeaders headers2 = requestPacket.getHeaders();
            int expectHeaderIdx = headers2.indexOf(Header.Expect, 0);
            return expectHeaderIdx != -1 && headers2.getValue(expectHeaderIdx).equalsIgnoreCase("100-Continue") ? new ExpectHandler(bodyHandler) : bodyHandler;
        }

        private boolean isPayloadAllowed(Method method) {
            return method.getPayloadExpectation() != Method.PayloadExpectation.NOT_ALLOWED;
        }

        private void addAuthorizationHeader(Request request, HttpRequestPacket requestPacket) {
            String authHeaderValue;
            Realm realm = request.getRealm();
            if (realm == null) {
                realm = this.config.getRealm();
            }
            if (realm != null && realm.getUsePreemptiveAuth() && (authHeaderValue = this.generateAuthHeader(realm)) != null) {
                requestPacket.addHeader(Header.Authorization, authHeaderValue);
            }
        }

        private String generateAuthHeader(Realm realm) {
            try {
                switch (realm.getAuthScheme()) {
                    case BASIC: {
                        return AuthenticatorUtils.computeBasicAuthentication(realm);
                    }
                    case DIGEST: {
                        return AuthenticatorUtils.computeDigestAuthentication(realm);
                    }
                    case NTLM: {
                        return ntlmEngine.generateType1Msg("NTLM " + realm.getNtlmDomain(), realm.getNtlmHost());
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isUpgradeRequest(AsyncHandler handler) {
            return handler instanceof UpgradeHandler;
        }

        private boolean isWSRequest(String requestUri) {
            return requestUri.charAt(0) == 'w' && requestUri.charAt(1) == 's';
        }

        private void convertToUpgradeRequest(HttpTransactionContext ctx) {
            int colonIdx = ctx.requestUrl.indexOf(58);
            if (colonIdx < 2 || colonIdx > 3) {
                throw new IllegalArgumentException("Invalid websocket URL: " + ctx.requestUrl);
            }
            StringBuilder sb = new StringBuilder(ctx.requestUrl);
            sb.replace(0, colonIdx, colonIdx == 2 ? "http" : "https");
            ctx.wsRequestURI = ctx.requestUrl;
            ctx.requestUrl = sb.toString();
        }

        private void addHeaders(Request request, HttpRequestPacket requestPacket) {
            MimeHeaders headers2;
            FluentCaseInsensitiveStringsMap map2 = request.getHeaders();
            if (MiscUtil.isNonEmpty(map2)) {
                for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
                    String headerName = entry.getKey();
                    List<String> headerValues = entry.getValue();
                    if (!MiscUtil.isNonEmpty(headerValues)) continue;
                    for (String headerValue : headerValues) {
                        requestPacket.addHeader(headerName, headerValue);
                    }
                }
            }
            if (!(headers2 = requestPacket.getHeaders()).contains(Header.Connection)) {
                requestPacket.addHeader(Header.Connection, "keep-alive");
            }
            if (!headers2.contains(Header.Accept)) {
                requestPacket.addHeader(Header.Accept, "*/*");
            }
            if (!headers2.contains(Header.UserAgent)) {
                requestPacket.addHeader(Header.UserAgent, this.config.getUserAgent());
            }
        }

        private void addCookies(Request request, HttpRequestPacket requestPacket) {
            Collection<com.ning.http.client.cookie.Cookie> cookies2 = request.getCookies();
            if (MiscUtil.isNonEmpty(cookies2)) {
                StringBuilder sb = new StringBuilder(128);
                Cookie[] gCookies = new Cookie[cookies2.size()];
                this.convertCookies(cookies2, gCookies);
                CookieSerializerUtils.serializeClientCookies((StringBuilder)sb, (Cookie[])gCookies);
                requestPacket.addHeader(Header.Cookie, sb.toString());
            }
        }

        private void convertCookies(Collection<com.ning.http.client.cookie.Cookie> cookies2, Cookie[] gCookies) {
            int idx = 0;
            for (com.ning.http.client.cookie.Cookie cookie2 : cookies2) {
                gCookies[idx++] = new Cookie(cookie2.getName(), cookie2.getValue());
            }
        }

        private void addQueryString(Request request, HttpRequestPacket requestPacket) {
            FluentStringsMap map2 = request.getQueryParams();
            if (MiscUtil.isNonEmpty(map2)) {
                StringBuilder sb = new StringBuilder(128);
                for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
                    String name2 = entry.getKey();
                    List<String> values2 = entry.getValue();
                    if (!MiscUtil.isNonEmpty(values2)) continue;
                    try {
                        int len2 = values2.size();
                        for (int i = 0; i < len2; ++i) {
                            String value2 = values2.get(i);
                            if (MiscUtil.isNonEmpty(value2)) {
                                sb.append(URLEncoder.encode(name2, "UTF-8")).append('=').append(URLEncoder.encode(values2.get(i), "UTF-8")).append('&');
                                continue;
                            }
                            sb.append(URLEncoder.encode(name2, "UTF-8")).append('&');
                        }
                    }
                    catch (UnsupportedEncodingException ignored) {
                    }
                }
                sb.setLength(sb.length() - 1);
                String queryString2 = sb.toString();
                requestPacket.setQueryString(queryString2);
            }
        }
    }

    public static class GracefulCloseEvent
    implements FilterChainEvent {
        private final HttpTransactionContext httpTxContext;

        public GracefulCloseEvent(HttpTransactionContext httpTxContext) {
            this.httpTxContext = httpTxContext;
        }

        public HttpTransactionContext getHttpTxContext() {
            return this.httpTxContext;
        }

        public Object type() {
            return GracefulCloseEvent.class;
        }
    }

    private static final class ContinueEvent
    implements FilterChainEvent {
        private final HttpTransactionContext context;

        ContinueEvent(HttpTransactionContext context) {
            this.context = context;
        }

        public Object type() {
            return ContinueEvent.class;
        }
    }

    static final class HttpTransactionContext {
        final AtomicInteger redirectCount = new AtomicInteger(0);
        final int maxRedirectCount;
        final boolean redirectsAllowed;
        final GrizzlyAsyncHttpProvider provider;
        Request request;
        String requestUrl;
        AsyncHandler handler;
        BodyHandler bodyHandler;
        StatusHandler statusHandler;
        StatusHandler.InvocationStatus invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
        GrizzlyResponseStatus responseStatus;
        GrizzlyResponseFuture future;
        String lastRedirectURI;
        AtomicLong totalBodyWritten = new AtomicLong();
        AsyncHandler.STATE currentState;
        String wsRequestURI;
        boolean isWSRequest;
        HandShake handshake;
        ProtocolHandler protocolHandler;
        com.ning.http.client.websocket.WebSocket webSocket;
        boolean establishingTunnel;
        private final CloseListener listener = new CloseListener<Closeable, CloseType>(){

            public void onClosed(Closeable closeable, CloseType type) throws IOException {
                if (HttpTransactionContext.this.responseStatus != null && HttpTransactionContext.this.isGracefullyFinishResponseOnClose()) {
                    Connection c = HttpTransactionContext.this.responseStatus.getResponse().getRequest().getConnection();
                    FilterChain fc = (FilterChain)c.getProcessor();
                    fc.fireEventUpstream(c, (FilterChainEvent)new GracefulCloseEvent(HttpTransactionContext.this), null);
                } else if (CloseType.REMOTELY.equals((Object)type)) {
                    HttpTransactionContext.this.abort(REMOTELY_CLOSED_EXCEPTION);
                }
            }
        };

        static void set(Connection c, HttpTransactionContext httpTxContext) {
            c.addCloseListener(httpTxContext.listener);
            REQUEST_STATE_ATTR.set((AttributeStorage)c, (Object)httpTxContext);
        }

        static HttpTransactionContext remove(Connection c) {
            HttpTransactionContext httpTxContext = (HttpTransactionContext)REQUEST_STATE_ATTR.remove((AttributeStorage)c);
            c.removeCloseListener(httpTxContext.listener);
            return httpTxContext;
        }

        static HttpTransactionContext get(Connection c) {
            return (HttpTransactionContext)REQUEST_STATE_ATTR.get((AttributeStorage)c);
        }

        HttpTransactionContext(GrizzlyAsyncHttpProvider provider, GrizzlyResponseFuture future2, Request request, AsyncHandler handler) {
            this.provider = provider;
            this.future = future2;
            this.request = request;
            this.handler = handler;
            this.redirectsAllowed = provider.clientConfig.isRedirectEnabled();
            this.maxRedirectCount = provider.clientConfig.getMaxRedirects();
            this.requestUrl = request.getUrl();
        }

        HttpTransactionContext copy() {
            HttpTransactionContext newContext = new HttpTransactionContext(this.provider, this.future, this.request, this.handler);
            newContext.invocationStatus = this.invocationStatus;
            newContext.bodyHandler = this.bodyHandler;
            newContext.currentState = this.currentState;
            newContext.statusHandler = this.statusHandler;
            newContext.lastRedirectURI = this.lastRedirectURI;
            newContext.redirectCount.set(this.redirectCount.get());
            return newContext;
        }

        boolean isGracefullyFinishResponseOnClose() {
            HttpResponsePacket response = this.responseStatus.getResponse();
            return !response.getProcessingState().isKeepAlive() && !response.isChunked() && response.getContentLength() == -1L;
        }

        void abort(Throwable t) {
            if (this.future != null) {
                this.future.abort(t);
            }
        }

        void done() {
            if (this.future != null) {
                this.future.done();
            }
        }

        void result(Object result2) {
            if (this.future != null) {
                this.future.delegate.result(result2);
                this.future.done();
            }
        }

        boolean isTunnelEstablished(Connection c) {
            return c.getAttributes().getAttribute("tunnel-established") != null;
        }

        void tunnelEstablished(Connection c) {
            c.getAttributes().setAttribute("tunnel-established", (Object)Boolean.TRUE);
        }
    }

    private static interface StatusHandler {
        public boolean handleStatus(HttpResponsePacket var1, HttpTransactionContext var2, FilterChainContext var3);

        public boolean handlesStatus(int var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InvocationStatus {
            CONTINUE,
            STOP;

        }
    }
}

