/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class FeedableBodyGenerator
implements BodyGenerator {
    private static final String US_ASCII = "US-ASCII";
    private static final byte[] END_PADDING = FeedableBodyGenerator.getBytes("\r\n");
    private static final byte[] ZERO = FeedableBodyGenerator.getBytes("0");
    private final Queue<BodyPart> queue = new ConcurrentLinkedQueue<BodyPart>();
    private final AtomicInteger queueSize = new AtomicInteger();
    private FeedListener listener;

    public Body createBody() throws IOException {
        return new PushBody();
    }

    public void feed(ByteBuffer buffer2, boolean isLast) throws IOException {
        this.queue.offer(new BodyPart(buffer2, isLast));
        this.queueSize.incrementAndGet();
        if (this.listener != null) {
            this.listener.onContentAdded();
        }
    }

    public void setListener(FeedListener listener) {
        this.listener = listener;
    }

    private static byte[] getBytes(String s2) {
        try {
            return s2.getBytes(US_ASCII);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class BodyPart {
        private final boolean isLast;
        private final ByteBuffer buffer;

        public BodyPart(ByteBuffer buffer2, boolean isLast) {
            this.buffer = buffer2;
            this.isLast = isLast;
        }
    }

    private final class PushBody
    implements Body {
        private final int ONGOING = 0;
        private final int CLOSING = 1;
        private final int FINISHED = 2;
        private int finishState = 0;

        private PushBody() {
        }

        public long getContentLength() {
            return -1L;
        }

        public long read(ByteBuffer buffer2) throws IOException {
            BodyPart nextPart = (BodyPart)FeedableBodyGenerator.this.queue.peek();
            if (nextPart == null) {
                switch (this.finishState) {
                    case 0: {
                        return 0L;
                    }
                    case 1: {
                        buffer2.put(ZERO);
                        buffer2.put(END_PADDING);
                        this.finishState = 2;
                        return buffer2.position();
                    }
                    case 2: {
                        buffer2.put(END_PADDING);
                        return -1L;
                    }
                }
            }
            int capacity = buffer2.remaining() - 10;
            int size2 = Math.min(nextPart.buffer.remaining(), capacity);
            buffer2.put(FeedableBodyGenerator.getBytes(Integer.toHexString(size2)));
            buffer2.put(END_PADDING);
            for (int i = 0; i < size2; ++i) {
                buffer2.put(nextPart.buffer.get());
            }
            buffer2.put(END_PADDING);
            if (!nextPart.buffer.hasRemaining()) {
                if (nextPart.isLast) {
                    this.finishState = 1;
                }
                FeedableBodyGenerator.this.queue.remove();
            }
            return size2;
        }

        public void close() throws IOException {
        }
    }

    public static interface FeedListener {
        public void onContentAdded();
    }
}

