/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionPoolKeyStrategy;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.cookie.CookieEncoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.client.providers.netty.BodyChunkedInput;
import com.ning.http.client.providers.netty.BodyFileRegion;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.NettyConnectListener;
import com.ning.http.client.providers.netty.NettyConnectionsPool;
import com.ning.http.client.providers.netty.NettyResponse;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.NettyWebSocket;
import com.ning.http.client.providers.netty.Protocol;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.client.providers.netty.ResponseHeaders;
import com.ning.http.client.providers.netty.ResponseStatus;
import com.ning.http.client.providers.netty.WebSocketUtil;
import com.ning.http.client.providers.netty.spnego.SpnegoEngine;
import com.ning.http.client.providers.netty.timeout.IdleConnectionTimeoutTimerTask;
import com.ning.http.client.providers.netty.timeout.RequestTimeoutTimerTask;
import com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.multipart.MultipartBody;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.CleanupChannelGroup;
import com.ning.http.util.MiscUtil;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.PrematureChannelClosureException;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.ssl.ImmediateExecutor;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
    public static final String GZIP_DEFLATE = "gzip,deflate";
    public static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Remotely Closed");
    public static final String HTTP_HANDLER = "httpHandler";
    public static final String SSL_HANDLER = "sslHandler";
    public static final String HTTP_PROCESSOR = "httpProcessor";
    public static final String WS_PROCESSOR = "wsProcessor";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String WEBSOCKET = "ws";
    private static final String WEBSOCKET_SSL = "wss";
    private static final Logger log;
    private static final Charset UTF8;
    private final ClientBootstrap plainBootstrap;
    private final ClientBootstrap secureBootstrap;
    private final ClientBootstrap webSocketBootstrap;
    private final ClientBootstrap secureWebSocketBootstrap;
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final ClientSocketChannelFactory socketChannelFactory;
    private final boolean allowReleaseSocketChannelFactory;
    private int httpClientCodecMaxInitialLineLength = 4096;
    private int httpClientCodecMaxHeaderSize = 8192;
    private int httpClientCodecMaxChunkSize = 8192;
    private int httpsClientCodecMaxInitialLineLength = 4096;
    private int httpsClientCodecMaxHeaderSize = 8192;
    private int httpsClientCodecMaxChunkSize = 8192;
    private final ChannelGroup openChannels = new CleanupChannelGroup("asyncHttpClient"){

        public boolean remove(Object o) {
            boolean removed = super.remove(o);
            if (removed && NettyAsyncHttpProvider.this.trackConnections) {
                NettyAsyncHttpProvider.this.freeConnections.release();
            }
            return removed;
        }
    };
    private final ConnectionsPool<String, Channel> connectionsPool;
    private Semaphore freeConnections = null;
    private final NettyAsyncHttpProviderConfig providerConfig;
    private boolean executeConnectAsync = true;
    public static final ThreadLocal<Boolean> IN_IO_THREAD;
    private final boolean trackConnections;
    private final boolean useRawUrl;
    private final boolean disableZeroCopy;
    private static final NTLMEngine ntlmEngine;
    private static SpnegoEngine spnegoEngine;
    private final Protocol httpProtocol = new HttpProtocol();
    private final Protocol webSocketProtocol = new WebSocketProtocol();
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    private final long handshakeTimeoutInMillis;

    private static boolean isNTLM(List<String> auth) {
        return MiscUtil.isNonEmpty(auth) && auth.get(0).startsWith("NTLM");
    }

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config2) {
        this.providerConfig = config2.getAsyncHttpProviderConfig() instanceof NettyAsyncHttpProviderConfig ? (NettyAsyncHttpProviderConfig)NettyAsyncHttpProviderConfig.class.cast(config2.getAsyncHttpProviderConfig()) : new NettyAsyncHttpProviderConfig();
        if (config2.getRequestCompressionLevel() > 0) {
            LOGGER.warn("Request was enabled but Netty actually doesn't support this feature");
        }
        if (this.providerConfig.getProperty("useBlockingIO") != null) {
            this.socketChannelFactory = new OioClientSocketChannelFactory(config2.executorService());
            this.allowReleaseSocketChannelFactory = true;
        } else {
            Object oo = this.providerConfig.getProperty("socketChannelFactory");
            if (oo instanceof NioClientSocketChannelFactory) {
                this.socketChannelFactory = (ClientSocketChannelFactory)NioClientSocketChannelFactory.class.cast(oo);
                this.allowReleaseSocketChannelFactory = false;
            } else {
                Object o = this.providerConfig.getProperty("bossExecutorService");
                ExecutorService e = o instanceof ExecutorService ? (ExecutorService)ExecutorService.class.cast(o) : Executors.newCachedThreadPool();
                int numWorkers = config2.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
                log.trace("Number of application's worker threads is {}", (Object)numWorkers);
                this.socketChannelFactory = new NioClientSocketChannelFactory((Executor)e, config2.executorService(), numWorkers);
                this.allowReleaseSocketChannelFactory = true;
            }
        }
        this.allowStopNettyTimer = this.providerConfig.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer() : this.providerConfig.getNettyTimer();
        this.handshakeTimeoutInMillis = this.providerConfig.getHandshakeTimeoutInMillis();
        this.plainBootstrap = new ClientBootstrap(this.socketChannelFactory);
        this.secureBootstrap = new ClientBootstrap(this.socketChannelFactory);
        this.webSocketBootstrap = new ClientBootstrap(this.socketChannelFactory);
        this.secureWebSocketBootstrap = new ClientBootstrap(this.socketChannelFactory);
        this.config = config2;
        this.configureNetty();
        ConnectionsPool<String, Channel> cp = config2.getConnectionsPool();
        if (cp == null && config2.getAllowPoolingConnection()) {
            cp = new NettyConnectionsPool(this, this.nettyTimer);
        } else if (cp == null) {
            cp = new NonConnectionsPool();
        }
        this.connectionsPool = cp;
        if (config2.getMaxTotalConnections() != -1) {
            this.trackConnections = true;
            this.freeConnections = new Semaphore(config2.getMaxTotalConnections());
        } else {
            this.trackConnections = false;
        }
        this.useRawUrl = config2.isUseRawUrl();
        this.disableZeroCopy = this.providerConfig.isDisableZeroCopy();
    }

    private Timer newNettyTimer() {
        HashedWheelTimer timer = new HashedWheelTimer();
        timer.start();
        return timer;
    }

    public String toString() {
        int availablePermits = this.freeConnections != null ? this.freeConnections.availablePermits() : 0;
        return String.format("NettyAsyncHttpProvider:\n\t- maxConnections: %d\n\t- openChannels: %s\n\t- connectionPools: %s", this.config.getMaxTotalConnections() - availablePermits, this.openChannels.toString(), this.connectionsPool.toString());
    }

    void configureNetty() {
        if (this.providerConfig != null) {
            for (Map.Entry<String, Object> entry : this.providerConfig.propertiesSet()) {
                this.plainBootstrap.setOption(entry.getKey(), entry.getValue());
            }
            this.configureHttpClientCodec();
            this.configureHttpsClientCodec();
        }
        this.plainBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, NettyAsyncHttpProvider.this.createHttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_PROCESSOR, NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        DefaultChannelFuture.setUseDeadLockChecker(false);
        if (this.providerConfig != null) {
            Object value2 = this.providerConfig.getProperty("asyncConnect");
            if (value2 instanceof Boolean) {
                this.executeConnectAsync = (Boolean)Boolean.class.cast(value2);
            } else if (this.providerConfig.getProperty("disableNestedRequest") != null) {
                DefaultChannelFuture.setUseDeadLockChecker(true);
            }
        }
        this.webSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, NettyAsyncHttpProvider.this.createHttpClientCodec());
                pipeline.addLast(NettyAsyncHttpProvider.WS_PROCESSOR, NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
    }

    protected void configureHttpClientCodec() {
        this.httpClientCodecMaxInitialLineLength = this.providerConfig.getProperty("httpClientCodecMaxInitialLineLength", Integer.class, this.httpClientCodecMaxInitialLineLength);
        this.httpClientCodecMaxHeaderSize = this.providerConfig.getProperty("httpClientCodecMaxHeaderSize", Integer.class, this.httpClientCodecMaxHeaderSize);
        this.httpClientCodecMaxChunkSize = this.providerConfig.getProperty("httpClientCodecMaxChunkSize", Integer.class, this.httpClientCodecMaxChunkSize);
    }

    protected void configureHttpsClientCodec() {
        this.httpsClientCodecMaxInitialLineLength = this.providerConfig.getProperty("httpsClientCodecMaxInitialLineLength", Integer.class, this.httpsClientCodecMaxInitialLineLength);
        this.httpsClientCodecMaxHeaderSize = this.providerConfig.getProperty("httpsClientCodecMaxHeaderSize", Integer.class, this.httpsClientCodecMaxHeaderSize);
        this.httpsClientCodecMaxChunkSize = this.providerConfig.getProperty("httpsClientCodecMaxChunkSize", Integer.class, this.httpsClientCodecMaxChunkSize);
    }

    void constructSSLPipeline(final NettyConnectListener<?> cl) {
        this.secureBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                try {
                    SSLEngine sslEngine = NettyAsyncHttpProvider.this.createSSLEngine();
                    SslHandler sslHandler = NettyAsyncHttpProvider.this.handshakeTimeoutInMillis > 0L ? new SslHandler(sslEngine, SslHandler.getDefaultBufferPool(), false, ImmediateExecutor.INSTANCE, NettyAsyncHttpProvider.this.nettyTimer, NettyAsyncHttpProvider.this.handshakeTimeoutInMillis) : new SslHandler(sslEngine);
                    pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, sslHandler);
                }
                catch (Throwable ex) {
                    NettyAsyncHttpProvider.this.abort(cl.future(), ex);
                }
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, NettyAsyncHttpProvider.this.createHttpsClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_PROCESSOR, NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        this.secureWebSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                try {
                    pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, new SslHandler(NettyAsyncHttpProvider.this.createSSLEngine()));
                }
                catch (Throwable ex) {
                    NettyAsyncHttpProvider.this.abort(cl.future(), ex);
                }
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, NettyAsyncHttpProvider.this.createHttpsClientCodec());
                pipeline.addLast(NettyAsyncHttpProvider.WS_PROCESSOR, NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        if (this.providerConfig != null) {
            for (Map.Entry<String, Object> entry : this.providerConfig.propertiesSet()) {
                this.secureBootstrap.setOption(entry.getKey(), entry.getValue());
                this.secureWebSocketBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
    }

    private Channel lookupInCache(URI uri, ProxyServer proxy, ConnectionPoolKeyStrategy strategy) {
        Channel channel = this.connectionsPool.poll(this.getPoolKey(uri, proxy, strategy));
        if (channel != null) {
            log.debug("Using cached Channel {}\n for uri {}\n", (Object)channel, (Object)uri);
            try {
                return this.verifyChannelPipeline(channel, uri.getScheme());
            }
            catch (Exception ex) {
                log.debug(ex.getMessage(), ex);
            }
        }
        return null;
    }

    private SSLEngine createSSLEngine() throws IOException, GeneralSecurityException {
        SSLEngine sslEngine = this.config.getSSLEngineFactory().newSSLEngine();
        if (sslEngine == null) {
            sslEngine = SslUtils.getSSLEngine();
        }
        return sslEngine;
    }

    private HttpClientCodec createHttpClientCodec() {
        return new HttpClientCodec(this.httpClientCodecMaxInitialLineLength, this.httpClientCodecMaxHeaderSize, this.httpClientCodecMaxChunkSize);
    }

    private HttpClientCodec createHttpsClientCodec() {
        return new HttpClientCodec(this.httpsClientCodecMaxInitialLineLength, this.httpsClientCodecMaxHeaderSize, this.httpsClientCodecMaxChunkSize);
    }

    private Channel verifyChannelPipeline(Channel channel, String scheme2) throws IOException, GeneralSecurityException {
        if (channel.getPipeline().get(SSL_HANDLER) != null && HTTP.equalsIgnoreCase(scheme2)) {
            channel.getPipeline().remove(SSL_HANDLER);
        } else {
            if (channel.getPipeline().get(HTTP_HANDLER) != null && HTTP.equalsIgnoreCase(scheme2)) {
                return channel;
            }
            if (channel.getPipeline().get(SSL_HANDLER) == null && NettyAsyncHttpProvider.isSecure(scheme2)) {
                channel.getPipeline().addFirst(SSL_HANDLER, new SslHandler(this.createSSLEngine()));
            }
        }
        return channel;
    }

    protected final <T> void writeRequest(Channel channel, AsyncHttpClientConfig config2, NettyResponseFuture<T> future2) {
        block41: {
            HttpRequest nettyRequest = future2.getNettyRequest();
            boolean ssl = channel.getPipeline().get(SslHandler.class) != null;
            try {
                if (!channel.isOpen() || !channel.isConnected()) {
                    return;
                }
                Body body2 = null;
                if (!nettyRequest.getMethod().equals(HttpMethod.CONNECT)) {
                    BodyGenerator bg = future2.getRequest().getBodyGenerator();
                    if (bg == null && future2.getRequest().getStreamData() != null) {
                        bg = new InputStreamBodyGenerator(future2.getRequest().getStreamData());
                    }
                    if (bg != null) {
                        if (bg instanceof InputStreamBodyGenerator) {
                            ((InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(bg)).patchNettyChunkingIssue(true);
                        }
                        try {
                            body2 = bg.createBody();
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                        long length = body2.getContentLength();
                        if (length >= 0L) {
                            nettyRequest.setHeader("Content-Length", length);
                        } else {
                            nettyRequest.setHeader("Transfer-Encoding", "chunked");
                        }
                    } else if (future2.getRequest().getParts() != null) {
                        String contentType2 = nettyRequest.getHeader("Content-Type");
                        String contentLength = nettyRequest.getHeader("Content-Length");
                        long length = -1L;
                        if (contentLength != null) {
                            length = Long.parseLong(contentLength);
                        } else {
                            nettyRequest.addHeader("Transfer-Encoding", "chunked");
                        }
                        body2 = new MultipartBody(future2.getRequest().getParts(), contentType2, length);
                    }
                }
                if (future2.getAsyncHandler() instanceof TransferCompletionHandler) {
                    FluentCaseInsensitiveStringsMap h2 = new FluentCaseInsensitiveStringsMap();
                    for (String s2 : nettyRequest.getHeaderNames()) {
                        for (String header2 : nettyRequest.getHeaders(s2)) {
                            h2.add(s2, header2);
                        }
                    }
                    ((TransferCompletionHandler)TransferCompletionHandler.class.cast(future2.getAsyncHandler())).transferAdapter(new NettyTransferAdapter(h2, nettyRequest.getContent(), future2.getRequest().getFile()));
                }
                if (future2.getAndSetWriteHeaders(true)) {
                    try {
                        if (future2.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future2.getAsyncHandler())).onRequestSent();
                        }
                        channel.write(nettyRequest).addListener(new ProgressListener(true, future2.getAsyncHandler(), future2));
                    }
                    catch (Throwable cause) {
                        log.debug(cause.getMessage(), cause);
                        try {
                            channel.close();
                        }
                        catch (RuntimeException ex) {
                            log.debug(ex.getMessage(), ex);
                        }
                        return;
                    }
                }
                if (!future2.getAndSetWriteBody(true) || nettyRequest.getMethod().equals(HttpMethod.CONNECT)) break block41;
                if (future2.getRequest().getFile() != null) {
                    File file2 = future2.getRequest().getFile();
                    final RandomAccessFile raf = new RandomAccessFile(file2, "r");
                    try {
                        ChannelFuture writeFuture;
                        if (this.disableZeroCopy || ssl) {
                            writeFuture = channel.write(new ChunkedFile(raf, 0L, raf.length(), 8192));
                        } else {
                            OptimizedFileRegion region = new OptimizedFileRegion(raf, 0L, raf.length());
                            writeFuture = channel.write(region);
                        }
                        writeFuture.addListener(new ProgressListener(false, future2.getAsyncHandler(), future2){

                            public void operationComplete(ChannelFuture cf) {
                                try {
                                    raf.close();
                                }
                                catch (IOException e) {
                                    log.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                                }
                                super.operationComplete(cf);
                            }
                        });
                        break block41;
                    }
                    catch (IOException ex) {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                }
                if (body2 != null) {
                    ChannelFuture writeFuture;
                    final Body b = body2;
                    if (this.disableZeroCopy || ssl || !(body2 instanceof RandomAccessBody)) {
                        BodyChunkedInput bodyChunkedInput = new BodyChunkedInput(body2);
                        writeFuture = channel.write(bodyChunkedInput);
                    } else {
                        BodyFileRegion bodyFileRegion = new BodyFileRegion((RandomAccessBody)body2);
                        writeFuture = channel.write(bodyFileRegion);
                    }
                    writeFuture.addListener(new ProgressListener(false, future2.getAsyncHandler(), future2){

                        public void operationComplete(ChannelFuture cf) {
                            try {
                                b.close();
                            }
                            catch (IOException e) {
                                log.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                            }
                            super.operationComplete(cf);
                        }
                    });
                }
            }
            catch (Throwable ioe) {
                try {
                    channel.close();
                }
                catch (RuntimeException ex) {
                    log.debug(ex.getMessage(), ex);
                }
            }
        }
        try {
            int idleConnectionTimeoutInMs;
            future2.touch();
            int requestTimeoutInMs = AsyncHttpProviderUtils.requestTimeout(config2, future2.getRequest());
            TimeoutsHolder timeoutsHolder = new TimeoutsHolder();
            if (requestTimeoutInMs != -1) {
                Timeout requestTimeout;
                timeoutsHolder.requestTimeout = requestTimeout = this.newTimeoutInMs(new RequestTimeoutTimerTask(future2, this, timeoutsHolder), requestTimeoutInMs);
            }
            if ((idleConnectionTimeoutInMs = config2.getIdleConnectionTimeoutInMs()) != -1 && idleConnectionTimeoutInMs <= requestTimeoutInMs) {
                Timeout idleConnectionTimeout;
                timeoutsHolder.idleConnectionTimeout = idleConnectionTimeout = this.newTimeoutInMs(new IdleConnectionTimeoutTimerTask(future2, this, timeoutsHolder, requestTimeoutInMs, idleConnectionTimeoutInMs), idleConnectionTimeoutInMs);
            }
            future2.setTimeoutsHolder(timeoutsHolder);
        }
        catch (RejectedExecutionException ex) {
            this.abort(future2, ex);
        }
    }

    protected static final HttpRequest buildRequest(AsyncHttpClientConfig config2, Request request, URI uri, boolean allowConnect, ChannelBuffer buffer2, ProxyServer proxyServer) throws IOException {
        String method = request.getMethod();
        if (allowConnect && proxyServer != null && NettyAsyncHttpProvider.useProxyConnect(uri)) {
            method = HttpMethod.CONNECT.toString();
        }
        return NettyAsyncHttpProvider.construct(config2, request, new HttpMethod(method), uri, buffer2, proxyServer);
    }

    protected static final boolean useProxyConnect(URI uri) {
        return NettyAsyncHttpProvider.isSecure(uri) || NettyAsyncHttpProvider.isWebSocket(uri.getScheme());
    }

    private static SpnegoEngine getSpnegoEngine() {
        if (spnegoEngine == null) {
            spnegoEngine = new SpnegoEngine();
        }
        return spnegoEngine;
    }

    private static HttpRequest construct(AsyncHttpClientConfig config2, Request request, HttpMethod m, URI uri, ChannelBuffer buffer2, ProxyServer proxyServer) throws IOException {
        String userAgentHeader;
        Realm realm;
        DefaultHttpRequest nettyRequest;
        String host2 = null;
        host2 = request.getVirtualHost() != null ? request.getVirtualHost() : AsyncHttpProviderUtils.getHost(uri);
        if (m.equals(HttpMethod.CONNECT)) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_0, m, AsyncHttpProviderUtils.getAuthority(uri));
        } else {
            String path2 = null;
            path2 = proxyServer != null && (!NettyAsyncHttpProvider.useProxyConnect(uri) || !config2.isUseRelativeURIsWithConnectProxies()) ? uri.toString() : (uri.getRawQuery() != null ? uri.getRawPath() + "?" + uri.getRawQuery() : uri.getRawPath());
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, path2);
        }
        boolean webSocket = NettyAsyncHttpProvider.isWebSocket(uri.getScheme());
        if (!m.equals(HttpMethod.CONNECT) && webSocket) {
            nettyRequest.addHeader("Upgrade", "WebSocket");
            nettyRequest.addHeader("Connection", "Upgrade");
            nettyRequest.addHeader("Origin", "http://" + uri.getHost() + ":" + uri.getPort());
            nettyRequest.addHeader("Sec-WebSocket-Key", WebSocketUtil.getKey());
            nettyRequest.addHeader("Sec-WebSocket-Version", "13");
        }
        if (host2 != null) {
            if (request.getVirtualHost() != null || uri.getPort() == -1) {
                nettyRequest.setHeader("Host", host2);
            } else {
                nettyRequest.setHeader("Host", host2 + ":" + uri.getPort());
            }
        } else {
            host2 = "127.0.0.1";
        }
        if (!m.equals(HttpMethod.CONNECT)) {
            for (Map.Entry<String, List<String>> header2 : request.getHeaders()) {
                String name2 = header2.getKey();
                if ("Host".equalsIgnoreCase(name2)) continue;
                for (String value2 : header2.getValue()) {
                    nettyRequest.addHeader(name2, value2);
                }
            }
            if (config2.isCompressionEnabled()) {
                nettyRequest.setHeader("Accept-Encoding", GZIP_DEFLATE);
            }
        } else {
            Object auth = request.getHeaders().get("Proxy-Authorization");
            if (NettyAsyncHttpProvider.isNTLM((List<String>)auth)) {
                nettyRequest.addHeader("Proxy-Authorization", auth.get(0));
            }
        }
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : config2.getRealm();
        if (realm != null && realm.getUsePreemptiveAuth()) {
            String domain2 = realm.getNtlmDomain();
            if (proxyServer != null && proxyServer.getNtlmDomain() != null) {
                domain2 = proxyServer.getNtlmDomain();
            }
            String authHost = realm.getNtlmHost();
            if (proxyServer != null && proxyServer.getHost() != null) {
                host2 = proxyServer.getHost();
            }
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    nettyRequest.addHeader("Authorization", AuthenticatorUtils.computeBasicAuthentication(realm));
                    break;
                }
                case DIGEST: {
                    if (!MiscUtil.isNonEmpty(realm.getNonce())) break;
                    try {
                        nettyRequest.addHeader("Authorization", AuthenticatorUtils.computeDigestAuthentication(realm));
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                case NTLM: {
                    try {
                        nettyRequest.addHeader("Authorization", ntlmEngine.generateType1Msg("NTLM " + domain2, authHost));
                        break;
                    }
                    catch (NTLMEngineException e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                }
                case KERBEROS: 
                case SPNEGO: {
                    String challengeHeader = null;
                    String server = proxyServer == null ? host2 : proxyServer.getHost();
                    try {
                        challengeHeader = NettyAsyncHttpProvider.getSpnegoEngine().generateToken(server);
                    }
                    catch (Throwable e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                    nettyRequest.addHeader("Authorization", "Negotiate " + challengeHeader);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid Authentication %s", realm.toString()));
                }
            }
        }
        if (!webSocket && !request.getHeaders().containsKey("Connection")) {
            nettyRequest.setHeader("Connection", AsyncHttpProviderUtils.keepAliveHeaderValue(config2));
        }
        if (proxyServer != null) {
            if (!request.getHeaders().containsKey("Proxy-Connection")) {
                nettyRequest.setHeader("Proxy-Connection", AsyncHttpProviderUtils.keepAliveHeaderValue(config2));
            }
            if (proxyServer.getPrincipal() != null) {
                if (MiscUtil.isNonEmpty(proxyServer.getNtlmDomain())) {
                    Object auth = request.getHeaders().get("Proxy-Authorization");
                    if (!NettyAsyncHttpProvider.isNTLM((List<String>)auth)) {
                        try {
                            String msg = ntlmEngine.generateType1Msg(proxyServer.getNtlmDomain(), proxyServer.getHost());
                            nettyRequest.setHeader("Proxy-Authorization", "NTLM " + msg);
                        }
                        catch (NTLMEngineException e) {
                            IOException ie = new IOException();
                            ie.initCause(e);
                            throw ie;
                        }
                    }
                } else {
                    nettyRequest.setHeader("Proxy-Authorization", AuthenticatorUtils.computeBasicAuthentication(proxyServer));
                }
            }
        }
        if (!request.getHeaders().containsKey("Accept")) {
            nettyRequest.setHeader("Accept", "*/*");
        }
        if ((userAgentHeader = request.getHeaders().getFirstValue("User-Agent")) != null) {
            nettyRequest.setHeader("User-Agent", userAgentHeader);
        } else if (config2.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", config2.getUserAgent());
        } else {
            nettyRequest.setHeader("User-Agent", AsyncHttpProviderUtils.constructUserAgent(NettyAsyncHttpProvider.class));
        }
        if (!m.equals(HttpMethod.CONNECT)) {
            String bodyCharset;
            if (MiscUtil.isNonEmpty(request.getCookies())) {
                nettyRequest.setHeader("Cookie", CookieEncoder.encode(request.getCookies()));
            }
            String string2 = bodyCharset = request.getBodyEncoding() == null ? "ISO-8859-1" : request.getBodyEncoding();
            if (buffer2 != null && buffer2.writerIndex() != 0) {
                nettyRequest.setHeader("Content-Length", buffer2.writerIndex());
                nettyRequest.setContent(buffer2);
            } else if (request.getByteData() != null) {
                nettyRequest.setHeader("Content-Length", String.valueOf(request.getByteData().length));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer(request.getByteData()));
            } else if (request.getStringData() != null) {
                byte[] bytes2 = request.getStringData().getBytes(bodyCharset);
                nettyRequest.setHeader("Content-Length", String.valueOf(bytes2.length));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer(bytes2));
            } else if (MiscUtil.isNonEmpty(request.getParams())) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                    String key = paramEntry.getKey();
                    for (String value3 : paramEntry.getValue()) {
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        UTF8UrlEncoder.appendEncoded(sb, key);
                        sb.append("=");
                        UTF8UrlEncoder.appendEncoded(sb, value3);
                    }
                }
                nettyRequest.setHeader("Content-Length", String.valueOf(sb.length()));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer(sb.toString().getBytes(bodyCharset)));
                if (!request.getHeaders().containsKey("Content-Type")) {
                    nettyRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
                }
            } else if (request.getParts() != null) {
                MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getHeaders());
                nettyRequest.setHeader("Content-Type", mre.getContentType());
                long contentLength = mre.getContentLength();
                if (contentLength >= 0L) {
                    nettyRequest.setHeader("Content-Length", String.valueOf(contentLength));
                }
            } else if (request.getEntityWriter() != null) {
                int length = (int)request.getContentLength();
                if (length == -1) {
                    length = 8192;
                }
                ChannelBuffer b = ChannelBuffers.dynamicBuffer(length);
                request.getEntityWriter().writeEntity(new ChannelBufferOutputStream(b));
                nettyRequest.setHeader("Content-Length", b.writerIndex());
                nettyRequest.setContent(b);
            } else if (request.getFile() != null) {
                File file2 = request.getFile();
                if (!file2.isFile()) {
                    throw new IOException(String.format("File %s is not a file or doesn't exist", file2.getAbsolutePath()));
                }
                nettyRequest.setHeader("Content-Length", file2.length());
            }
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        if (this.isClose.compareAndSet(false, true)) {
            try {
                this.connectionsPool.destroy();
                this.openChannels.close();
                for (Channel channel : this.openChannels) {
                    ChannelHandlerContext ctx = channel.getPipeline().getContext(NettyAsyncHttpProvider.class);
                    if (!(ctx.getAttachment() instanceof NettyResponseFuture)) continue;
                    NettyResponseFuture future2 = (NettyResponseFuture)ctx.getAttachment();
                    future2.cancelTimeouts();
                }
                this.config.executorService().shutdown();
                if (this.allowReleaseSocketChannelFactory) {
                    this.socketChannelFactory.releaseExternalResources();
                    this.plainBootstrap.releaseExternalResources();
                    this.secureBootstrap.releaseExternalResources();
                    this.webSocketBootstrap.releaseExternalResources();
                    this.secureWebSocketBootstrap.releaseExternalResources();
                }
                if (this.allowStopNettyTimer) {
                    this.nettyTimer.stop();
                }
            }
            catch (Throwable t) {
                log.warn("Unexpected error on close", t);
            }
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers2, List<HttpResponseBodyPart> bodyParts) {
        return new NettyResponse(status, headers2, bodyParts);
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null, true, this.executeConnectAsync, false);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f2, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        this.doConnect(request, f2.getAsyncHandler(), f2, useCache, asyncConnect, reclaimCache);
    }

    private <T> NettyResponseFuture<T> buildNettyResponseFutureWithCachedChannel(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f2, ProxyServer proxyServer, URI uri, ChannelBuffer bufferedBytes, int maxTry) throws IOException {
        for (int i = 0; i < maxTry; ++i) {
            if (maxTry == 0) {
                return null;
            }
            Channel channel = null;
            channel = f2 != null && f2.reuseChannel() && f2.channel() != null ? f2.channel() : this.lookupInCache(uri, proxyServer, request.getConnectionPoolKeyStrategy());
            if (channel == null) {
                return null;
            }
            HttpRequest nettyRequest = null;
            if (f2 == null) {
                nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, false, bufferedBytes, proxyServer);
                f2 = NettyAsyncHttpProvider.newFuture(uri, request, asyncHandler, nettyRequest, this.config, this, proxyServer);
            } else if (i == 0) {
                nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, f2.isConnectAllowed(), bufferedBytes, proxyServer);
                f2.setNettyRequest(nettyRequest);
            }
            f2.setState(NettyResponseFuture.STATE.POOLED);
            f2.attachChannel(channel, false);
            if (channel.isOpen() && channel.isConnected()) {
                f2.channel().getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(f2);
                return f2;
            }
            f2.attachChannel(null);
        }
        return null;
    }

    private <T> ListenableFuture<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f2, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        boolean directInvokation;
        ChannelFuture channelFuture;
        NettyResponseFuture<T> connectedFuture;
        boolean useSSl;
        URI uri;
        if (this.isClose()) {
            throw new IOException("Closed");
        }
        URI uRI = uri = this.useRawUrl ? request.getRawURI() : request.getURI();
        if (uri.getScheme().startsWith(WEBSOCKET) && !NettyAsyncHttpProvider.validateWebSocketRequest(request, asyncHandler)) {
            throw new IOException("WebSocket method must be a GET");
        }
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        boolean resultOfAConnect = f2 != null && f2.getNettyRequest() != null && f2.getNettyRequest().getMethod().equals(HttpMethod.CONNECT);
        boolean useProxy = proxyServer != null && !resultOfAConnect;
        ChannelBuffer bufferedBytes = null;
        if (f2 != null && f2.getRequest().getFile() == null && !f2.getNettyRequest().getMethod().getName().equals(HttpMethod.CONNECT.getName())) {
            bufferedBytes = f2.getNettyRequest().getContent();
        }
        boolean bl = useSSl = NettyAsyncHttpProvider.isSecure(uri) && !useProxy;
        if (useCache && (connectedFuture = this.buildNettyResponseFutureWithCachedChannel(request, asyncHandler, f2, proxyServer, uri, bufferedBytes, 3)) != null) {
            log.debug("\nUsing cached Channel {}\n for request \n{}\n", (Object)connectedFuture.channel(), (Object)connectedFuture.getNettyRequest());
            try {
                this.writeRequest(connectedFuture.channel(), this.config, connectedFuture);
            }
            catch (Exception ex) {
                log.debug("writeRequest failure", ex);
                if (useSSl && ex.getMessage() != null && ex.getMessage().contains("SSLEngine")) {
                    log.debug("SSLEngine failure", ex);
                    connectedFuture = null;
                }
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Throwable t) {
                    log.warn("doConnect.writeRequest()", t);
                }
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            return connectedFuture;
        }
        if (!reclaimCache && !this.connectionsPool.canCacheConnection()) {
            IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
            try {
                asyncHandler.onThrowable(ex);
            }
            catch (Throwable t) {
                log.warn("!connectionsPool.canCacheConnection()", t);
            }
            throw ex;
        }
        boolean acquiredConnection = false;
        if (this.trackConnections && !reclaimCache) {
            if (!this.freeConnections.tryAcquire()) {
                IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Throwable t) {
                    log.warn("!connectionsPool.canCacheConnection()", t);
                }
                throw ex;
            }
            acquiredConnection = true;
        }
        NettyConnectListener<T> c = new NettyConnectListener.Builder<T>(this.config, request, asyncHandler, f2, this, bufferedBytes).build(uri);
        if (useSSl) {
            this.constructSSLPipeline(c);
        }
        ClientBootstrap bootstrap = request.getURI().getScheme().startsWith(WEBSOCKET) && !useProxy ? (useSSl ? this.secureWebSocketBootstrap : this.webSocketBootstrap) : (useSSl ? this.secureBootstrap : this.plainBootstrap);
        bootstrap.setOption("connectTimeoutMillis", this.config.getConnectionTimeoutInMs());
        if (!System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win")) {
            bootstrap.setOption("reuseAddress", this.providerConfig.getProperty("reuseAddress"));
        }
        try {
            InetSocketAddress remoteAddress = request.getInetAddress() != null ? new InetSocketAddress(request.getInetAddress(), AsyncHttpProviderUtils.getPort(uri)) : (!useProxy ? new InetSocketAddress(AsyncHttpProviderUtils.getHost(uri), AsyncHttpProviderUtils.getPort(uri)) : new InetSocketAddress(proxyServer.getHost(), proxyServer.getPort()));
            channelFuture = request.getLocalAddress() != null ? bootstrap.connect(remoteAddress, new InetSocketAddress(request.getLocalAddress(), 0)) : bootstrap.connect(remoteAddress);
        }
        catch (Throwable t) {
            if (acquiredConnection) {
                this.freeConnections.release();
            }
            this.abort(c.future(), t.getCause() == null ? t : t.getCause());
            return c.future();
        }
        boolean bl2 = directInvokation = IN_IO_THREAD.get() == false || !DefaultChannelFuture.isUseDeadLockChecker();
        if (directInvokation && !asyncConnect && request.getFile() == null) {
            int timeOut;
            int n = timeOut = this.config.getConnectionTimeoutInMs() > 0 ? this.config.getConnectionTimeoutInMs() : Integer.MAX_VALUE;
            if (!channelFuture.awaitUninterruptibly(timeOut, TimeUnit.MILLISECONDS)) {
                if (acquiredConnection) {
                    this.freeConnections.release();
                }
                channelFuture.cancel();
                this.abort(c.future(), new ConnectException(String.format("Connect operation to %s timeout %s", uri, timeOut)));
            }
            try {
                c.operationComplete(channelFuture);
            }
            catch (Exception e) {
                if (acquiredConnection) {
                    this.freeConnections.release();
                }
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                try {
                    asyncHandler.onThrowable(ioe);
                }
                catch (Throwable t) {
                    log.warn("c.operationComplete()", t);
                }
                throw ioe;
            }
        }
        channelFuture.addListener(c);
        log.debug("\nNon cached request \n{}\n\nusing Channel \n{}\n", (Object)c.future().getNettyRequest(), (Object)channelFuture.getChannel());
        if (!c.future().isCancelled() || !c.future().isDone()) {
            this.openChannels.add(channelFuture.getChannel());
            c.future().attachChannel(channelFuture.getChannel(), false);
        } else if (acquiredConnection) {
            this.freeConnections.release();
        }
        return c.future();
    }

    protected static int requestTimeoutInMs(AsyncHttpClientConfig config2, PerRequestConfig perRequestConfig) {
        int prRequestTimeout;
        int result2 = perRequestConfig != null ? ((prRequestTimeout = perRequestConfig.getRequestTimeoutInMs()) != 0 ? prRequestTimeout : config2.getRequestTimeoutInMs()) : config2.getRequestTimeoutInMs();
        return result2;
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        this.connectionsPool.removeAll(ctx.getChannel());
        this.finishChannel(ctx);
    }

    private void finishChannel(ChannelHandlerContext ctx) {
        ctx.setAttachment(new DiscardEvent());
        if (ctx.getChannel() == null) {
            return;
        }
        log.debug("Closing Channel {} ", (Object)ctx.getChannel());
        try {
            ctx.getChannel().close();
        }
        catch (Throwable t) {
            log.debug("Error closing a connection", t);
        }
        if (ctx.getChannel() != null) {
            this.openChannels.remove(ctx.getChannel());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        IN_IO_THREAD.set(Boolean.TRUE);
        if (ctx.getAttachment() == null) {
            log.debug("ChannelHandlerContext wasn't having any attachment");
        }
        if (ctx.getAttachment() instanceof DiscardEvent) {
            return;
        }
        if (ctx.getAttachment() instanceof AsyncCallable) {
            if (e.getMessage() instanceof HttpChunk) {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                if (!chunk.isLast()) return;
                AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                ac.call();
            } else {
                AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                ac.call();
            }
            ctx.setAttachment(new DiscardEvent());
            return;
        }
        if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
            try {
                ctx.getChannel().close();
                return;
            }
            catch (Throwable t) {
                log.trace("Closing an orphan channel {}", (Object)ctx.getChannel());
            }
            return;
        }
        Protocol p = ctx.getPipeline().get(HTTP_PROCESSOR) != null ? this.httpProtocol : this.webSocketProtocol;
        p.handle(ctx, e);
    }

    private Realm kerberosChallenge(List<String> proxyAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers2, Realm realm, NettyResponseFuture<?> future2, boolean proxyInd) throws NTLMEngineException {
        URI uri = request.getURI();
        String host2 = request.getVirtualHost() == null ? AsyncHttpProviderUtils.getHost(uri) : request.getVirtualHost();
        String server = proxyServer == null ? host2 : proxyServer.getHost();
        try {
            String challengeHeader = NettyAsyncHttpProvider.getSpnegoEngine().generateToken(server);
            headers2.remove("Authorization");
            headers2.add("Authorization", "Negotiate " + challengeHeader);
            Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm) : new Realm.RealmBuilder();
            return realmBuilder.setUri(uri.getRawPath()).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (Throwable throwable) {
            if (NettyAsyncHttpProvider.isNTLM(proxyAuth)) {
                return this.ntlmChallenge(proxyAuth, request, proxyServer, headers2, realm, future2, proxyInd);
            }
            this.abort(future2, throwable);
            return null;
        }
    }

    private String authorizationHeaderName(boolean proxyInd) {
        return proxyInd ? "Proxy-Authorization" : "Authorization";
    }

    private void addNTLMAuthorization(FluentCaseInsensitiveStringsMap headers2, String challengeHeader, boolean proxyInd) {
        headers2.add(this.authorizationHeaderName(proxyInd), "NTLM " + challengeHeader);
    }

    private void addType3NTLMAuthorizationHeader(List<String> auth, FluentCaseInsensitiveStringsMap headers2, String username2, String password, String domain2, String workstation, boolean proxyInd) throws NTLMEngineException {
        headers2.remove(this.authorizationHeaderName(proxyInd));
        if (MiscUtil.isNonEmpty(auth) && auth.get(0).startsWith("NTLM ")) {
            String serverChallenge = auth.get(0).trim().substring("NTLM ".length());
            String challengeHeader = ntlmEngine.generateType3Msg(username2, password, domain2, workstation, serverChallenge);
            this.addNTLMAuthorization(headers2, challengeHeader, proxyInd);
        }
    }

    private Realm ntlmChallenge(List<String> wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers2, Realm realm, NettyResponseFuture<?> future2, boolean proxyInd) throws NTLMEngineException {
        Realm newRealm;
        String password;
        boolean useRealm = proxyServer == null && realm != null;
        String ntlmDomain = useRealm ? realm.getNtlmDomain() : proxyServer.getNtlmDomain();
        String ntlmHost = useRealm ? realm.getNtlmHost() : proxyServer.getHost();
        String principal = useRealm ? realm.getPrincipal() : proxyServer.getPrincipal();
        String string2 = password = useRealm ? realm.getPassword() : proxyServer.getPassword();
        if (realm != null && !realm.isNtlmMessageType2Received()) {
            String challengeHeader = ntlmEngine.generateType1Msg(ntlmDomain, ntlmHost);
            URI uri = request.getURI();
            this.addNTLMAuthorization(headers2, challengeHeader, proxyInd);
            newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(uri.getRawPath()).setMethodName(request.getMethod()).setNtlmMessageType2Received(true).build();
            future2.getAndSetAuth(false);
        } else {
            Realm.AuthScheme authScheme;
            Realm.RealmBuilder realmBuilder;
            this.addType3NTLMAuthorizationHeader(wwwAuth, headers2, principal, password, ntlmDomain, ntlmHost, proxyInd);
            if (realm != null) {
                realmBuilder = new Realm.RealmBuilder().clone(realm);
                authScheme = realm.getAuthScheme();
            } else {
                realmBuilder = new Realm.RealmBuilder();
                authScheme = Realm.AuthScheme.NTLM;
            }
            newRealm = realmBuilder.setScheme(authScheme).setUri(request.getURI().getPath()).setMethodName(request.getMethod()).build();
        }
        return newRealm;
    }

    private Realm ntlmProxyChallenge(List<String> wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers2, Realm realm, NettyResponseFuture<?> future2) throws NTLMEngineException {
        future2.getAndSetAuth(false);
        this.addType3NTLMAuthorizationHeader(wwwAuth, headers2, proxyServer.getPrincipal(), proxyServer.getPassword(), proxyServer.getNtlmDomain(), proxyServer.getHost(), true);
        Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder();
        if (realm != null) {
            realmBuilder = realmBuilder.clone(realm);
        }
        Realm newRealm = realmBuilder.setUri(request.getURI().getPath()).setMethodName(request.getMethod()).build();
        return newRealm;
    }

    private String getPoolKey(NettyResponseFuture<?> future2) {
        return this.getPoolKey(future2.getURI(), future2.getProxyServer(), future2.getConnectionPoolKeyStrategy());
    }

    private String getPoolKey(URI uri, ProxyServer proxy, ConnectionPoolKeyStrategy strategy) {
        String serverPart = strategy.getKey(uri);
        return proxy != null ? proxy.getUrl() + serverPart : serverPart;
    }

    private void drainChannel(final ChannelHandlerContext ctx, final NettyResponseFuture<?> future2) {
        ctx.setAttachment(new AsyncCallable(future2){

            public Object call() throws Exception {
                if (future2.getKeepAlive() && ctx.getChannel().isReadable() && NettyAsyncHttpProvider.this.connectionsPool.offer(NettyAsyncHttpProvider.this.getPoolKey(future2), ctx.getChannel())) {
                    return null;
                }
                NettyAsyncHttpProvider.this.finishChannel(ctx);
                return null;
            }

            public String toString() {
                return String.format("Draining task for channel %s", ctx.getChannel());
            }
        });
    }

    private FilterContext handleIoException(FilterContext fc, NettyResponseFuture<?> future2) {
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(future2, efe);
            }
        }
        return fc;
    }

    private void replayRequest(NettyResponseFuture<?> future2, FilterContext fc, HttpResponse response, ChannelHandlerContext ctx) throws IOException {
        if (future2.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future2.getAsyncHandler())).onRetry();
        }
        Request newRequest = fc.getRequest();
        future2.setAsyncHandler(fc.getAsyncHandler());
        future2.setState(NettyResponseFuture.STATE.NEW);
        future2.touch();
        log.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, (Object)future2);
        this.drainChannel(ctx, future2);
        this.nextRequest(newRequest, future2);
    }

    private List<String> getAuthorizationToken(List<Map.Entry<String, String>> list2, String headerAuth) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> e : list2) {
            if (!e.getKey().equalsIgnoreCase(headerAuth)) continue;
            l.add(e.getValue().trim());
        }
        return l;
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future2) throws IOException {
        this.nextRequest(request, future2, true);
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future2, boolean useCache) throws IOException {
        this.execute(request, future2, useCache, true, true);
    }

    public void abort(NettyResponseFuture<?> future2, Throwable t) {
        Channel channel = future2.channel();
        if (channel != null && this.openChannels.contains(channel)) {
            this.closeChannel(channel.getPipeline().getContext(NettyAsyncHttpProvider.class));
            this.openChannels.remove(channel);
        }
        if (!future2.isCancelled() && !future2.isDone()) {
            log.debug("Aborting Future {}\n", (Object)future2);
            log.debug(t.getMessage(), t);
        }
        future2.abort(t);
    }

    private void upgradeProtocol(ChannelPipeline p, String scheme2) throws IOException, GeneralSecurityException {
        if (p.get(HTTP_HANDLER) != null) {
            p.remove(HTTP_HANDLER);
        }
        if (NettyAsyncHttpProvider.isSecure(scheme2)) {
            if (p.get(SSL_HANDLER) == null) {
                p.addFirst(HTTP_HANDLER, this.createHttpClientCodec());
                p.addFirst(SSL_HANDLER, new SslHandler(this.createSSLEngine()));
            } else {
                p.addAfter(SSL_HANDLER, HTTP_HANDLER, this.createHttpClientCodec());
            }
        } else {
            p.addFirst(HTTP_HANDLER, this.createHttpClientCodec());
        }
        if (NettyAsyncHttpProvider.isWebSocket(scheme2)) {
            p.replace(HTTP_PROCESSOR, WS_PROCESSOR, (ChannelHandler)this);
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.isClose()) {
            return;
        }
        this.connectionsPool.removeAll(ctx.getChannel());
        try {
            super.channelClosed(ctx, e);
        }
        catch (Exception ex) {
            log.trace("super.channelClosed", ex);
        }
        log.debug("Channel Closed: {} with attachment {}", (Object)e.getChannel(), ctx.getAttachment());
        if (ctx.getAttachment() instanceof AsyncCallable) {
            AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
            ctx.setAttachment(ac.future());
            ac.call();
            return;
        }
        if (ctx.getAttachment() instanceof NettyResponseFuture) {
            NettyResponseFuture future2 = (NettyResponseFuture)ctx.getAttachment();
            future2.touch();
            if (!this.config.getIOExceptionFilters().isEmpty()) {
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future2.getAsyncHandler()).request(future2.getRequest()).ioException(new IOException("Channel Closed")).build();
                if ((fc = this.handleIoException(fc, future2)).replayRequest() && !future2.cannotBeReplay()) {
                    this.replayRequest(future2, fc, null, ctx);
                    return;
                }
            }
            Protocol p = ctx.getPipeline().get(HttpClientCodec.class) != null ? this.httpProtocol : this.webSocketProtocol;
            p.onClose(ctx, e);
            if (future2 != null && !future2.isDone() && !future2.isCancelled()) {
                if (this.remotelyClosed(ctx.getChannel(), future2)) {
                    this.abort(future2, REMOTELY_CLOSED_EXCEPTION);
                }
            } else {
                this.closeChannel(ctx);
            }
        }
    }

    protected boolean remotelyClosed(Channel channel, NettyResponseFuture<?> future2) {
        Object attachment;
        if (this.isClose()) {
            return true;
        }
        this.connectionsPool.removeAll(channel);
        if (future2 == null && (attachment = channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment()) instanceof NettyResponseFuture) {
            future2 = (NettyResponseFuture)attachment;
        }
        if (future2 == null || future2.cannotBeReplay()) {
            log.debug("Unable to recover future {}\n", (Object)future2);
            return true;
        }
        future2.setState(NettyResponseFuture.STATE.RECONNECTED);
        log.debug("Trying to recover request {}\n", (Object)future2.getNettyRequest());
        if (future2.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future2.getAsyncHandler())).onRetry();
        }
        try {
            this.nextRequest(future2.getRequest(), future2);
            return false;
        }
        catch (IOException iox) {
            future2.setState(NettyResponseFuture.STATE.CLOSED);
            future2.abort(iox);
            log.error("Remotely Closed, unable to recover", iox);
            return true;
        }
    }

    private void markAsDone(NettyResponseFuture<?> future2, ChannelHandlerContext ctx) throws MalformedURLException {
        try {
            future2.done();
        }
        catch (Throwable t) {
            log.debug(t.getMessage(), t);
        }
        if (!future2.getKeepAlive() || !ctx.getChannel().isReadable()) {
            this.closeChannel(ctx);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future2, ChannelHandlerContext ctx, boolean lastValidChunk) throws IOException {
        if (lastValidChunk && future2.getKeepAlive()) {
            this.drainChannel(ctx, future2);
        } else {
            if (future2.getKeepAlive() && ctx.getChannel().isReadable() && this.connectionsPool.offer(this.getPoolKey(future2), ctx.getChannel())) {
                this.markAsDone(future2, ctx);
                return;
            }
            this.finishChannel(ctx);
        }
        this.markAsDone(future2, ctx);
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(NettyResponseFuture<?> future2, AsyncHandler handler, HttpResponseBodyPart c) throws Exception {
        boolean state;
        boolean bl = state = handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
        if (c.closeUnderlyingConnection()) {
            future2.setKeepAlive(false);
        }
        return state;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NettyResponseFuture<?> future2;
        Throwable cause;
        block17: {
            Channel channel = e.getChannel();
            cause = e.getCause();
            future2 = null;
            if (e.getCause() instanceof PrematureChannelClosureException) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
            }
            try {
                if (cause instanceof ClosedChannelException) {
                    return;
                }
                if (ctx.getAttachment() instanceof NettyResponseFuture) {
                    future2 = (NettyResponseFuture<?>)ctx.getAttachment();
                    future2.attachChannel(null, false);
                    future2.touch();
                    if (cause instanceof IOException) {
                        if (!this.config.getIOExceptionFilters().isEmpty()) {
                            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future2.getAsyncHandler()).request(future2.getRequest()).ioException(new IOException("Channel Closed")).build();
                            if ((fc = this.handleIoException(fc, future2)).replayRequest()) {
                                this.replayRequest(future2, fc, null, ctx);
                                return;
                            }
                        } else {
                            try {
                                ctx.getChannel().close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    if (NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                        log.debug("Trying to recover from dead Channel: {}", (Object)channel);
                        return;
                    }
                    break block17;
                }
                if (ctx.getAttachment() instanceof AsyncCallable) {
                    future2 = ((AsyncCallable)ctx.getAttachment()).future();
                }
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        if (future2 != null) {
            try {
                log.debug("Was unable to recover Future: {}", (Object)future2);
                this.abort(future2, cause);
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        }
        Protocol p = ctx.getPipeline().get(HttpClientCodec.class) != null ? this.httpProtocol : this.webSocketProtocol;
        p.onError(ctx, e);
        this.closeChannel(ctx);
        ctx.sendUpstream(e);
    }

    protected static boolean abortOnConnectCloseException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("sun.nio.ch.SocketChannelImpl") || !element.getMethodName().equals("checkConnect")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnDisconnectException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("org.jboss.netty.handler.ssl.SslHandler") || !element.getMethodName().equals("channelDisconnected")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnReadCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("read")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    protected static boolean abortOnWriteCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("write")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnWriteCloseException(cause.getCause());
        }
        return false;
    }

    public static <T> NettyResponseFuture<T> newFuture(URI uri, Request request, AsyncHandler<T> asyncHandler, HttpRequest nettyRequest, AsyncHttpClientConfig config2, NettyAsyncHttpProvider provider, ProxyServer proxyServer) {
        NettyResponseFuture<T> f2 = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, NettyAsyncHttpProvider.requestTimeoutInMs(config2, request.getPerRequestConfig()), config2.getIdleConnectionTimeoutInMs(), provider, request.getConnectionPoolKeyStrategy(), proxyServer);
        String expectHeader = request.getHeaders().getFirstValue("Expect");
        if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
            f2.getAndSetWriteBody(false);
        }
        return f2;
    }

    protected AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    private static final boolean validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        return request.getMethod() == "GET" && asyncHandler instanceof WebSocketUpgradeHandler;
    }

    private boolean redirect(Request request, NettyResponseFuture<?> future2, HttpResponse response, final ChannelHandlerContext ctx) throws Exception {
        boolean redirectEnabled;
        int statusCode = response.getStatus().getCode();
        boolean bl = redirectEnabled = request.isRedirectOverrideSet() ? request.isRedirectEnabled() : this.config.isRedirectEnabled();
        if (redirectEnabled && (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307)) {
            if (future2.incrementAndGetCurrentRedirectCount() < this.config.getMaxRedirects()) {
                future2.getAndSetAuth(false);
                String location = response.getHeader("Location");
                URI uri = AsyncHttpProviderUtils.getRedirectUri(future2.getURI(), location);
                boolean stripQueryString = this.config.isRemoveQueryParamOnRedirect();
                if (!uri.toString().equals(future2.getURI().toString())) {
                    RequestBuilder nBuilder;
                    RequestBuilder requestBuilder = nBuilder = stripQueryString ? new RequestBuilder(future2.getRequest()).setQueryParameters(null) : new RequestBuilder(future2.getRequest());
                    if (!(statusCode < 302 || statusCode > 303 || statusCode == 302 && this.config.isStrict302Handling())) {
                        nBuilder.setMethod("GET");
                    }
                    final boolean initialConnectionKeepAlive = future2.getKeepAlive();
                    final String initialPoolKey = this.getPoolKey(future2);
                    future2.setURI(uri);
                    String newUrl = uri.toString();
                    if (request.getURI().getScheme().startsWith(WEBSOCKET)) {
                        newUrl = newUrl.replace(HTTP, WEBSOCKET);
                    }
                    log.debug("Redirecting to {}", (Object)newUrl);
                    List<String> setCookieHeaders = future2.getHttpResponse().getHeaders("Set-Cookie2");
                    if (!MiscUtil.isNonEmpty(setCookieHeaders)) {
                        setCookieHeaders = future2.getHttpResponse().getHeaders("Set-Cookie");
                    }
                    for (String cookieStr : setCookieHeaders) {
                        nBuilder.addOrReplaceCookie(CookieDecoder.decode(cookieStr));
                    }
                    AsyncCallable ac = new AsyncCallable(future2){

                        public Object call() throws Exception {
                            if (initialConnectionKeepAlive && ctx.getChannel().isReadable() && NettyAsyncHttpProvider.this.connectionsPool.offer(initialPoolKey, ctx.getChannel())) {
                                return null;
                            }
                            NettyAsyncHttpProvider.this.finishChannel(ctx);
                            return null;
                        }
                    };
                    if (response.isChunked()) {
                        ctx.setAttachment(ac);
                    } else {
                        ac.call();
                    }
                    this.nextRequest(nBuilder.setUrl(newUrl).build(), future2);
                    return true;
                }
            } else {
                throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
            }
        }
        return false;
    }

    private final String computeRealmURI(Realm realm, URI requestURI) throws URISyntaxException {
        if (realm.isUseAbsoluteURI()) {
            if (realm.isOmitQuery() && MiscUtil.isNonEmpty(requestURI.getQuery())) {
                return new URI(requestURI.getScheme(), requestURI.getAuthority(), requestURI.getPath(), null, null).toString();
            }
            return requestURI.toString();
        }
        if (realm.isOmitQuery() || !MiscUtil.isNonEmpty(requestURI.getQuery())) {
            return requestURI.getPath();
        }
        return requestURI.getPath() + "?" + requestURI.getQuery();
    }

    public boolean isClose() {
        return this.isClose.get();
    }

    public Timeout newTimeoutInMs(TimerTask task, long delayInMs) {
        return this.nettyTimer.newTimeout(task, delayInMs, TimeUnit.MILLISECONDS);
    }

    private static boolean isWebSocket(String scheme2) {
        return WEBSOCKET.equalsIgnoreCase(scheme2) || WEBSOCKET_SSL.equalsIgnoreCase(scheme2);
    }

    private static boolean isSecure(String scheme2) {
        return HTTPS.equalsIgnoreCase(scheme2) || WEBSOCKET_SSL.equalsIgnoreCase(scheme2);
    }

    private static boolean isSecure(URI uri) {
        return NettyAsyncHttpProvider.isSecure(uri.getScheme());
    }

    static {
        REMOTELY_CLOSED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
        log = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
        UTF8 = Charset.forName("UTF-8");
        IN_IO_THREAD = new ThreadLocalBoolean();
        ntlmEngine = new NTLMEngine();
        spnegoEngine = null;
    }

    private final class WebSocketProtocol
    implements Protocol {
        private static final byte OPCODE_CONT = 0;
        private static final byte OPCODE_TEXT = 1;
        private static final byte OPCODE_BINARY = 2;
        private static final byte OPCODE_PING = 9;
        private static final byte OPCODE_PONG = 10;
        private static final byte OPCODE_UNKNOWN = -1;

        private WebSocketProtocol() {
        }

        private void invokeOnSucces(ChannelHandlerContext ctx, WebSocketUpgradeHandler h2) {
            if (!h2.touchSuccess()) {
                try {
                    h2.onSuccess(new NettyWebSocket(ctx.getChannel()));
                }
                catch (Exception ex) {
                    WebSocketProtocol webSocketProtocol = this;
                    log.warn("onSuccess unexexpected exception", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            NettyResponseFuture future2 = (NettyResponseFuture)NettyResponseFuture.class.cast(ctx.getAttachment());
            WebSocketUpgradeHandler h2 = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(future2.getAsyncHandler());
            Request request = future2.getRequest();
            if (e.getMessage() instanceof HttpResponse) {
                boolean headerOK;
                boolean statusReceived;
                HttpResponse response = (HttpResponse)e.getMessage();
                ResponseStatus s2 = new ResponseStatus(future2.getURI(), response, NettyAsyncHttpProvider.this);
                ResponseHeaders responseHeaders = new ResponseHeaders(future2.getURI(), response, NettyAsyncHttpProvider.this);
                FilterContext fc = new FilterContext.FilterContextBuilder<WebSocket>().asyncHandler(h2).request(request).responseStatus(s2).responseHeaders(responseHeaders).build();
                for (ResponseFilter asyncFilter : NettyAsyncHttpProvider.this.config.getResponseFilters()) {
                    try {
                        if ((fc = asyncFilter.filter(fc)) != null) continue;
                        throw new NullPointerException("FilterContext is null");
                    }
                    catch (FilterException efe) {
                        NettyAsyncHttpProvider.this.abort(future2, efe);
                    }
                }
                future2.setAsyncHandler(fc.getAsyncHandler());
                if (fc.replayRequest()) {
                    NettyAsyncHttpProvider.this.replayRequest(future2, fc, response, ctx);
                    return;
                }
                future2.setHttpResponse(response);
                if (NettyAsyncHttpProvider.this.redirect(request, future2, response, ctx)) {
                    return;
                }
                org.jboss.netty.handler.codec.http.HttpResponseStatus status = new org.jboss.netty.handler.codec.http.HttpResponseStatus(101, "Web Socket Protocol Handshake");
                boolean validStatus = response.getStatus().equals(status);
                boolean validUpgrade = response.getHeader("Upgrade") != null;
                String c = response.getHeader("Connection");
                if (c == null) {
                    c = response.getHeader("connection");
                }
                boolean validConnection = c == null ? false : c.equalsIgnoreCase("Upgrade");
                s2 = new ResponseStatus(future2.getURI(), response, NettyAsyncHttpProvider.this);
                boolean bl = statusReceived = h2.onStatusReceived(s2) == AsyncHandler.STATE.UPGRADE;
                if (!statusReceived) {
                    try {
                        h2.onCompleted();
                    }
                    finally {
                        future2.done();
                    }
                    return;
                }
                boolean bl2 = headerOK = h2.onHeadersReceived(responseHeaders) == AsyncHandler.STATE.CONTINUE;
                if (!(headerOK && validStatus && validUpgrade && validConnection)) {
                    NettyAsyncHttpProvider.this.abort(future2, new IOException("Invalid handshake response"));
                    return;
                }
                String accept2 = response.getHeader("Sec-WebSocket-Accept");
                String key = WebSocketUtil.getAcceptKey(future2.getNettyRequest().getHeader("Sec-WebSocket-Key"));
                if (accept2 == null || !accept2.equals(key)) {
                    NettyAsyncHttpProvider.this.abort(future2, new IOException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept2, key)));
                    return;
                }
                ctx.getPipeline().replace(NettyAsyncHttpProvider.HTTP_HANDLER, "ws-encoder", (ChannelHandler)new WebSocket08FrameEncoder(true));
                ctx.getPipeline().addBefore(NettyAsyncHttpProvider.WS_PROCESSOR, "ws-decoder", new WebSocket08FrameDecoder(false, false));
                this.invokeOnSucces(ctx, h2);
                future2.done();
            } else if (e.getMessage() instanceof WebSocketFrame) {
                this.invokeOnSucces(ctx, h2);
                WebSocketFrame frame = (WebSocketFrame)e.getMessage();
                int pendingOpcode = -1;
                if (frame instanceof TextWebSocketFrame) {
                    pendingOpcode = 1;
                } else if (frame instanceof BinaryWebSocketFrame) {
                    pendingOpcode = 2;
                } else if (frame instanceof PingWebSocketFrame) {
                    pendingOpcode = 9;
                } else if (frame instanceof PongWebSocketFrame) {
                    pendingOpcode = 10;
                }
                HttpChunk webSocketChunk = new HttpChunk(){
                    private ChannelBuffer content;

                    public boolean isLast() {
                        return false;
                    }

                    public ChannelBuffer getContent() {
                        return this.content;
                    }

                    public void setContent(ChannelBuffer content) {
                        this.content = content;
                    }
                };
                if (frame.getBinaryData() != null) {
                    webSocketChunk.setContent(ChannelBuffers.wrappedBuffer(frame.getBinaryData()));
                    ResponseBodyPart rp = new ResponseBodyPart(future2.getURI(), null, NettyAsyncHttpProvider.this, webSocketChunk, true);
                    h2.onBodyPartReceived(rp);
                    NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h2.onCompleted());
                    if (webSocket != null) {
                        if (pendingOpcode == 2) {
                            webSocket.onBinaryFragment(rp.getBodyPartBytes(), frame.isFinalFragment());
                        } else if (pendingOpcode == 1) {
                            webSocket.onTextFragment(frame.getBinaryData().toString(UTF8), frame.isFinalFragment());
                        } else if (pendingOpcode == 9) {
                            webSocket.onPing(rp.getBodyPartBytes());
                        } else if (pendingOpcode == 10) {
                            webSocket.onPong(rp.getBodyPartBytes());
                        }
                        if (frame instanceof CloseWebSocketFrame) {
                            try {
                                ctx.setAttachment(DiscardEvent.class);
                                webSocket.onClose(((CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame)).getStatusCode(), ((CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame)).getReasonText());
                            }
                            catch (Throwable t) {
                                log.trace("", t);
                            }
                            finally {
                                h2.resetSuccess();
                            }
                        }
                    } else {
                        log.debug("UpgradeHandler returned a null NettyWebSocket ");
                    }
                }
            } else {
                log.error("Invalid attachment {}", ctx.getAttachment());
            }
        }

        public void onError(ChannelHandlerContext ctx, ExceptionEvent e) {
            try {
                log.warn("onError {}", (Object)e);
                if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
                    return;
                }
                NettyResponseFuture nettyResponse = (NettyResponseFuture)NettyResponseFuture.class.cast(ctx.getAttachment());
                WebSocketUpgradeHandler h2 = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
                NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h2.onCompleted());
                if (webSocket != null) {
                    webSocket.onError(e.getCause());
                    webSocket.close();
                }
            }
            catch (Throwable t) {
                log.error("onError", t);
            }
        }

        public void onClose(ChannelHandlerContext ctx, ChannelStateEvent e) {
            log.trace("onClose {}", (Object)e);
            if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
                return;
            }
            try {
                NettyResponseFuture nettyResponse = (NettyResponseFuture)NettyResponseFuture.class.cast(ctx.getAttachment());
                WebSocketUpgradeHandler h2 = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
                NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h2.onCompleted());
                h2.resetSuccess();
                log.trace("Connection was closed abnormally (that is, with no close frame being sent).");
                if (!(ctx.getAttachment() instanceof DiscardEvent) && webSocket != null) {
                    webSocket.close(1006, "Connection was closed abnormally (that is, with no close frame being sent).");
                }
            }
            catch (Throwable t) {
                log.error("onError", t);
            }
        }
    }

    private final class HttpProtocol
    implements Protocol {
        private HttpProtocol() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            block40: {
                final NettyResponseFuture future2 = (NettyResponseFuture)ctx.getAttachment();
                future2.touch();
                if (future2.isCancelled() || future2.isDone()) {
                    NettyAsyncHttpProvider.this.finishChannel(ctx);
                    return;
                }
                HttpRequest nettyRequest = future2.getNettyRequest();
                AsyncHandler<Object> handler = future2.getAsyncHandler();
                Request request = future2.getRequest();
                ProxyServer proxyServer = future2.getProxyServer();
                HttpResponse response = null;
                try {
                    if (e.getMessage() instanceof HttpResponse) {
                        response = (HttpResponse)e.getMessage();
                        log.debug("\n\nRequest {}\n\nResponse {}\n", (Object)nettyRequest, (Object)response);
                        future2.setHttpResponse(response);
                        int statusCode = response.getStatus().getCode();
                        String ka = response.getHeader("Connection");
                        future2.setKeepAlive(ka == null || ka.equalsIgnoreCase("keep-alive"));
                        List wwwAuth = NettyAsyncHttpProvider.this.getAuthorizationToken(response.getHeaders(), "WWW-Authenticate");
                        Realm realm = request.getRealm() != null ? request.getRealm() : NettyAsyncHttpProvider.this.config.getRealm();
                        ResponseStatus status = new ResponseStatus(future2.getURI(), response, NettyAsyncHttpProvider.this);
                        ResponseHeaders responseHeaders = new ResponseHeaders(future2.getURI(), response, NettyAsyncHttpProvider.this);
                        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(request).responseStatus(status).responseHeaders(responseHeaders).build();
                        for (ResponseFilter asyncFilter : NettyAsyncHttpProvider.this.config.getResponseFilters()) {
                            try {
                                if ((fc = asyncFilter.filter(fc)) != null) continue;
                                throw new NullPointerException("FilterContext is null");
                            }
                            catch (FilterException efe) {
                                NettyAsyncHttpProvider.this.abort(future2, efe);
                            }
                        }
                        handler = fc.getAsyncHandler();
                        future2.setAsyncHandler(handler);
                        if (fc.replayRequest()) {
                            NettyAsyncHttpProvider.this.replayRequest(future2, fc, response, ctx);
                            return;
                        }
                        final FluentCaseInsensitiveStringsMap headers2 = request.getHeaders();
                        final RequestBuilder builder = new RequestBuilder(future2.getRequest());
                        if (statusCode == 401 && realm != null && !wwwAuth.isEmpty() && !future2.getAndSetAuth(true)) {
                            future2.setState(NettyResponseFuture.STATE.NEW);
                            Realm newRealm = null;
                            if (!wwwAuth.contains("Kerberos") && (NettyAsyncHttpProvider.isNTLM(wwwAuth) || wwwAuth.contains("Negotiate"))) {
                                newRealm = NettyAsyncHttpProvider.this.ntlmChallenge(wwwAuth, request, proxyServer, headers2, realm, future2, false);
                            } else if (wwwAuth.contains("Negotiate")) {
                                newRealm = NettyAsyncHttpProvider.this.kerberosChallenge(wwwAuth, request, proxyServer, headers2, realm, future2, false);
                                if (newRealm == null) {
                                    return;
                                }
                            } else {
                                Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme());
                                newRealm = realmBuilder.setUri(request.getURI().getPath()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader((String)wwwAuth.get(0)).build();
                            }
                            String realmURI = NettyAsyncHttpProvider.this.computeRealmURI(newRealm, request.getURI());
                            final Realm nr = new Realm.RealmBuilder().clone(newRealm).setUri(realmURI).build();
                            log.debug("Sending authentication to {}", (Object)request.getURI());
                            AsyncCallable ac = new AsyncCallable(future2){

                                public Object call() throws Exception {
                                    NettyAsyncHttpProvider.this.drainChannel(ctx, future2);
                                    NettyAsyncHttpProvider.this.nextRequest(((RequestBuilder)builder.setHeaders(headers2).setRealm(nr)).build(), future2);
                                    return null;
                                }
                            };
                            if (future2.getKeepAlive() && response.isChunked()) {
                                ctx.setAttachment(ac);
                            } else {
                                ac.call();
                            }
                            return;
                        }
                        if (statusCode == 100) {
                            future2.getAndSetWriteHeaders(false);
                            future2.getAndSetWriteBody(true);
                            NettyAsyncHttpProvider.this.writeRequest(ctx.getChannel(), NettyAsyncHttpProvider.this.config, future2);
                            return;
                        }
                        List proxyAuth = NettyAsyncHttpProvider.this.getAuthorizationToken(response.getHeaders(), "Proxy-Authenticate");
                        if (statusCode == 407 && realm != null && !proxyAuth.isEmpty() && !future2.getAndSetAuth(true)) {
                            log.debug("Sending proxy authentication to {}", (Object)request.getURI());
                            future2.setState(NettyResponseFuture.STATE.NEW);
                            Realm newRealm = null;
                            if (!proxyAuth.contains("Kerberos") && (NettyAsyncHttpProvider.isNTLM(proxyAuth) || proxyAuth.contains("Negotiate"))) {
                                newRealm = NettyAsyncHttpProvider.this.ntlmProxyChallenge(proxyAuth, request, proxyServer, headers2, realm, future2);
                            } else if (proxyAuth.contains("Negotiate")) {
                                newRealm = NettyAsyncHttpProvider.this.kerberosChallenge(proxyAuth, request, proxyServer, headers2, realm, future2, true);
                                if (newRealm == null) {
                                    return;
                                }
                            } else {
                                newRealm = future2.getRequest().getRealm();
                            }
                            Request req = ((RequestBuilder)builder.setHeaders(headers2).setRealm(newRealm)).build();
                            future2.setReuseChannel(true);
                            future2.setConnectAllowed(true);
                            NettyAsyncHttpProvider.this.nextRequest(req, future2);
                            return;
                        }
                        if (future2.getNettyRequest().getMethod().equals(HttpMethod.CONNECT) && statusCode == 200) {
                            log.debug("Connected to {}:{}", (Object)proxyServer.getHost(), (Object)proxyServer.getPort());
                            if (future2.getKeepAlive()) {
                                future2.attachChannel(ctx.getChannel(), true);
                            }
                            try {
                                String scheme2 = request.getURI().getScheme();
                                log.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)scheme2);
                                NettyAsyncHttpProvider.this.upgradeProtocol(ctx.getChannel().getPipeline(), scheme2);
                            }
                            catch (Throwable ex) {
                                NettyAsyncHttpProvider.this.abort(future2, ex);
                            }
                            Request req = builder.build();
                            future2.setReuseChannel(true);
                            future2.setConnectAllowed(false);
                            NettyAsyncHttpProvider.this.nextRequest(req, future2);
                            return;
                        }
                        if (NettyAsyncHttpProvider.this.redirect(request, future2, response, ctx)) {
                            return;
                        }
                        if (!future2.getAndSetStatusReceived(true) && NettyAsyncHttpProvider.this.updateStatusAndInterrupt(handler, status)) {
                            NettyAsyncHttpProvider.this.finishUpdate(future2, ctx, response.isChunked());
                            return;
                        }
                        if (!response.getHeaders().isEmpty() && NettyAsyncHttpProvider.this.updateHeadersAndInterrupt(handler, responseHeaders)) {
                            NettyAsyncHttpProvider.this.finishUpdate(future2, ctx, response.isChunked());
                            return;
                        }
                        if (!response.isChunked()) {
                            NettyAsyncHttpProvider.this.updateBodyAndInterrupt(future2, handler, new ResponseBodyPart(future2.getURI(), response, NettyAsyncHttpProvider.this, true));
                            NettyAsyncHttpProvider.this.finishUpdate(future2, ctx, false);
                            return;
                        }
                        if (nettyRequest.getMethod().equals(HttpMethod.HEAD)) {
                            NettyAsyncHttpProvider.this.updateBodyAndInterrupt(future2, handler, new ResponseBodyPart(future2.getURI(), response, NettyAsyncHttpProvider.this, true));
                            NettyAsyncHttpProvider.this.markAsDone(future2, ctx);
                            NettyAsyncHttpProvider.this.drainChannel(ctx, future2);
                        }
                        break block40;
                    }
                    if (e.getMessage() instanceof HttpChunk) {
                        HttpChunk chunk = (HttpChunk)e.getMessage();
                        if (handler != null && (chunk.isLast() || NettyAsyncHttpProvider.this.updateBodyAndInterrupt(future2, handler, new ResponseBodyPart(future2.getURI(), null, NettyAsyncHttpProvider.this, chunk, chunk.isLast())))) {
                            if (chunk instanceof DefaultHttpChunkTrailer) {
                                NettyAsyncHttpProvider.this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future2.getURI(), future2.getHttpResponse(), NettyAsyncHttpProvider.this, (HttpChunkTrailer)chunk));
                            }
                            NettyAsyncHttpProvider.this.finishUpdate(future2, ctx, !chunk.isLast());
                        }
                    }
                }
                catch (Exception t) {
                    if (t instanceof IOException && !NettyAsyncHttpProvider.this.config.getIOExceptionFilters().isEmpty()) {
                        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future2.getAsyncHandler()).request(future2.getRequest()).ioException((IOException)IOException.class.cast(t)).build();
                        if ((fc = NettyAsyncHttpProvider.this.handleIoException(fc, future2)).replayRequest()) {
                            NettyAsyncHttpProvider.this.replayRequest(future2, fc, response, ctx);
                            return;
                        }
                    }
                    try {
                        NettyAsyncHttpProvider.this.abort(future2, t);
                    }
                    finally {
                        NettyAsyncHttpProvider.this.finishUpdate(future2, ctx, false);
                        throw t;
                    }
                }
            }
        }

        public void onError(ChannelHandlerContext ctx, ExceptionEvent e) {
        }

        public void onClose(ChannelHandlerContext ctx, ChannelStateEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonConnectionsPool
    implements ConnectionsPool<String, Channel> {
        private NonConnectionsPool() {
        }

        @Override
        public boolean offer(String uri, Channel connection) {
            return false;
        }

        @Override
        public Channel poll(String uri) {
            return null;
        }

        @Override
        public boolean removeAll(Channel connection) {
            return false;
        }

        @Override
        public boolean canCacheConnection() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    private static class NettyTransferAdapter
    extends TransferCompletionHandler.TransferAdapter {
        private final ChannelBuffer content;
        private final FileInputStream file;
        private int byteRead = 0;

        public NettyTransferAdapter(FluentCaseInsensitiveStringsMap headers2, ChannelBuffer content, File file2) throws IOException {
            super(headers2);
            this.content = content;
            this.file = file2 != null ? new FileInputStream(file2) : null;
        }

        public void getBytes(byte[] bytes2) {
            if (this.content.writableBytes() != 0) {
                this.content.getBytes(this.byteRead, bytes2);
                this.byteRead += bytes2.length;
            } else if (this.file != null) {
                try {
                    this.byteRead += this.file.read(bytes2);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    public static class OptimizedFileRegion
    implements FileRegion {
        private final FileChannel file;
        private final RandomAccessFile raf;
        private final long position;
        private final long count;
        private long byteWritten;

        public OptimizedFileRegion(RandomAccessFile raf, long position, long count2) {
            this.raf = raf;
            this.file = raf.getChannel();
            this.position = position;
            this.count = count2;
        }

        public long getPosition() {
            return this.position;
        }

        public long getCount() {
            return this.count;
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            long count2 = this.count - position;
            if (count2 < 0L || position < 0L) {
                throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
            }
            if (count2 == 0L) {
                return 0L;
            }
            long bw = this.file.transferTo(this.position + position, count2, target);
            this.byteWritten += bw;
            if (this.byteWritten == this.raf.length()) {
                this.releaseExternalResources();
            }
            return bw;
        }

        public void releaseExternalResources() {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", e);
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        private final boolean defaultValue;

        public ThreadLocalBoolean() {
            this(false);
        }

        public ThreadLocalBoolean(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected Boolean initialValue() {
            return this.defaultValue ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AsyncCallable
    implements Callable<Object> {
        private final NettyResponseFuture<?> future;

        public AsyncCallable(NettyResponseFuture<?> future2) {
            this.future = future2;
        }

        @Override
        public abstract Object call() throws Exception;

        public NettyResponseFuture<?> future() {
            return this.future;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProgressListener
    implements ChannelFutureProgressListener {
        private final boolean notifyHeaders;
        private final AsyncHandler asyncHandler;
        private final NettyResponseFuture<?> future;

        public ProgressListener(boolean notifyHeaders, AsyncHandler asyncHandler, NettyResponseFuture<?> future2) {
            this.notifyHeaders = notifyHeaders;
            this.asyncHandler = asyncHandler;
            this.future = future2;
        }

        @Override
        public void operationComplete(ChannelFuture cf) {
            boolean startPublishing;
            Throwable cause = cf.getCause();
            if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
                if (cause instanceof IllegalStateException) {
                    log.debug(cause.getMessage(), cause);
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), ex);
                    }
                    return;
                }
                if (cause instanceof ClosedChannelException || NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                    if (log.isDebugEnabled()) {
                        log.debug(cf.getCause() == null ? "" : cf.getCause().getMessage(), cf.getCause());
                    }
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), ex);
                    }
                    return;
                }
                this.future.abort(cause);
                return;
            }
            this.future.touch();
            Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : NettyAsyncHttpProvider.this.getConfig().getRealm();
            boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
            if (startPublishing && this.asyncHandler instanceof ProgressAsyncHandler) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
            }
        }

        @Override
        public void operationProgressed(ChannelFuture cf, long amount, long current2, long total2) {
            this.future.touch();
            if (this.asyncHandler instanceof ProgressAsyncHandler) {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current2, total2);
            }
        }
    }

    static final class DiscardEvent {
        DiscardEvent() {
        }
    }
}

