/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHttpProviderConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProviderConfig
implements AsyncHttpProviderConfig<String, Object> {
    public static final String USE_BLOCKING_IO = "useBlockingIO";
    public static final String USE_DIRECT_BYTEBUFFER = "bufferFactory";
    public static final String EXECUTE_ASYNC_CONNECT = "asyncConnect";
    public static final String DISABLE_NESTED_REQUEST = "disableNestedRequest";
    public static final String BOSS_EXECUTOR_SERVICE = "bossExecutorService";
    public static final String REUSE_ADDRESS = "reuseAddress";
    public static final String HTTP_CLIENT_CODEC_MAX_INITIAL_LINE_LENGTH = "httpClientCodecMaxInitialLineLength";
    public static final String HTTP_CLIENT_CODEC_MAX_HEADER_SIZE = "httpClientCodecMaxHeaderSize";
    public static final String HTTP_CLIENT_CODEC_MAX_CHUNK_SIZE = "httpClientCodecMaxChunkSize";
    public static final String HTTPS_CLIENT_CODEC_MAX_INITIAL_LINE_LENGTH = "httpsClientCodecMaxInitialLineLength";
    public static final String HTTPS_CLIENT_CODEC_MAX_HEADER_SIZE = "httpsClientCodecMaxHeaderSize";
    public static final String HTTPS_CLIENT_CODEC_MAX_CHUNK_SIZE = "httpsClientCodecMaxChunkSize";
    public static final String SOCKET_CHANNEL_FACTORY = "socketChannelFactory";
    private final ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();
    private boolean disableZeroCopy;
    private Timer nettyTimer;
    private long handshakeTimeoutInMillis = 10000L;

    public NettyAsyncHttpProviderConfig() {
        this.properties.put(REUSE_ADDRESS, "false");
    }

    public NettyAsyncHttpProviderConfig addProperty(String name2, Object value2) {
        this.properties.put(name2, value2);
        return this;
    }

    @Override
    public Object getProperty(String name2) {
        return this.properties.get(name2);
    }

    public <T> T getProperty(String name2, Class<T> type, T defaultValue) {
        Object value2 = this.properties.get(name2);
        if (value2 != null && type.isAssignableFrom(value2.getClass())) {
            return type.cast(value2);
        }
        return defaultValue;
    }

    @Override
    public Object removeProperty(String name2) {
        return this.properties.remove(name2);
    }

    @Override
    public Set<Map.Entry<String, Object>> propertiesSet() {
        return this.properties.entrySet();
    }

    public void setDisableZeroCopy(boolean disableZeroCopy) {
        this.disableZeroCopy = disableZeroCopy;
    }

    public boolean isDisableZeroCopy() {
        return this.disableZeroCopy;
    }

    public Timer getNettyTimer() {
        return this.nettyTimer;
    }

    public void setNettyTimer(Timer nettyTimer) {
        this.nettyTimer = nettyTimer;
    }

    public long getHandshakeTimeoutInMillis() {
        return this.handshakeTimeoutInMillis;
    }

    public void setHandshakeTimeoutInMillis(long handshakeTimeoutInMillis) {
        this.handshakeTimeoutInMillis = handshakeTimeoutInMillis;
    }
}

