/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.providers.netty.ChannelBufferUtil;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyResponse
implements Response {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private final List<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private List<Cookie> cookies;

    public NettyResponse(HttpResponseStatus status, HttpResponseHeaders headers2, List<HttpResponseBodyPart> bodyParts) {
        this.status = status;
        this.headers = headers2;
        this.bodyParts = bodyParts;
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return ChannelBufferUtil.channelBuffer2bytes(this.getResponseBodyAsChannelBuffer());
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        return this.getResponseBodyAsChannelBuffer().toByteBuffer();
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(null);
    }

    @Override
    public String getResponseBody(String charset2) throws IOException {
        return this.getResponseBodyAsChannelBuffer().toString(this.computeCharset(charset2));
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return new ChannelBufferInputStream(this.getResponseBodyAsChannelBuffer());
    }

    public ChannelBuffer getResponseBodyAsChannelBuffer() throws IOException {
        ChannelBuffer b = null;
        switch (this.bodyParts.size()) {
            case 0: {
                b = ChannelBuffers.EMPTY_BUFFER;
                break;
            }
            case 1: {
                b = ((ResponseBodyPart)ResponseBodyPart.class.cast(this.bodyParts.get(0))).getChannelBuffer();
                break;
            }
            default: {
                ChannelBuffer[] channelBuffers = new ChannelBuffer[this.bodyParts.size()];
                for (int i = 0; i < this.bodyParts.size(); ++i) {
                    channelBuffers[i] = ((ResponseBodyPart)ResponseBodyPart.class.cast(this.bodyParts.get(i))).getChannelBuffer();
                }
                b = ChannelBuffers.wrappedBuffer(channelBuffers);
            }
        }
        return b;
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength2) throws IOException {
        return this.getResponseBodyExcerpt(maxLength2, null);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength2, String charset2) throws IOException {
        String response = this.getResponseBody(charset2);
        return response.length() <= maxLength2 ? response : response.substring(0, maxLength2);
    }

    private Charset computeCharset(String charset2) {
        String contentType2;
        if (charset2 == null && (contentType2 = this.getContentType()) != null) {
            charset2 = AsyncHttpProviderUtils.parseCharset(contentType2);
        }
        return charset2 != null ? Charset.forName(charset2) : DEFAULT_CHARSET;
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.status.getUrl();
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getHeader(String name2) {
        return this.headers != null ? this.headers.getHeaders().getFirstValue(name2) : null;
    }

    @Override
    public List<String> getHeaders(String name2) {
        return this.headers != null ? this.headers.getHeaders().get(name2) : Collections.emptyList();
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers != null ? this.headers.getHeaders() : new FluentCaseInsensitiveStringsMap();
    }

    @Override
    public boolean isRedirected() {
        switch (this.status.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            ArrayList<Cookie> localCookies = new ArrayList<Cookie>();
            for (Map.Entry<String, List<String>> header2 : this.headers.getHeaders().entrySet()) {
                if (!header2.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                List<String> v = header2.getValue();
                for (String value2 : v) {
                    localCookies.add(CookieDecoder.decode(value2));
                }
            }
            this.cookies = Collections.unmodifiableList(localCookies);
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null;
    }

    @Override
    public boolean hasResponseBody() {
        return MiscUtil.isNonEmpty(this.bodyParts);
    }
}

