/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketCloseCodeReasonListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketPingListener;
import com.ning.http.client.websocket.WebSocketPongListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
implements WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final ConcurrentLinkedQueue<WebSocketListener> listeners = new ConcurrentLinkedQueue();
    private final StringBuilder textBuffer = new StringBuilder();
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private int maxBufferSize = 128000000;

    public NettyWebSocket(Channel channel) {
        this.channel = channel;
    }

    public WebSocket sendMessage(byte[] message) {
        this.channel.write(new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer(message)));
        return this;
    }

    public WebSocket stream(byte[] fragment, boolean last2) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket stream(byte[] fragment, int offset, int len2, boolean last2) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket sendTextMessage(String message) {
        this.channel.write(new TextWebSocketFrame(message));
        return this;
    }

    public WebSocket streamText(String fragment, boolean last2) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket sendPing(byte[] payload) {
        this.channel.write(new PingWebSocketFrame(ChannelBuffers.wrappedBuffer(payload)));
        return this;
    }

    public WebSocket sendPong(byte[] payload) {
        this.channel.write(new PongWebSocketFrame(ChannelBuffers.wrappedBuffer(payload)));
        return this;
    }

    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        return this;
    }

    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        return this;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int bufferSize) {
        this.maxBufferSize = bufferSize;
        if (this.maxBufferSize < 8192) {
            this.maxBufferSize = 8192;
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        if (this.channel.isOpen()) {
            this.onClose();
            this.listeners.clear();
            this.channel.write(new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void close(int statusCode, String reason) {
        this.onClose(statusCode, reason);
        this.listeners.clear();
    }

    protected void onBinaryFragment(byte[] message, boolean last2) {
        if (!last2) {
            try {
                this.byteBuffer.write(message);
            }
            catch (Exception ex) {
                this.byteBuffer.reset();
                this.onError(ex);
                return;
            }
            if (this.byteBuffer.size() > this.maxBufferSize) {
                this.byteBuffer.reset();
                Exception e = new Exception("Exceeded Netty Web Socket maximum buffer size of " + this.getMaxBufferSize());
                this.onError(e);
                this.close();
                return;
            }
        }
        for (WebSocketListener l : this.listeners) {
            if (!(l instanceof WebSocketByteListener)) continue;
            try {
                if (!last2) {
                    ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onFragment(message, last2);
                    continue;
                }
                if (this.byteBuffer.size() > 0) {
                    this.byteBuffer.write(message);
                    ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onFragment(message, last2);
                    ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onMessage(this.byteBuffer.toByteArray());
                    continue;
                }
                ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onMessage(message);
            }
            catch (Exception ex) {
                l.onError(ex);
            }
        }
        if (last2) {
            this.byteBuffer.reset();
        }
    }

    protected void onTextFragment(String message, boolean last2) {
        if (!last2) {
            this.textBuffer.append(message);
            if (this.textBuffer.length() > this.maxBufferSize) {
                this.textBuffer.setLength(0);
                Exception e = new Exception("Exceeded Netty Web Socket maximum buffer size of " + this.getMaxBufferSize());
                this.onError(e);
                this.close();
                return;
            }
        }
        for (WebSocketListener l : this.listeners) {
            if (!(l instanceof WebSocketTextListener)) continue;
            try {
                if (!last2) {
                    ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onFragment(message, last2);
                    continue;
                }
                if (this.textBuffer.length() > 0) {
                    ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onFragment(message, last2);
                    ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onMessage(this.textBuffer.append(message).toString());
                    continue;
                }
                ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onMessage(message);
            }
            catch (Exception ex) {
                l.onError(ex);
            }
        }
        if (last2) {
            this.textBuffer.setLength(0);
        }
    }

    public void onPing(byte[] payload) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPingListener)) continue;
            ((WebSocketPingListener)WebSocketPingListener.class.cast(listener)).onPing(payload);
        }
    }

    public void onPong(byte[] payload) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPongListener)) continue;
            ((WebSocketPongListener)WebSocketPongListener.class.cast(listener)).onPong(payload);
        }
    }

    protected void onError(Throwable t) {
        for (WebSocketListener l : this.listeners) {
            try {
                l.onError(t);
            }
            catch (Throwable t2) {
                logger.error("", t2);
            }
        }
    }

    protected void onClose() {
        this.onClose(1000, "Normal closure; the connection successfully completed whatever purpose for which it was created.");
    }

    protected void onClose(int code2, String reason) {
        for (WebSocketListener l : this.listeners) {
            try {
                if (l instanceof WebSocketCloseCodeReasonListener) {
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(l)).onClose(this, code2, reason);
                }
                l.onClose(this);
            }
            catch (Throwable t) {
                l.onError(t);
            }
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }
}

