/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class ResponseHeaders
extends HttpResponseHeaders {
    private final HttpChunkTrailer trailingHeaders;
    private final HttpResponse response;
    private final FluentCaseInsensitiveStringsMap headers;

    public ResponseHeaders(URI uri, HttpResponse response, AsyncHttpProvider provider) {
        super(uri, provider, false);
        this.trailingHeaders = null;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    public ResponseHeaders(URI uri, HttpResponse response, AsyncHttpProvider provider, HttpChunkTrailer traillingHeaders) {
        super(uri, provider, true);
        this.trailingHeaders = traillingHeaders;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    private FluentCaseInsensitiveStringsMap computerHeaders() {
        FluentCaseInsensitiveStringsMap h2 = new FluentCaseInsensitiveStringsMap();
        for (Map.Entry<String, String> header2 : this.response.getHeaders()) {
            h2.add(header2.getKey(), header2.getValue());
        }
        if (this.trailingHeaders != null) {
            for (Map.Entry<String, String> header2 : this.trailingHeaders.getHeaders()) {
                h2.add(header2.getKey(), header2.getValue());
            }
        }
        return h2;
    }

    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers;
    }
}

