/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class WebSocketUtil {
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public static String getKey() {
        byte[] nonce = WebSocketUtil.createRandomBytes(16);
        return WebSocketUtil.base64Encode(nonce);
    }

    public static String getAcceptKey(String key) throws UnsupportedEncodingException {
        String acceptSeed = key + MAGIC_GUID;
        byte[] sha12 = WebSocketUtil.sha1(acceptSeed.getBytes("US-ASCII"));
        return WebSocketUtil.base64Encode(sha12);
    }

    public static byte[] md5(byte[] bytes2) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytes2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 not supported on this platform");
        }
    }

    public static byte[] sha1(byte[] bytes2) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(bytes2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported on this platform");
        }
    }

    public static String base64Encode(byte[] bytes2) {
        return Base64.encode(bytes2);
    }

    public static byte[] createRandomBytes(int size2) {
        byte[] bytes2 = new byte[size2];
        for (int i = 0; i < size2; ++i) {
            bytes2[i] = (byte)WebSocketUtil.createRandomNumber(0, 255);
        }
        return bytes2;
    }

    public static int createRandomNumber(int min2, int max2) {
        return (int)(Math.random() * (double)max2 + (double)min2);
    }
}

