/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import com.ning.http.multipart.FilePartSource;
import com.ning.http.multipart.MultipartEncodingUtil;
import com.ning.http.multipart.PartBase;
import com.ning.http.multipart.PartSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilePart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TRANSFER_ENCODING = "binary";
    protected static final String FILE_NAME = "; filename=";
    private static final byte[] FILE_NAME_BYTES = MultipartEncodingUtil.getAsciiBytes("; filename=");
    private final PartSource source;
    private long _stalledTime = -1L;

    public FilePart(String name2, PartSource partSource, String contentType2, String charset2, String contentId) {
        super(name2, contentType2 == null ? DEFAULT_CONTENT_TYPE : contentType2, charset2, DEFAULT_TRANSFER_ENCODING, contentId);
        if (partSource == null) {
            throw new NullPointerException("parSource");
        }
        this.source = partSource;
    }

    public FilePart(String name2, PartSource partSource, String contentType2, String charset2) {
        this(name2, partSource, contentType2, charset2, null);
    }

    public FilePart(String name2, PartSource partSource) {
        this(name2, partSource, null, null);
    }

    public FilePart(String name2, File file2) throws FileNotFoundException {
        this(name2, new FilePartSource(file2), null, null);
    }

    public FilePart(String name2, File file2, String contentType2, String charset2) throws FileNotFoundException {
        this(name2, new FilePartSource(file2), contentType2, charset2);
    }

    public FilePart(String name2, String fileName, File file2) throws FileNotFoundException {
        this(name2, new FilePartSource(fileName, file2), null, null);
    }

    public FilePart(String name2, String fileName, File file2, String contentType2, String charset2) throws FileNotFoundException {
        this(name2, new FilePartSource(fileName, file2), contentType2, charset2);
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        String filename = this.source.getFileName();
        super.sendDispositionHeader(out);
        if (filename != null) {
            out.write(FILE_NAME_BYTES);
            out.write(QUOTE_BYTES);
            out.write(MultipartEncodingUtil.getAsciiBytes(filename));
            out.write(QUOTE_BYTES);
        }
    }

    protected long dispositionHeaderLength() {
        String filename = this.source.getFileName();
        long length = super.dispositionHeaderLength();
        if (filename != null) {
            length += (long)FILE_NAME_BYTES.length;
            length += (long)QUOTE_BYTES.length;
            length += (long)MultipartEncodingUtil.getAsciiBytes(filename).length;
            length += (long)QUOTE_BYTES.length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendData(OutputStream out) throws IOException {
        if (this.lengthOfData() == 0L) {
            return;
        }
        byte[] tmp = new byte[4096];
        InputStream instream = this.source.createInputStream();
        try {
            int len2;
            while ((len2 = instream.read(tmp)) >= 0) {
                out.write(tmp, 0, len2);
            }
        }
        finally {
            instream.close();
        }
    }

    public void setStalledTime(long ms) {
        this._stalledTime = ms;
    }

    public long getStalledTime() {
        return this._stalledTime;
    }

    public PartSource getSource() {
        return this.source;
    }

    protected long lengthOfData() {
        return this.source.getLength();
    }
}

