/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseBodyPartsInputStream;
import com.ning.http.client.Part;
import com.ning.http.client.Request;
import com.ning.http.multipart.ByteArrayPartSource;
import com.ning.http.multipart.FilePart;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.multipart.StringPart;
import com.ning.http.util.MiscUtil;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpProviderUtils {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    static final byte[] EMPTY_BYTE_ARRAY = "".getBytes();

    public static final void validateSupportedScheme(URI uri) {
        String scheme2 = uri.getScheme();
        if (scheme2 == null || !scheme2.equalsIgnoreCase("http") && !scheme2.equalsIgnoreCase("https") && !scheme2.equalsIgnoreCase("ws") && !scheme2.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + uri + ", must be equal (ignoring case) to 'http', 'https', 'ws', or 'wss'");
        }
    }

    public static final URI createNonEmptyPathURI(String u) {
        URI uri = URI.create(u);
        AsyncHttpProviderUtils.validateSupportedScheme(uri);
        String path2 = uri.getPath();
        if (path2 == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ", must be non-null");
        }
        if (MiscUtil.isNonEmpty(path2) && path2.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ". must start with a '/'");
        }
        if (!MiscUtil.isNonEmpty(path2)) {
            return URI.create(u + "/");
        }
        return uri;
    }

    public static final String getBaseUrl(URI uri) {
        return uri.getScheme() + "://" + AsyncHttpProviderUtils.getAuthority(uri);
    }

    public static final String getAuthority(URI uri) {
        String url = uri.getAuthority();
        int port = uri.getPort();
        if (port == -1) {
            port = AsyncHttpProviderUtils.getPort(uri);
            url = url + ":" + port;
        }
        return url;
    }

    public static final String contentToString(List<HttpResponseBodyPart> bodyParts, String charset2) throws UnsupportedEncodingException {
        return new String(AsyncHttpProviderUtils.contentToByte(bodyParts), charset2);
    }

    public static final byte[] contentToByte(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        if (bodyParts.size() == 1) {
            return bodyParts.get(0).getBodyPartBytes();
        }
        int size2 = 0;
        for (HttpResponseBodyPart body2 : bodyParts) {
            size2 += body2.getBodyPartBytes().length;
        }
        byte[] bytes2 = new byte[size2];
        int offset = 0;
        for (HttpResponseBodyPart body3 : bodyParts) {
            byte[] bodyBytes = body3.getBodyPartBytes();
            System.arraycopy(bodyBytes, 0, bytes2, offset, bodyBytes.length);
            offset += bodyBytes.length;
        }
        return bytes2;
    }

    public static final InputStream contentToInputStream(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        return bodyParts.isEmpty() ? new ByteArrayInputStream(EMPTY_BYTE_ARRAY) : new HttpResponseBodyPartsInputStream(bodyParts);
    }

    public static final String getHost(URI uri) {
        String host2 = uri.getHost();
        if (host2 == null) {
            host2 = uri.getAuthority();
        }
        return host2;
    }

    public static final URI getRedirectUri(URI uri, String location) {
        if (location == null) {
            throw new IllegalArgumentException("URI " + uri + " was redirected to null location");
        }
        URI locationURI = null;
        try {
            locationURI = new URI(location);
        }
        catch (URISyntaxException e) {
            String[] parts = location.split("\\?");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Don't know how to turn this location into a proper URI:" + location, e);
            }
            StringBuilder properUrl = new StringBuilder(location.length()).append(parts[0]).append("?");
            String[] queryParams = parts[1].split("&");
            for (int i = 0; i < queryParams.length; ++i) {
                String queryParam = queryParams[i];
                if (i != 0) {
                    properUrl.append("&");
                }
                String[] nameValue = queryParam.split("=", 2);
                UTF8UrlEncoder.appendEncoded(properUrl, nameValue[0]);
                if (nameValue.length != 2) continue;
                properUrl.append("=");
                UTF8UrlEncoder.appendEncoded(properUrl, nameValue[1]);
            }
            locationURI = URI.create(properUrl.toString());
        }
        URI redirectUri = uri.resolve(locationURI);
        String scheme2 = redirectUri.getScheme();
        if (scheme2 == null || !scheme2.equalsIgnoreCase("http") && !scheme2.equalsIgnoreCase("https") && !scheme2.equals("ws") && !scheme2.equals("wss")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + redirectUri + ", must be equal (ignoring case) to 'ws, 'wss', 'http', or 'https'");
        }
        return redirectUri.normalize();
    }

    public static final int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") || uri.getScheme().equals("ws") ? 80 : 443;
        }
        return port;
    }

    public static final MultipartRequestEntity createMultipartRequestEntity(List<Part> params2, FluentCaseInsensitiveStringsMap requestHeaders) throws FileNotFoundException {
        com.ning.http.multipart.Part[] parts = new com.ning.http.multipart.Part[params2.size()];
        int i = 0;
        for (Part part : params2) {
            if (part instanceof com.ning.http.multipart.Part) {
                parts[i] = (com.ning.http.multipart.Part)part;
            } else if (part instanceof com.ning.http.client.StringPart) {
                com.ning.http.client.StringPart stringPart = (com.ning.http.client.StringPart)part;
                parts[i] = new StringPart(part.getName(), stringPart.getValue(), stringPart.getCharset());
            } else if (part instanceof com.ning.http.client.FilePart) {
                com.ning.http.client.FilePart filePart = (com.ning.http.client.FilePart)part;
                parts[i] = new FilePart(part.getName(), filePart.getFile(), filePart.getMimeType(), filePart.getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPart byteArrayPart = (ByteArrayPart)part;
                ByteArrayPartSource source = new ByteArrayPartSource(byteArrayPart.getFileName(), byteArrayPart.getData());
                parts[i] = new FilePart(part.getName(), source, byteArrayPart.getMimeType(), byteArrayPart.getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, requestHeaders);
    }

    public static final byte[] readFully(InputStream in, int[] lengthWrapper) throws IOException {
        int left;
        int count2;
        byte[] b = new byte[Math.max(512, in.available())];
        int offset = 0;
        while ((count2 = in.read(b, offset, left = b.length - offset)) >= 0) {
            offset += count2;
            if (count2 != left) continue;
            b = AsyncHttpProviderUtils.doubleUp(b);
        }
        lengthWrapper[0] = offset;
        return b;
    }

    private static byte[] doubleUp(byte[] b) {
        int len2 = b.length;
        byte[] b2 = new byte[len2 + len2];
        System.arraycopy(b, 0, b2, 0, len2);
        return b2;
    }

    public static String constructUserAgent(Class<? extends AsyncHttpProvider> httpProvider) {
        StringBuilder b = new StringBuilder("AsyncHttpClient/1.0").append(" ").append("(").append(httpProvider.getSimpleName()).append(" - ").append(System.getProperty("os.name")).append(" - ").append(System.getProperty("os.version")).append(" - ").append(System.getProperty("java.version")).append(" - ").append(Runtime.getRuntime().availableProcessors()).append(" core(s))");
        return b.toString();
    }

    public static String parseCharset(String contentType2) {
        for (String part : contentType2.split(";")) {
            String[] val;
            if (!part.trim().startsWith("charset=") || (val = part.split("=")).length <= 1) continue;
            String charset2 = val[1].trim();
            return charset2.replaceAll("\"", "").replaceAll("'", "");
        }
        return null;
    }

    public static String keepAliveHeaderValue(AsyncHttpClientConfig config2) {
        return config2.getAllowPoolingConnection() ? "keep-alive" : "close";
    }

    public static int requestTimeout(AsyncHttpClientConfig config2, Request request) {
        return request.getPerRequestConfig() != null && request.getPerRequestConfig().getRequestTimeoutInMs() != 0 ? request.getPerRequestConfig().getRequestTimeoutInMs() : config2.getRequestTimeoutInMs();
    }
}

