/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.util.Base64;
import com.ning.http.util.MiscUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public final class AuthenticatorUtils {
    public static String computeBasicAuthentication(Realm realm) throws UnsupportedEncodingException {
        String s2 = realm.getPrincipal() + ":" + realm.getPassword();
        return "Basic " + Base64.encode(s2.getBytes(realm.getEncoding()));
    }

    public static String computeBasicAuthentication(ProxyServer proxyServer) throws UnsupportedEncodingException {
        String s2 = proxyServer.getPrincipal() + ":" + proxyServer.getPassword();
        return "Basic " + Base64.encode(s2.getBytes(proxyServer.getEncoding()));
    }

    public static String computeDigestAuthentication(Realm realm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.construct(builder, "username", realm.getPrincipal());
        AuthenticatorUtils.construct(builder, "realm", realm.getRealmName());
        AuthenticatorUtils.construct(builder, "nonce", realm.getNonce());
        AuthenticatorUtils.construct(builder, "uri", realm.getUri());
        builder.append("algorithm").append('=').append(realm.getAlgorithm()).append(", ");
        AuthenticatorUtils.construct(builder, "response", realm.getResponse());
        if (MiscUtil.isNonEmpty(realm.getOpaque())) {
            AuthenticatorUtils.construct(builder, "opaque", realm.getOpaque());
        }
        builder.append("qop").append('=').append(realm.getQop()).append(", ");
        builder.append("nc").append('=').append(realm.getNc()).append(", ");
        AuthenticatorUtils.construct(builder, "cnonce", realm.getCnonce(), true);
        return new String(builder.toString().getBytes("ISO_8859_1"));
    }

    private static StringBuilder construct(StringBuilder builder, String name2, String value2) {
        return AuthenticatorUtils.construct(builder, name2, value2, false);
    }

    private static StringBuilder construct(StringBuilder builder, String name2, String value2, boolean tail) {
        return builder.append(name2).append('=').append('\"').append(value2).append(tail ? "\"" : "\", ");
    }
}

