/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslUtils {
    private static SSLContext context = null;

    public static SSLEngine getSSLEngine() throws GeneralSecurityException, IOException {
        SSLEngine engine = null;
        SSLContext context = SslUtils.getSSLContext();
        if (context != null) {
            engine = context.createSSLEngine();
            engine.setUseClientMode(true);
        }
        return engine;
    }

    public static SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        if (context == null) {
            SSLConfig config2 = new SSLConfig();
            context = config2.keyStoreLocation == null || config2.trustStoreLocation == null ? SslUtils.getLooseSSLContext() : SslUtils.getStrictSSLContext(config2);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLContext getStrictSSLContext(SSLConfig config2) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(config2.keyStoreType);
        FileInputStream keystoreInputStream = new FileInputStream(config2.keyStoreLocation);
        try {
            keyStore.load(keystoreInputStream, config2.keyStorePassword == null ? null : config2.keyStorePassword.toCharArray());
        }
        finally {
            ((InputStream)keystoreInputStream).close();
        }
        KeyManagerFactory keyManagerFactory2 = KeyManagerFactory.getInstance(config2.keyManagerAlgorithm);
        keyManagerFactory2.init(keyStore, config2.keyManagerPassword == null ? null : config2.keyManagerPassword.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory2.getKeyManagers();
        KeyStore trustStore = KeyStore.getInstance(config2.trustStoreType);
        FileInputStream truststoreInputStream = new FileInputStream(config2.trustStoreLocation);
        try {
            trustStore.load(truststoreInputStream, config2.trustStorePassword == null ? null : config2.trustStorePassword.toCharArray());
        }
        finally {
            ((InputStream)truststoreInputStream).close();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(config2.trustManagerAlgorithm);
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    static SSLContext getLooseSSLContext() throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{LooseTrustManager.INSTANCE}, new SecureRandom());
        return sslContext;
    }

    private static final class SSLConfig {
        public String keyStoreLocation = System.getProperty("javax.net.ssl.keyStore");
        public String keyStoreType = "JKS";
        public String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "changeit");
        public String keyManagerAlgorithm = "SunX509";
        public String keyManagerPassword = "changeit";
        public String trustStoreLocation;
        public String trustStoreType = "JKS";
        public String trustStorePassword = "changeit";
        public String trustManagerAlgorithm = "SunX509";

        public SSLConfig() {
            this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
            this.keyManagerAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (this.keyManagerAlgorithm == null) {
                this.keyManagerAlgorithm = "SunX509";
            }
            this.keyManagerPassword = System.getProperty("javax.net.ssl.keyStorePassword", "changeit");
            this.trustStoreLocation = System.getProperty("javax.net.ssl.trustStore");
            if (this.trustStoreLocation == null) {
                this.trustStoreLocation = this.keyStoreLocation;
                this.trustStorePassword = this.keyStorePassword;
                this.trustStoreType = this.keyStoreType;
            } else {
                this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "changeit");
                this.trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
            }
            this.trustManagerAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm");
            if (this.trustManagerAlgorithm == null) {
                this.trustManagerAlgorithm = "SunX509";
            }
        }
    }

    static class LooseTrustManager
    implements X509TrustManager {
        public static final LooseTrustManager INSTANCE = new LooseTrustManager();

        LooseTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

