/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

public class UTF8UrlEncoder {
    private static final boolean encodeSpaceUsingPlus;
    private static final int[] SAFE_ASCII;
    private static final char[] HEX;

    private UTF8UrlEncoder() {
    }

    public static String encode(String input2) {
        StringBuilder sb = new StringBuilder(input2.length() + 16);
        UTF8UrlEncoder.appendEncoded(sb, input2);
        return sb.toString();
    }

    public static StringBuilder appendEncoded(StringBuilder sb, String input2) {
        int c;
        int[] safe = SAFE_ASCII;
        int len2 = input2.length();
        for (int i = 0; i < len2; i += Character.charCount(c)) {
            c = input2.codePointAt(i);
            if (c <= 127) {
                if (safe[c] != 0) {
                    sb.append((char)c);
                    continue;
                }
                UTF8UrlEncoder.appendSingleByteEncoded(sb, c);
                continue;
            }
            UTF8UrlEncoder.appendMultiByteEncoded(sb, c);
        }
        return sb;
    }

    private static final void appendSingleByteEncoded(StringBuilder sb, int value2) {
        if (encodeSpaceUsingPlus && value2 == 32) {
            sb.append('+');
            return;
        }
        sb.append('%');
        sb.append(HEX[value2 >> 4]);
        sb.append(HEX[value2 & 0xF]);
    }

    private static final void appendMultiByteEncoded(StringBuilder sb, int value2) {
        if (value2 < 2048) {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xC0 | value2 >> 6);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value2 & 0x3F);
        } else if (value2 < 65536) {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xE0 | value2 >> 12);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value2 >> 6 & 0x3F);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value2 & 0x3F);
        } else {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xF0 | value2 >> 18);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value2 >> 12 & 0x3F);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value2 >> 6 & 0x3F);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value2 & 0x3F);
        }
    }

    static {
        int i;
        encodeSpaceUsingPlus = System.getProperty("com.com.ning.http.util.UTF8UrlEncoder.encodeSpaceUsingPlus") != null;
        SAFE_ASCII = new int[128];
        for (i = 97; i <= 122; ++i) {
            UTF8UrlEncoder.SAFE_ASCII[i] = 1;
        }
        for (i = 65; i <= 90; ++i) {
            UTF8UrlEncoder.SAFE_ASCII[i] = 1;
        }
        for (i = 48; i <= 57; ++i) {
            UTF8UrlEncoder.SAFE_ASCII[i] = 1;
        }
        UTF8UrlEncoder.SAFE_ASCII[45] = 1;
        UTF8UrlEncoder.SAFE_ASCII[46] = 1;
        UTF8UrlEncoder.SAFE_ASCII[95] = 1;
        UTF8UrlEncoder.SAFE_ASCII[126] = 1;
        HEX = "0123456789ABCDEF".toCharArray();
    }
}

