/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveReplacer;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Unmergeable;
import java.util.Collection;
import java.util.Collections;

final class ConfigReference
extends AbstractConfigValue
implements Unmergeable {
    private final SubstitutionExpression expr;
    private final int prefixLength;

    ConfigReference(ConfigOrigin origin, SubstitutionExpression expr) {
        this(origin, expr, 0);
    }

    private ConfigReference(ConfigOrigin origin, SubstitutionExpression expr, int prefixLength) {
        super(origin);
        this.expr = expr;
        this.prefixLength = prefixLength;
    }

    private ConfigException.NotResolved notResolved() {
        return new ConfigException.NotResolved("need to Config#resolve(), see the API docs for Config#resolve(); substitution not resolved: " + this);
    }

    @Override
    public ConfigValueType valueType() {
        throw this.notResolved();
    }

    @Override
    public Object unwrapped() {
        throw this.notResolved();
    }

    @Override
    protected ConfigReference newCopy(ConfigOrigin newOrigin) {
        return new ConfigReference(newOrigin, this.expr, this.prefixLength);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return false;
    }

    public Collection<ConfigReference> unmergedValues() {
        return Collections.singleton(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AbstractConfigValue resolveSubstitutions(ResolveContext context) {
        context.source().replace(this, ResolveReplacer.cycleResolveReplacer);
        try {
            AbstractConfigValue v;
            try {
                v = context.source().lookupSubst(context, this.expr, this.prefixLength);
            }
            catch (AbstractConfigValue.NotPossibleToResolve e) {
                if (this.expr.optional()) {
                    v = null;
                }
                throw new ConfigException.UnresolvedSubstitution(this.origin(), this.expr + " was part of a cycle of substitutions involving " + e.traceString(), e);
            }
            if (v == null && !this.expr.optional()) {
                if (context.options().getAllowUnresolved()) {
                    ConfigReference configReference = this;
                    return configReference;
                }
                throw new ConfigException.UnresolvedSubstitution(this.origin(), this.expr.toString());
            }
            AbstractConfigValue abstractConfigValue = v;
            return abstractConfigValue;
        }
        finally {
            context.source().unreplace(this);
        }
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigReference relativized(Path prefix) {
        SubstitutionExpression newExpr = this.expr.changePath(this.expr.path().prepend(prefix));
        return new ConfigReference(this.origin(), newExpr, this.prefixLength + prefix.length());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConfigReference;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConfigReference) {
            return this.canEqual(other) && this.expr.equals(((ConfigReference)other).expr);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.expr.hashCode();
    }

    @Override
    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options2) {
        sb.append(this.expr.toString());
    }

    SubstitutionExpression expression() {
        return this.expr;
    }
}

