/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.SimpleConfigList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

final class DefaultTransformer {
    DefaultTransformer() {
    }

    static AbstractConfigValue transform(AbstractConfigValue value2, ConfigValueType requested) {
        if (value2.valueType() == ConfigValueType.STRING) {
            String s2 = (String)value2.unwrapped();
            switch (requested) {
                case NUMBER: {
                    try {
                        Long v = Long.parseLong(s2);
                        return new ConfigLong(value2.origin(), v, s2);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Double v = Double.parseDouble(s2);
                            return new ConfigDouble(value2.origin(), v, s2);
                        }
                        catch (NumberFormatException e2) {
                            break;
                        }
                    }
                }
                case NULL: {
                    if (!s2.equals("null")) break;
                    return new ConfigNull(value2.origin());
                }
                case BOOLEAN: {
                    if (s2.equals("true") || s2.equals("yes") || s2.equals("on")) {
                        return new ConfigBoolean(value2.origin(), true);
                    }
                    if (!s2.equals("false") && !s2.equals("no") && !s2.equals("off")) break;
                    return new ConfigBoolean(value2.origin(), false);
                }
                case LIST: {
                    break;
                }
                case OBJECT: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.STRING) {
            switch (value2.valueType()) {
                case NUMBER: 
                case BOOLEAN: {
                    return new ConfigString(value2.origin(), value2.transformToString());
                }
                case NULL: {
                    break;
                }
                case OBJECT: {
                    break;
                }
                case LIST: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.LIST && value2.valueType() == ConfigValueType.OBJECT) {
            AbstractConfigObject o = (AbstractConfigObject)value2;
            HashMap<Integer, AbstractConfigValue> values2 = new HashMap<Integer, AbstractConfigValue>();
            for (String key : o.keySet()) {
                try {
                    int i = Integer.parseInt(key, 10);
                    if (i < 0) continue;
                    values2.put(i, o.get(key));
                }
                catch (NumberFormatException e) {}
            }
            if (!values2.isEmpty()) {
                ArrayList entryList = new ArrayList(values2.entrySet());
                Collections.sort(entryList, new Comparator<Map.Entry<Integer, AbstractConfigValue>>(){

                    @Override
                    public int compare(Map.Entry<Integer, AbstractConfigValue> a, Map.Entry<Integer, AbstractConfigValue> b) {
                        return Integer.valueOf(a.getKey()).compareTo(b.getKey());
                    }
                });
                ArrayList<AbstractConfigValue> list2 = new ArrayList<AbstractConfigValue>();
                for (Map.Entry entry : entryList) {
                    list2.add((AbstractConfigValue)entry.getValue());
                }
                return new SimpleConfigList(value2.origin(), list2);
            }
        }
        return value2;
    }
}

