/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigConcatenation;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigReference;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FullIncluder;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathBuilder;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SimpleIncluder;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokenizer;
import com.typesafe.config.impl.Tokens;
import java.io.File;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

final class Parser {
    static ConfigOrigin apiOrigin = SimpleConfigOrigin.newSimple("path parameter");

    Parser() {
    }

    static AbstractConfigValue parse(Iterator<Token> tokens, ConfigOrigin origin, ConfigParseOptions options2, ConfigIncludeContext includeContext) {
        ParseContext context = new ParseContext(options2.getSyntax(), origin, tokens, SimpleIncluder.makeFull(options2.getIncluder()), includeContext);
        return context.parse();
    }

    private static void addPathText(List<Element> buf, boolean wasQuoted, String newText) {
        int i = wasQuoted ? -1 : newText.indexOf(46);
        Element current2 = buf.get(buf.size() - 1);
        if (i < 0) {
            current2.sb.append(newText);
            if (wasQuoted && current2.sb.length() == 0) {
                current2.canBeEmpty = true;
            }
        } else {
            current2.sb.append(newText.substring(0, i));
            buf.add(new Element("", false));
            Parser.addPathText(buf, false, newText.substring(i + 1));
        }
    }

    private static Path parsePathExpression(Iterator<Token> expression2, ConfigOrigin origin) {
        return Parser.parsePathExpression(expression2, origin, null);
    }

    private static Path parsePathExpression(Iterator<Token> expression2, ConfigOrigin origin, String originalText) {
        ArrayList<Element> buf = new ArrayList<Element>();
        buf.add(new Element("", false));
        if (!expression2.hasNext()) {
            throw new ConfigException.BadPath(origin, originalText, "Expecting a field name or path here, but got nothing");
        }
        while (expression2.hasNext()) {
            String text2;
            Token t = expression2.next();
            if (Tokens.isValueWithType(t, ConfigValueType.STRING)) {
                AbstractConfigValue v = Tokens.getValue(t);
                String s2 = v.transformToString();
                Parser.addPathText(buf, true, s2);
                continue;
            }
            if (t == Tokens.END) continue;
            if (Tokens.isValue(t)) {
                AbstractConfigValue v = Tokens.getValue(t);
                text2 = v.transformToString();
            } else if (Tokens.isUnquotedText(t)) {
                text2 = Tokens.getUnquotedText(t);
            } else {
                throw new ConfigException.BadPath(origin, originalText, "Token not allowed in path expression: " + t + " (you can double-quote this token if you really want it here)");
            }
            Parser.addPathText(buf, false, text2);
        }
        PathBuilder pb = new PathBuilder();
        for (Element e : buf) {
            if (e.sb.length() == 0 && !e.canBeEmpty) {
                throw new ConfigException.BadPath(origin, originalText, "path has a leading, trailing, or two adjacent period '.' (use quoted \"\" empty string if you want an empty element)");
            }
            pb.appendKey(e.sb.toString());
        }
        return pb.result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path parsePath(String path2) {
        Path speculated = Parser.speculativeFastParsePath(path2);
        if (speculated != null) {
            return speculated;
        }
        StringReader reader = new StringReader(path2);
        try {
            Iterator<Token> tokens = Tokenizer.tokenize(apiOrigin, reader, ConfigSyntax.CONF);
            tokens.next();
            Path path3 = Parser.parsePathExpression(tokens, apiOrigin, path2);
            return path3;
        }
        finally {
            reader.close();
        }
    }

    private static boolean hasUnsafeChars(String s2) {
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (Character.isLetter(c) || c == '.') continue;
            return true;
        }
        return false;
    }

    private static void appendPathString(PathBuilder pb, String s2) {
        int splitAt2 = s2.indexOf(46);
        if (splitAt2 < 0) {
            pb.appendKey(s2);
        } else {
            pb.appendKey(s2.substring(0, splitAt2));
            Parser.appendPathString(pb, s2.substring(splitAt2 + 1));
        }
    }

    private static Path speculativeFastParsePath(String path2) {
        String s2 = ConfigImplUtil.unicodeTrim(path2);
        if (s2.isEmpty()) {
            return null;
        }
        if (Parser.hasUnsafeChars(s2)) {
            return null;
        }
        if (s2.startsWith(".") || s2.endsWith(".") || s2.contains("..")) {
            return null;
        }
        PathBuilder pb = new PathBuilder();
        Parser.appendPathString(pb, s2);
        return pb.result();
    }

    static class Element {
        StringBuilder sb;
        boolean canBeEmpty;

        Element(String initial, boolean canBeEmpty) {
            this.canBeEmpty = canBeEmpty;
            this.sb = new StringBuilder(initial);
        }

        public String toString() {
            return "Element(" + this.sb.toString() + "," + this.canBeEmpty + ")";
        }
    }

    private static final class ParseContext {
        private int lineNumber = 1;
        private final Stack<TokenWithComments> buffer = new Stack();
        private final Iterator<Token> tokens;
        private final FullIncluder includer;
        private final ConfigIncludeContext includeContext;
        private final ConfigSyntax flavor;
        private final ConfigOrigin baseOrigin;
        private final LinkedList<Path> pathStack;
        int equalsCount;
        int arrayCount;

        ParseContext(ConfigSyntax flavor, ConfigOrigin origin, Iterator<Token> tokens, FullIncluder includer, ConfigIncludeContext includeContext) {
            this.tokens = tokens;
            this.flavor = flavor;
            this.baseOrigin = origin;
            this.includer = includer;
            this.includeContext = includeContext;
            this.pathStack = new LinkedList();
            this.equalsCount = 0;
            this.arrayCount = 0;
        }

        private static boolean attractsTrailingComments(Token token2) {
            return !Tokens.isNewline(token2) && token2 != Tokens.START && token2 != Tokens.OPEN_CURLY && token2 != Tokens.OPEN_SQUARE && token2 != Tokens.END;
        }

        private static boolean attractsLeadingComments(Token token2) {
            return !Tokens.isNewline(token2) && token2 != Tokens.START && token2 != Tokens.CLOSE_CURLY && token2 != Tokens.CLOSE_SQUARE && token2 != Tokens.END;
        }

        private void consolidateCommentBlock(Token commentToken) {
            ArrayList<Token> newlines = new ArrayList<Token>();
            ArrayList<Token> comments = new ArrayList<Token>();
            Token previous = null;
            Token next2 = commentToken;
            while (true) {
                if (Tokens.isNewline(next2)) {
                    if (previous != null && Tokens.isNewline(previous)) {
                        comments.clear();
                    }
                    newlines.add(next2);
                } else if (Tokens.isComment(next2)) {
                    comments.add(next2);
                } else {
                    if (ParseContext.attractsLeadingComments(next2)) break;
                    comments.clear();
                    break;
                }
                previous = next2;
                next2 = this.tokens.next();
            }
            this.buffer.push(new TokenWithComments(next2, comments));
            ListIterator li = newlines.listIterator(newlines.size());
            while (li.hasPrevious()) {
                this.buffer.push(new TokenWithComments((Token)li.previous()));
            }
        }

        private TokenWithComments popTokenWithoutTrailingComment() {
            if (this.buffer.isEmpty()) {
                Token t = this.tokens.next();
                if (Tokens.isComment(t)) {
                    this.consolidateCommentBlock(t);
                    return this.buffer.pop();
                }
                return new TokenWithComments(t);
            }
            return this.buffer.pop();
        }

        private TokenWithComments popToken() {
            TokenWithComments withPrecedingComments = this.popTokenWithoutTrailingComment();
            if (!ParseContext.attractsTrailingComments(withPrecedingComments.token)) {
                return withPrecedingComments;
            }
            if (this.buffer.isEmpty()) {
                Token after2 = this.tokens.next();
                if (Tokens.isComment(after2)) {
                    return withPrecedingComments.add(after2);
                }
                this.buffer.push(new TokenWithComments(after2));
                return withPrecedingComments;
            }
            if (Tokens.isComment(this.buffer.peek().token)) {
                throw new ConfigException.BugOrBroken("comment token should not have been in buffer: " + this.buffer);
            }
            return withPrecedingComments;
        }

        private TokenWithComments nextToken() {
            TokenWithComments withComments = null;
            withComments = this.popToken();
            Token t = withComments.token;
            if (Tokens.isProblem(t)) {
                ConfigOrigin origin = t.origin();
                String message = Tokens.getProblemMessage(t);
                Throwable cause = Tokens.getProblemCause(t);
                boolean suggestQuotes = Tokens.getProblemSuggestQuotes(t);
                message = suggestQuotes ? this.addQuoteSuggestion(t.toString(), message) : this.addKeyName(message);
                throw new ConfigException.Parse(origin, message, cause);
            }
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isUnquotedText(t)) {
                    throw this.parseError(this.addKeyName("Token not allowed in valid JSON: '" + Tokens.getUnquotedText(t) + "'"));
                }
                if (Tokens.isSubstitution(t)) {
                    throw this.parseError(this.addKeyName("Substitutions (${} syntax) not allowed in JSON"));
                }
            }
            return withComments;
        }

        private void putBack(TokenWithComments token2) {
            if (Tokens.isComment(token2.token)) {
                throw new ConfigException.BugOrBroken("comment token should have been stripped before it was available to put back");
            }
            this.buffer.push(token2);
        }

        private TokenWithComments nextTokenIgnoringNewline() {
            TokenWithComments t = this.nextToken();
            while (Tokens.isNewline(t.token)) {
                this.lineNumber = t.token.lineNumber() + 1;
                t = this.nextToken();
            }
            int newNumber = t.token.lineNumber();
            if (newNumber >= 0) {
                this.lineNumber = newNumber;
            }
            return t;
        }

        private AbstractConfigValue addAnyCommentsAfterAnyComma(AbstractConfigValue v) {
            TokenWithComments t = this.nextToken();
            if (t.token == Tokens.COMMA) {
                this.putBack(t.removeAll());
                return v.withOrigin(t.appendComments(v.origin()));
            }
            this.putBack(t);
            return v;
        }

        private boolean checkElementSeparator() {
            if (this.flavor == ConfigSyntax.JSON) {
                TokenWithComments t = this.nextTokenIgnoringNewline();
                if (t.token == Tokens.COMMA) {
                    return true;
                }
                this.putBack(t);
                return false;
            }
            boolean sawSeparatorOrNewline = false;
            TokenWithComments t = this.nextToken();
            while (true) {
                if (!Tokens.isNewline(t.token)) {
                    if (t.token == Tokens.COMMA) {
                        return true;
                    }
                    this.putBack(t);
                    return sawSeparatorOrNewline;
                }
                this.lineNumber = t.token.lineNumber() + 1;
                sawSeparatorOrNewline = true;
                t = this.nextToken();
            }
        }

        private static SubstitutionExpression tokenToSubstitutionExpression(Token valueToken) {
            List<Token> expression2 = Tokens.getSubstitutionPathExpression(valueToken);
            Path path2 = Parser.parsePathExpression(expression2.iterator(), valueToken.origin());
            boolean optional2 = Tokens.getSubstitutionOptional(valueToken);
            return new SubstitutionExpression(path2, optional2);
        }

        private void consolidateValueTokens() {
            if (this.flavor == ConfigSyntax.JSON) {
                return;
            }
            ArrayList<AbstractConfigValue> values2 = null;
            TokenWithComments t = this.nextTokenIgnoringNewline();
            while (true) {
                AbstractConfigValue v = null;
                if (!Tokens.isValue(t.token) && !Tokens.isUnquotedText(t.token) && !Tokens.isSubstitution(t.token) && t.token != Tokens.OPEN_CURLY && t.token != Tokens.OPEN_SQUARE) break;
                v = this.parseValue(t);
                if (v == null) {
                    throw new ConfigException.BugOrBroken("no value");
                }
                if (values2 == null) {
                    values2 = new ArrayList<AbstractConfigValue>();
                }
                values2.add(v);
                t = this.nextToken();
            }
            this.putBack(t);
            if (values2 == null) {
                return;
            }
            AbstractConfigValue consolidated = ConfigConcatenation.concatenate(values2);
            this.putBack(new TokenWithComments(Tokens.newValue(consolidated)));
        }

        private SimpleConfigOrigin lineOrigin() {
            return ((SimpleConfigOrigin)this.baseOrigin).setLineNumber(this.lineNumber);
        }

        private ConfigException parseError(String message) {
            return this.parseError(message, null);
        }

        private ConfigException parseError(String message, Throwable cause) {
            return new ConfigException.Parse(this.lineOrigin(), message, cause);
        }

        private String previousFieldName(Path lastPath) {
            if (lastPath != null) {
                return lastPath.render();
            }
            if (this.pathStack.isEmpty()) {
                return null;
            }
            return this.pathStack.peek().render();
        }

        private Path fullCurrentPath() {
            if (this.pathStack.isEmpty()) {
                throw new ConfigException.BugOrBroken("Bug in parser; tried to get current path when at root");
            }
            return new Path(this.pathStack.descendingIterator());
        }

        private String previousFieldName() {
            return this.previousFieldName(null);
        }

        private String addKeyName(String message) {
            String previousFieldName = this.previousFieldName();
            if (previousFieldName != null) {
                return "in value for key '" + previousFieldName + "': " + message;
            }
            return message;
        }

        private String addQuoteSuggestion(String badToken, String message) {
            return this.addQuoteSuggestion(null, this.equalsCount > 0, badToken, message);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String addQuoteSuggestion(Path lastPath, boolean insideEquals, String badToken, String message) {
            String part;
            String previousFieldName = this.previousFieldName(lastPath);
            if (badToken.equals(Tokens.END.toString())) {
                if (previousFieldName == null) return message;
                part = message + " (if you intended '" + previousFieldName + "' to be part of a value, instead of a key, " + "try adding double quotes around the whole value";
            } else {
                part = previousFieldName != null ? message + " (if you intended " + badToken + " to be part of the value for '" + previousFieldName + "', " + "try enclosing the value in double quotes" : message + " (if you intended " + badToken + " to be part of a key or string value, " + "try enclosing the key or value in double quotes";
            }
            if (!insideEquals) return part + ")";
            return part + ", or you may be able to rename the file .properties rather than .conf)";
        }

        private AbstractConfigValue parseValue(TokenWithComments t) {
            AbstractConfigValue v;
            int startingArrayCount = this.arrayCount;
            int startingEqualsCount = this.equalsCount;
            if (Tokens.isValue(t.token)) {
                v = Tokens.getValue(t.token);
            } else if (Tokens.isUnquotedText(t.token)) {
                v = new ConfigString(t.token.origin(), Tokens.getUnquotedText(t.token));
            } else if (Tokens.isSubstitution(t.token)) {
                v = new ConfigReference(t.token.origin(), ParseContext.tokenToSubstitutionExpression(t.token));
            } else if (t.token == Tokens.OPEN_CURLY) {
                v = this.parseObject(true);
            } else if (t.token == Tokens.OPEN_SQUARE) {
                v = this.parseArray();
            } else {
                throw this.parseError(this.addQuoteSuggestion(t.token.toString(), "Expecting a value but got wrong token: " + t.token));
            }
            v = v.withOrigin(t.prependComments(v.origin()));
            if (this.arrayCount != startingArrayCount) {
                throw new ConfigException.BugOrBroken("Bug in config parser: unbalanced array count");
            }
            if (this.equalsCount != startingEqualsCount) {
                throw new ConfigException.BugOrBroken("Bug in config parser: unbalanced equals count");
            }
            return v;
        }

        private static AbstractConfigObject createValueUnderPath(Path path2, AbstractConfigValue value2) {
            ArrayList<String> keys2 = new ArrayList<String>();
            String key = path2.first();
            Path remaining = path2.remainder();
            while (key != null) {
                keys2.add(key);
                if (remaining == null) break;
                key = remaining.first();
                remaining = remaining.remainder();
            }
            ListIterator i = keys2.listIterator(keys2.size());
            String deepest = (String)i.previous();
            SimpleConfigObject o = new SimpleConfigObject(value2.origin().setComments(null), Collections.singletonMap(deepest, value2));
            while (i.hasPrevious()) {
                Map<String, AbstractConfigValue> m = Collections.singletonMap(i.previous(), o);
                o = new SimpleConfigObject(value2.origin().setComments(null), m);
            }
            return o;
        }

        private Path parseKey(TokenWithComments token2) {
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isValueWithType(token2.token, ConfigValueType.STRING)) {
                    String key = (String)Tokens.getValue(token2.token).unwrapped();
                    return Path.newKey(key);
                }
                throw this.parseError(this.addKeyName("Expecting close brace } or a field name here, got " + token2));
            }
            ArrayList<Token> expression2 = new ArrayList<Token>();
            TokenWithComments t = token2;
            while (Tokens.isValue(t.token) || Tokens.isUnquotedText(t.token)) {
                expression2.add(t.token);
                t = this.nextToken();
            }
            if (expression2.isEmpty()) {
                throw this.parseError(this.addKeyName("expecting a close brace or a field name here, got " + t));
            }
            this.putBack(t);
            return Parser.parsePathExpression(expression2.iterator(), this.lineOrigin());
        }

        private static boolean isIncludeKeyword(Token t) {
            return Tokens.isUnquotedText(t) && Tokens.getUnquotedText(t).equals("include");
        }

        private static boolean isUnquotedWhitespace(Token t) {
            if (!Tokens.isUnquotedText(t)) {
                return false;
            }
            String s2 = Tokens.getUnquotedText(t);
            for (int i = 0; i < s2.length(); ++i) {
                char c = s2.charAt(i);
                if (ConfigImplUtil.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseInclude(Map<String, AbstractConfigValue> values2) {
            AbstractConfigObject obj2;
            TokenWithComments t = this.nextTokenIgnoringNewline();
            while (ParseContext.isUnquotedWhitespace(t.token)) {
                t = this.nextTokenIgnoringNewline();
            }
            if (Tokens.isUnquotedText(t.token)) {
                String kind = Tokens.getUnquotedText(t.token);
                if (!(kind.equals("url(") || kind.equals("file(") || kind.equals("classpath("))) {
                    throw this.parseError("expecting include parameter to be quoted filename, file(), classpath(), or url(). No spaces are allowed before the open paren. Not expecting: " + t);
                }
                t = this.nextTokenIgnoringNewline();
                while (ParseContext.isUnquotedWhitespace(t.token)) {
                    t = this.nextTokenIgnoringNewline();
                }
                if (!Tokens.isValueWithType(t.token, ConfigValueType.STRING)) {
                    throw this.parseError("expecting a quoted string inside file(), classpath(), or url(), rather than: " + t);
                }
                String name2 = (String)Tokens.getValue(t.token).unwrapped();
                t = this.nextTokenIgnoringNewline();
                while (ParseContext.isUnquotedWhitespace(t.token)) {
                    t = this.nextTokenIgnoringNewline();
                }
                if (!Tokens.isUnquotedText(t.token) || !Tokens.getUnquotedText(t.token).equals(")")) {
                    throw this.parseError("expecting a close parentheses ')' here, not: " + t);
                }
                if (kind.equals("url(")) {
                    URL url;
                    try {
                        url = new URL(name2);
                    }
                    catch (MalformedURLException e) {
                        throw this.parseError("include url() specifies an invalid URL: " + name2, e);
                    }
                    obj2 = (AbstractConfigObject)this.includer.includeURL(this.includeContext, url);
                } else if (kind.equals("file(")) {
                    obj2 = (AbstractConfigObject)this.includer.includeFile(this.includeContext, new File(name2));
                } else {
                    if (!kind.equals("classpath(")) throw new ConfigException.BugOrBroken("should not be reached");
                    obj2 = (AbstractConfigObject)this.includer.includeResources(this.includeContext, name2);
                }
            } else {
                if (!Tokens.isValueWithType(t.token, ConfigValueType.STRING)) throw this.parseError("include keyword is not followed by a quoted string, but by: " + t);
                String name3 = (String)Tokens.getValue(t.token).unwrapped();
                obj2 = (AbstractConfigObject)this.includer.include(this.includeContext, name3);
            }
            if (this.arrayCount > 0 && obj2.resolveStatus() != ResolveStatus.RESOLVED) {
                throw this.parseError("Due to current limitations of the config parser, when an include statement is nested inside a list value, ${} substitutions inside the included file cannot be resolved correctly. Either move the include outside of the list value or remove the ${} statements from the included file.");
            }
            if (!this.pathStack.isEmpty()) {
                Path prefix = this.fullCurrentPath();
                obj2 = obj2.relativized(prefix);
            }
            for (String key : obj2.keySet()) {
                AbstractConfigValue v = obj2.get(key);
                AbstractConfigValue existing = values2.get(key);
                if (existing != null) {
                    values2.put(key, v.withFallback(existing));
                    continue;
                }
                values2.put(key, v);
            }
        }

        private boolean isKeyValueSeparatorToken(Token t) {
            if (this.flavor == ConfigSyntax.JSON) {
                return t == Tokens.COLON;
            }
            return t == Tokens.COLON || t == Tokens.EQUALS || t == Tokens.PLUS_EQUALS;
        }

        private AbstractConfigObject parseObject(boolean hadOpenCurly) {
            SimpleConfigOrigin objectOrigin;
            HashMap<String, AbstractConfigValue> values2;
            block27: {
                TokenWithComments t;
                values2 = new HashMap<String, AbstractConfigValue>();
                objectOrigin = this.lineOrigin();
                boolean afterComma = false;
                Path lastPath = null;
                boolean lastInsideEquals = false;
                while (true) {
                    t = this.nextTokenIgnoringNewline();
                    if (t.token == Tokens.CLOSE_CURLY) {
                        if (this.flavor == ConfigSyntax.JSON && afterComma) {
                            throw this.parseError(this.addQuoteSuggestion(t.toString(), "expecting a field name after a comma, got a close brace } instead"));
                        }
                        if (!hadOpenCurly) {
                            throw this.parseError(this.addQuoteSuggestion(t.toString(), "unbalanced close brace '}' with no open brace"));
                        }
                        objectOrigin = t.appendComments(objectOrigin);
                        break block27;
                    }
                    if (t.token == Tokens.END && !hadOpenCurly) {
                        this.putBack(t);
                        break block27;
                    }
                    if (this.flavor != ConfigSyntax.JSON && ParseContext.isIncludeKeyword(t.token)) {
                        this.parseInclude(values2);
                        afterComma = false;
                    } else {
                        TokenWithComments valueToken;
                        TokenWithComments keyToken = t;
                        Path path2 = this.parseKey(keyToken);
                        TokenWithComments afterKey = this.nextTokenIgnoringNewline();
                        boolean insideEquals = false;
                        this.pathStack.push(path2);
                        if (afterKey.token == Tokens.PLUS_EQUALS) {
                            if (this.arrayCount > 0) {
                                throw this.parseError("Due to current limitations of the config parser, += does not work nested inside a list. += expands to a ${} substitution and the path in ${} cannot currently refer to list elements. You might be able to move the += outside of the list and then refer to it from inside the list with ${}.");
                            }
                            ++this.arrayCount;
                        }
                        if (this.flavor == ConfigSyntax.CONF && afterKey.token == Tokens.OPEN_CURLY) {
                            valueToken = afterKey;
                        } else {
                            if (!this.isKeyValueSeparatorToken(afterKey.token)) {
                                throw this.parseError(this.addQuoteSuggestion(afterKey.toString(), "Key '" + path2.render() + "' may not be followed by token: " + afterKey));
                            }
                            if (afterKey.token == Tokens.EQUALS) {
                                insideEquals = true;
                                ++this.equalsCount;
                            }
                            this.consolidateValueTokens();
                            valueToken = this.nextTokenIgnoringNewline();
                            valueToken = valueToken.prepend(afterKey.comments);
                        }
                        AbstractConfigValue newValue = this.parseValue(valueToken.prepend(keyToken.comments));
                        if (afterKey.token == Tokens.PLUS_EQUALS) {
                            --this.arrayCount;
                            ArrayList<AbstractConfigValue> concat2 = new ArrayList<AbstractConfigValue>(2);
                            ConfigReference previousRef = new ConfigReference(newValue.origin(), new SubstitutionExpression(this.fullCurrentPath(), true));
                            SimpleConfigList list2 = new SimpleConfigList(newValue.origin(), Collections.singletonList(newValue));
                            concat2.add(previousRef);
                            concat2.add(list2);
                            newValue = ConfigConcatenation.concatenate(concat2);
                        }
                        newValue = this.addAnyCommentsAfterAnyComma(newValue);
                        lastPath = this.pathStack.pop();
                        if (insideEquals) {
                            --this.equalsCount;
                        }
                        lastInsideEquals = insideEquals;
                        String key = path2.first();
                        Path remaining = path2.remainder();
                        if (remaining == null) {
                            AbstractConfigValue existing = (AbstractConfigValue)values2.get(key);
                            if (existing != null) {
                                if (this.flavor == ConfigSyntax.JSON) {
                                    throw this.parseError("JSON does not allow duplicate fields: '" + key + "' was already seen at " + existing.origin().description());
                                }
                                newValue = newValue.withFallback(existing);
                            }
                            values2.put(key, newValue);
                        } else {
                            if (this.flavor == ConfigSyntax.JSON) {
                                throw new ConfigException.BugOrBroken("somehow got multi-element path in JSON mode");
                            }
                            AbstractConfigObject obj2 = ParseContext.createValueUnderPath(remaining, newValue);
                            AbstractConfigValue existing = (AbstractConfigValue)values2.get(key);
                            if (existing != null) {
                                obj2 = obj2.withFallback(existing);
                            }
                            values2.put(key, obj2);
                        }
                        afterComma = false;
                    }
                    if (!this.checkElementSeparator()) break;
                    afterComma = true;
                }
                t = this.nextTokenIgnoringNewline();
                if (t.token == Tokens.CLOSE_CURLY) {
                    if (!hadOpenCurly) {
                        throw this.parseError(this.addQuoteSuggestion(lastPath, lastInsideEquals, t.toString(), "unbalanced close brace '}' with no open brace"));
                    }
                    objectOrigin = t.appendComments(objectOrigin);
                } else {
                    if (hadOpenCurly) {
                        throw this.parseError(this.addQuoteSuggestion(lastPath, lastInsideEquals, t.toString(), "Expecting close brace } or a comma, got " + t));
                    }
                    if (t.token == Tokens.END) {
                        this.putBack(t);
                    } else {
                        throw this.parseError(this.addQuoteSuggestion(lastPath, lastInsideEquals, t.toString(), "Expecting end of input or a comma, got " + t));
                    }
                }
            }
            return new SimpleConfigObject(objectOrigin, values2);
        }

        private SimpleConfigList parseArray() {
            ++this.arrayCount;
            SimpleConfigOrigin arrayOrigin = this.lineOrigin();
            ArrayList<AbstractConfigValue> values2 = new ArrayList<AbstractConfigValue>();
            this.consolidateValueTokens();
            TokenWithComments t = this.nextTokenIgnoringNewline();
            if (t.token == Tokens.CLOSE_SQUARE) {
                --this.arrayCount;
                return new SimpleConfigList(t.appendComments(arrayOrigin), Collections.<AbstractConfigValue>emptyList());
            }
            if (!Tokens.isValue(t.token) && t.token != Tokens.OPEN_CURLY && t.token != Tokens.OPEN_SQUARE) {
                throw this.parseError(this.addKeyName("List should have ] or a first element after the open [, instead had token: " + t + " (if you want " + t + " to be part of a string value, then double-quote it)"));
            }
            AbstractConfigValue v = this.parseValue(t);
            v = this.addAnyCommentsAfterAnyComma(v);
            values2.add(v);
            while (true) {
                if (!this.checkElementSeparator()) {
                    t = this.nextTokenIgnoringNewline();
                    if (t.token == Tokens.CLOSE_SQUARE) {
                        --this.arrayCount;
                        return new SimpleConfigList(t.appendComments(arrayOrigin), values2);
                    }
                    throw this.parseError(this.addKeyName("List should have ended with ] or had a comma, instead had token: " + t + " (if you want " + t + " to be part of a string value, then double-quote it)"));
                }
                this.consolidateValueTokens();
                t = this.nextTokenIgnoringNewline();
                if (Tokens.isValue(t.token) || t.token == Tokens.OPEN_CURLY || t.token == Tokens.OPEN_SQUARE) {
                    v = this.parseValue(t);
                    v = this.addAnyCommentsAfterAnyComma(v);
                    values2.add(v);
                    continue;
                }
                if (this.flavor == ConfigSyntax.JSON || t.token != Tokens.CLOSE_SQUARE) break;
                this.putBack(t);
            }
            throw this.parseError(this.addKeyName("List should have had new element after a comma, instead had token: " + t + " (if you want the comma or " + t + " to be part of a string value, then double-quote it)"));
        }

        AbstractConfigValue parse() {
            TokenWithComments t = this.nextTokenIgnoringNewline();
            if (t.token != Tokens.START) {
                throw new ConfigException.BugOrBroken("token stream did not begin with START, had " + t);
            }
            t = this.nextTokenIgnoringNewline();
            AbstractConfigValue result2 = null;
            if (t.token == Tokens.OPEN_CURLY || t.token == Tokens.OPEN_SQUARE) {
                result2 = this.parseValue(t);
            } else {
                if (this.flavor == ConfigSyntax.JSON) {
                    if (t.token == Tokens.END) {
                        throw this.parseError("Empty document");
                    }
                    throw this.parseError("Document must have an object or array at root, unexpected token: " + t);
                }
                this.putBack(t);
                result2 = this.parseObject(false);
            }
            t = this.nextTokenIgnoringNewline();
            if (t.token == Tokens.END) {
                return result2;
            }
            throw this.parseError("Document has trailing tokens after first object or array: " + t);
        }
    }

    private static final class TokenWithComments {
        final Token token;
        final List<Token> comments;

        TokenWithComments(Token token2, List<Token> comments) {
            this.token = token2;
            this.comments = comments;
            if (Tokens.isComment(token2)) {
                throw new ConfigException.BugOrBroken("tried to annotate a comment with a comment");
            }
        }

        TokenWithComments(Token token2) {
            this(token2, Collections.emptyList());
        }

        TokenWithComments removeAll() {
            if (this.comments.isEmpty()) {
                return this;
            }
            return new TokenWithComments(this.token);
        }

        TokenWithComments prepend(List<Token> earlier) {
            if (earlier.isEmpty()) {
                return this;
            }
            if (this.comments.isEmpty()) {
                return new TokenWithComments(this.token, earlier);
            }
            ArrayList<Token> merged = new ArrayList<Token>();
            merged.addAll(earlier);
            merged.addAll(this.comments);
            return new TokenWithComments(this.token, merged);
        }

        TokenWithComments add(Token after2) {
            if (this.comments.isEmpty()) {
                return new TokenWithComments(this.token, Collections.singletonList(after2));
            }
            ArrayList<Token> merged = new ArrayList<Token>();
            merged.addAll(this.comments);
            merged.add(after2);
            return new TokenWithComments(this.token, merged);
        }

        SimpleConfigOrigin prependComments(SimpleConfigOrigin origin) {
            if (this.comments.isEmpty()) {
                return origin;
            }
            ArrayList<String> newComments = new ArrayList<String>();
            for (Token c : this.comments) {
                newComments.add(Tokens.getCommentText(c));
            }
            return origin.prependComments(newComments);
        }

        SimpleConfigOrigin appendComments(SimpleConfigOrigin origin) {
            if (this.comments.isEmpty()) {
                return origin;
            }
            ArrayList<String> newComments = new ArrayList<String>();
            for (Token c : this.comments) {
                newComments.add(Tokens.getCommentText(c));
            }
            return origin.appendComments(newComments);
        }

        public String toString() {
            return this.token.toString();
        }
    }
}

