/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.netty.http.pipelining;

import com.typesafe.netty.http.pipelining.OrderedDownstreamChannelEvent;
import com.typesafe.netty.http.pipelining.OrderedUpstreamMessageEvent;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class HttpPipeliningHandler
extends SimpleChannelHandler {
    public static final int INITIAL_EVENTS_HELD = 3;
    public static final int MAX_EVENTS_HELD = 10000;
    private final int maxEventsHeld;
    private int sequence;
    private int nextRequiredSequence;
    private int nextRequiredSubsequence;
    private final Queue<OrderedDownstreamChannelEvent> holdingQueue;

    public HttpPipeliningHandler() {
        this(10000);
    }

    public HttpPipeliningHandler(int maxEventsHeld) {
        this.maxEventsHeld = maxEventsHeld;
        this.holdingQueue = new PriorityQueue<OrderedDownstreamChannelEvent>(3, new Comparator<OrderedDownstreamChannelEvent>(){

            @Override
            public int compare(OrderedDownstreamChannelEvent o1, OrderedDownstreamChannelEvent o2) {
                int delta = o1.getOrderedUpstreamMessageEvent().getSequence() - o2.getOrderedUpstreamMessageEvent().getSequence();
                if (delta == 0) {
                    return o1.getSubsequence() - o2.getSubsequence();
                }
                return delta;
            }
        });
    }

    public int getMaxEventsHeld() {
        return this.maxEventsHeld;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            ctx.sendUpstream(new OrderedUpstreamMessageEvent(this.sequence++, e.getChannel(), msg, e.getRemoteAddress()));
        } else {
            ctx.sendUpstream(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof OrderedDownstreamChannelEvent) {
            boolean channelShouldClose = false;
            Queue<OrderedDownstreamChannelEvent> queue = this.holdingQueue;
            synchronized (queue) {
                if (this.holdingQueue.size() < this.maxEventsHeld) {
                    OrderedDownstreamChannelEvent nextEvent;
                    OrderedDownstreamChannelEvent currentEvent = (OrderedDownstreamChannelEvent)e;
                    this.holdingQueue.add(currentEvent);
                    while (!this.holdingQueue.isEmpty() && !((nextEvent = this.holdingQueue.peek()).getOrderedUpstreamMessageEvent().getSequence() != this.nextRequiredSequence | nextEvent.getSubsequence() != this.nextRequiredSubsequence)) {
                        this.holdingQueue.remove();
                        ctx.sendDownstream(nextEvent.getChannelEvent());
                        if (nextEvent.isLast()) {
                            ++this.nextRequiredSequence;
                            this.nextRequiredSubsequence = 0;
                            continue;
                        }
                        ++this.nextRequiredSubsequence;
                    }
                } else {
                    channelShouldClose = true;
                }
            }
            if (channelShouldClose) {
                Channels.close(e.getChannel());
            }
        } else {
            super.handleDownstream(ctx, e);
        }
    }
}

