/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import java.net.URL;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.Application;
import play.api.Configuration;
import play.api.Logger$;
import play.api.Mode$;
import play.api.Play$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class AssetInfo$ {
    public static final AssetInfo$ MODULE$;
    private String defaultCharSet;
    private String defaultCacheControl;
    private String aggressiveCacheControl;
    private String digestAlgorithm;
    private final String timeZoneCode;
    private final String parsableTimezoneCode;
    private final DateTimeFormatter df;
    private final DateTimeFormatter dfp;
    private volatile byte bitmap$0;

    static {
        new AssetInfo$();
    }

    private String defaultCharSet$lzycompute() {
        AssetInfo$ assetInfo$ = this;
        synchronized (assetInfo$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.defaultCharSet = this.config((Function1)((Object)new Serializable(){

                    public final Option<String> apply(Configuration x$3) {
                        return x$3.getString("default.charset", x$3.getString$default$2());
                    }
                })).getOrElse(new Serializable(){

                    public final String apply() {
                        return "utf-8";
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.defaultCharSet;
        }
    }

    private String defaultCacheControl$lzycompute() {
        AssetInfo$ assetInfo$ = this;
        synchronized (assetInfo$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.defaultCacheControl = this.config((Function1)((Object)new Serializable(){

                    public final Option<String> apply(Configuration x$4) {
                        return x$4.getString("assets.defaultCache", x$4.getString$default$2());
                    }
                })).getOrElse(new Serializable(){

                    public final String apply() {
                        return "public, max-age=3600";
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.defaultCacheControl;
        }
    }

    private String aggressiveCacheControl$lzycompute() {
        AssetInfo$ assetInfo$ = this;
        synchronized (assetInfo$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.aggressiveCacheControl = this.config((Function1)((Object)new Serializable(){

                    public final Option<String> apply(Configuration x$5) {
                        return x$5.getString("assets.aggressiveCache", x$5.getString$default$2());
                    }
                })).getOrElse(new Serializable(){

                    public final String apply() {
                        return "public, max-age=31536000";
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.aggressiveCacheControl;
        }
    }

    private String digestAlgorithm$lzycompute() {
        AssetInfo$ assetInfo$ = this;
        synchronized (assetInfo$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.digestAlgorithm = this.config((Function1)((Object)new Serializable(){

                    public final Option<String> apply(Configuration x$6) {
                        return x$6.getString("assets.digest.algorithm", x$6.getString$default$2());
                    }
                })).getOrElse(new Serializable(){

                    public final String apply() {
                        return "md5";
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.digestAlgorithm;
        }
    }

    public <T> Option<T> config(Function1<Configuration, Option<T>> lookup2) {
        return Play$.MODULE$.maybeApplication().flatMap(new Serializable(lookup2){
            private final Function1 lookup$1;

            public final Option<T> apply(Application app) {
                return ((Option)this.lookup$1.apply(app.configuration())).map(new Serializable(this){

                    public final T apply(T value2) {
                        return value2;
                    }
                });
            }
            {
                this.lookup$1 = lookup$1;
            }
        });
    }

    public boolean isDev() {
        return BoxesRunTime.unboxToBoolean(Play$.MODULE$.maybeApplication().fold(new Serializable(){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, new Serializable(){

            public final boolean apply(Application x$1) {
                Enumeration.Value value2 = x$1.mode();
                Enumeration.Value value3 = Mode$.MODULE$.Dev();
                return !(value2 != null ? !((Object)value2).equals(value3) : value3 != null);
            }
        }));
    }

    public boolean isProd() {
        return BoxesRunTime.unboxToBoolean(Play$.MODULE$.maybeApplication().fold(new Serializable(){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, new Serializable(){

            public final boolean apply(Application x$2) {
                Enumeration.Value value2 = x$2.mode();
                Enumeration.Value value3 = Mode$.MODULE$.Prod();
                return !(value2 != null ? !((Object)value2).equals(value3) : value3 != null);
            }
        }));
    }

    public Option<URL> resource(String name2) {
        return Play$.MODULE$.maybeApplication().flatMap(new Serializable(name2){
            private final String name$1;

            public final Option<URL> apply(Application app) {
                return app.resource(this.name$1).map(new Serializable(this){

                    public final URL apply(URL resource2) {
                        return resource2;
                    }
                });
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public String defaultCharSet() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.defaultCharSet$lzycompute() : this.defaultCharSet;
    }

    public String defaultCacheControl() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.defaultCacheControl$lzycompute() : this.defaultCacheControl;
    }

    public String aggressiveCacheControl() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.aggressiveCacheControl$lzycompute() : this.aggressiveCacheControl;
    }

    public String digestAlgorithm() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.digestAlgorithm$lzycompute() : this.digestAlgorithm;
    }

    public String timeZoneCode() {
        return this.timeZoneCode;
    }

    public String parsableTimezoneCode() {
        return this.parsableTimezoneCode;
    }

    public DateTimeFormatter df() {
        return this.df;
    }

    public DateTimeFormatter dfp() {
        return this.dfp;
    }

    public Option<Date> parseDate(String date) {
        Option option;
        try {
            Date d = this.dfp().parseDateTime(date.replace(this.parsableTimezoneCode(), "")).toDate();
            option = new Some<Date>(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger$.MODULE$.debug((Function0<String>)((Object)new Serializable(date){
                private final String date$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"An invalidate date was received: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.date$1}));
                }
                {
                    this.date$1 = date$1;
                }
            }), (Function0<Throwable>)((Object)new Serializable(illegalArgumentException){
                private final IllegalArgumentException e$1;

                public final IllegalArgumentException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
            option = None$.MODULE$;
        }
        return option;
    }

    private AssetInfo$() {
        MODULE$ = this;
        this.timeZoneCode = "GMT";
        this.parsableTimezoneCode = new StringBuilder().append((Object)" ").append((Object)this.timeZoneCode()).toString();
        this.df = DateTimeFormat.forPattern(new StringBuilder().append((Object)"EEE, dd MMM yyyy HH:mm:ss '").append((Object)this.timeZoneCode()).append((Object)"'").toString()).withLocale(Locale.ENGLISH).withZone(DateTimeZone.forID(this.timeZoneCode()));
        this.dfp = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss").withLocale(Locale.ENGLISH).withZone(DateTimeZone.forID(this.timeZoneCode()));
    }
}

