/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.util.ListIterator;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtClassType;
import javassist.CtMember;
import javassist.CtNewWrappedMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;
import javassist.compiler.SymbolTable;
import javassist.compiler.ast.ASTree;
import javassist.compiler.ast.DoubleConst;
import javassist.compiler.ast.IntConst;
import javassist.compiler.ast.StringL;

public class CtField
extends CtMember {
    static final String javaLangString = "java.lang.String";
    protected FieldInfo fieldInfo;

    public CtField(CtClass type, String name2, CtClass declaring) throws CannotCompileException {
        this(Descriptor.of(type), name2, declaring);
    }

    public CtField(CtField src, CtClass declaring) throws CannotCompileException {
        this(src.fieldInfo.getDescriptor(), src.fieldInfo.getName(), declaring);
        ListIterator iterator2 = src.fieldInfo.getAttributes().listIterator();
        FieldInfo fi = this.fieldInfo;
        fi.setAccessFlags(src.fieldInfo.getAccessFlags());
        ConstPool cp = fi.getConstPool();
        while (iterator2.hasNext()) {
            AttributeInfo ainfo = (AttributeInfo)iterator2.next();
            fi.addAttribute(ainfo.copy(cp, null));
        }
    }

    private CtField(String typeDesc, String name2, CtClass clazz) throws CannotCompileException {
        super(clazz);
        ClassFile cf = clazz.getClassFile2();
        if (cf == null) {
            throw new CannotCompileException("bad declaring class: " + clazz.getName());
        }
        this.fieldInfo = new FieldInfo(cf.getConstPool(), name2, typeDesc);
    }

    CtField(FieldInfo fi, CtClass clazz) {
        super(clazz);
        this.fieldInfo = fi;
    }

    @Override
    public String toString() {
        return this.getDeclaringClass().getName() + "." + this.getName() + ":" + this.fieldInfo.getDescriptor();
    }

    @Override
    protected void extendToString(StringBuffer buffer2) {
        buffer2.append(' ');
        buffer2.append(this.getName());
        buffer2.append(' ');
        buffer2.append(this.fieldInfo.getDescriptor());
    }

    protected ASTree getInitAST() {
        return null;
    }

    Initializer getInit() {
        ASTree tree = this.getInitAST();
        if (tree == null) {
            return null;
        }
        return Initializer.byExpr(tree);
    }

    public static CtField make(String src, CtClass declaring) throws CannotCompileException {
        Javac compiler = new Javac(declaring);
        try {
            CtMember obj2 = compiler.compile(src);
            if (obj2 instanceof CtField) {
                return (CtField)obj2;
            }
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        throw new CannotCompileException("not a field");
    }

    public FieldInfo getFieldInfo() {
        this.declaringClass.checkModify();
        return this.fieldInfo;
    }

    public FieldInfo getFieldInfo2() {
        return this.fieldInfo;
    }

    @Override
    public CtClass getDeclaringClass() {
        return super.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.fieldInfo.getName();
    }

    public void setName(String newName) {
        this.declaringClass.checkModify();
        this.fieldInfo.setName(newName);
    }

    @Override
    public int getModifiers() {
        return AccessFlag.toModifier(this.fieldInfo.getAccessFlags());
    }

    @Override
    public void setModifiers(int mod) {
        this.declaringClass.checkModify();
        this.fieldInfo.setAccessFlags(AccessFlag.of(mod));
    }

    @Override
    public boolean hasAnnotation(Class clz) {
        FieldInfo fi = this.getFieldInfo2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)fi.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)fi.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType(clz, this.getDeclaringClass().getClassPool(), ainfo, ainfo2);
    }

    @Override
    public Object getAnnotation(Class clz) throws ClassNotFoundException {
        FieldInfo fi = this.getFieldInfo2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)fi.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)fi.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(clz, this.getDeclaringClass().getClassPool(), ainfo, ainfo2);
    }

    @Override
    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    @Override
    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private Object[] getAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        FieldInfo fi = this.getFieldInfo2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)fi.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)fi.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(ignoreNotFound, this.getDeclaringClass().getClassPool(), ainfo, ainfo2);
    }

    @Override
    public String getSignature() {
        return this.fieldInfo.getDescriptor();
    }

    @Override
    public String getGenericSignature() {
        SignatureAttribute sa = (SignatureAttribute)this.fieldInfo.getAttribute("Signature");
        return sa == null ? null : sa.getSignature();
    }

    @Override
    public void setGenericSignature(String sig) {
        this.declaringClass.checkModify();
        this.fieldInfo.addAttribute(new SignatureAttribute(this.fieldInfo.getConstPool(), sig));
    }

    public CtClass getType() throws NotFoundException {
        return Descriptor.toCtClass(this.fieldInfo.getDescriptor(), this.declaringClass.getClassPool());
    }

    public void setType(CtClass clazz) {
        this.declaringClass.checkModify();
        this.fieldInfo.setDescriptor(Descriptor.of(clazz));
    }

    public Object getConstantValue() {
        int index2 = this.fieldInfo.getConstantValue();
        if (index2 == 0) {
            return null;
        }
        ConstPool cp = this.fieldInfo.getConstPool();
        switch (cp.getTag(index2)) {
            case 5: {
                return new Long(cp.getLongInfo(index2));
            }
            case 4: {
                return new Float(cp.getFloatInfo(index2));
            }
            case 6: {
                return new Double(cp.getDoubleInfo(index2));
            }
            case 3: {
                int value2 = cp.getIntegerInfo(index2);
                if ("Z".equals(this.fieldInfo.getDescriptor())) {
                    return new Boolean(value2 != 0);
                }
                return new Integer(value2);
            }
            case 8: {
                return cp.getStringInfo(index2);
            }
        }
        throw new RuntimeException("bad tag: " + cp.getTag(index2) + " at " + index2);
    }

    @Override
    public byte[] getAttribute(String name2) {
        AttributeInfo ai = this.fieldInfo.getAttribute(name2);
        if (ai == null) {
            return null;
        }
        return ai.get();
    }

    @Override
    public void setAttribute(String name2, byte[] data) {
        this.declaringClass.checkModify();
        this.fieldInfo.addAttribute(new AttributeInfo(this.fieldInfo.getConstPool(), name2, data));
    }

    static class MultiArrayInitializer
    extends Initializer {
        CtClass type;
        int[] dim;

        MultiArrayInitializer(CtClass t, int[] d) {
            this.type = t;
            this.dim = d;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (desc.charAt(0) != '[') {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            int s2 = code2.addMultiNewarray(type, this.dim);
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return s2 + 1;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            int s2 = code2.addMultiNewarray(type, this.dim);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return s2;
        }
    }

    static class ArrayInitializer
    extends Initializer {
        CtClass type;
        int size;

        ArrayInitializer(CtClass t, int s2) {
            this.type = t;
            this.size = s2;
        }

        private void addNewarray(Bytecode code2) {
            if (this.type.isPrimitive()) {
                code2.addNewarray(((CtPrimitiveType)this.type).getArrayType(), this.size);
            } else {
                code2.addAnewarray(this.type, this.size);
            }
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            this.addNewarray(code2);
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return 2;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            this.addNewarray(code2);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return 1;
        }
    }

    static class StringInitializer
    extends Initializer {
        String value;

        StringInitializer(String v) {
            this.value = v;
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            code2.addLdc(this.value);
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return 2;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            code2.addLdc(this.value);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return 1;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type.getName().equals(CtField.javaLangString)) {
                return cp.addStringInfo(this.value);
            }
            return 0;
        }
    }

    static class DoubleInitializer
    extends Initializer {
        double value;

        DoubleInitializer(double v) {
            this.value = v;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (!desc.equals("D")) {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            code2.addLdc2w(this.value);
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return 3;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            code2.addLdc2w(this.value);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return 2;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type == CtClass.doubleType) {
                return cp.addDoubleInfo(this.value);
            }
            return 0;
        }
    }

    static class FloatInitializer
    extends Initializer {
        float value;

        FloatInitializer(float v) {
            this.value = v;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (!desc.equals("F")) {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            code2.addFconst(this.value);
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return 3;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            code2.addFconst(this.value);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return 2;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type == CtClass.floatType) {
                return cp.addFloatInfo(this.value);
            }
            return 0;
        }
    }

    static class LongInitializer
    extends Initializer {
        long value;

        LongInitializer(long v) {
            this.value = v;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (!desc.equals("J")) {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            code2.addLdc2w(this.value);
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return 3;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            code2.addLdc2w(this.value);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return 2;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type == CtClass.longType) {
                return cp.addLongInfo(this.value);
            }
            return 0;
        }
    }

    static class IntInitializer
    extends Initializer {
        int value;

        IntInitializer(int v) {
            this.value = v;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            char c = desc.charAt(0);
            if (c != 'I' && c != 'S' && c != 'B' && c != 'C' && c != 'Z') {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            code2.addIconst(this.value);
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return 2;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            code2.addIconst(this.value);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return 1;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            return cp.addIntegerInfo(this.value);
        }
    }

    static class MethodInitializer
    extends NewInitializer {
        String methodName;

        MethodInitializer() {
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            code2.addAload(0);
            int stacksize = this.stringParams == null ? 2 : this.compileStringParameter(code2) + 2;
            if (this.withConstructorParams) {
                stacksize += CtNewWrappedMethod.compileParameterList(code2, parameters, 1);
            }
            String typeDesc = Descriptor.of(type);
            String mDesc = this.getDescriptor() + typeDesc;
            code2.addInvokestatic(this.objectType, this.methodName, mDesc);
            code2.addPutfield(Bytecode.THIS, name2, typeDesc);
            return stacksize;
        }

        private String getDescriptor() {
            String desc3 = "(Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/Object;)";
            if (this.stringParams == null) {
                if (this.withConstructorParams) {
                    return "(Ljava/lang/Object;[Ljava/lang/Object;)";
                }
                return "(Ljava/lang/Object;)";
            }
            if (this.withConstructorParams) {
                return "(Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/Object;)";
            }
            return "(Ljava/lang/Object;[Ljava/lang/String;)";
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            String desc;
            int stacksize = 1;
            if (this.stringParams == null) {
                desc = "()";
            } else {
                desc = "([Ljava/lang/String;)";
                stacksize += this.compileStringParameter(code2);
            }
            String typeDesc = Descriptor.of(type);
            code2.addInvokestatic(this.objectType, this.methodName, desc + typeDesc);
            code2.addPutstatic(Bytecode.THIS, name2, typeDesc);
            return stacksize;
        }
    }

    static class NewInitializer
    extends Initializer {
        CtClass objectType;
        String[] stringParams;
        boolean withConstructorParams;

        NewInitializer() {
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code2.addAload(0);
            code2.addNew(this.objectType);
            code2.add(89);
            code2.addAload(0);
            int stacksize = this.stringParams == null ? 4 : this.compileStringParameter(code2) + 4;
            if (this.withConstructorParams) {
                stacksize += CtNewWrappedMethod.compileParameterList(code2, parameters, 1);
            }
            code2.addInvokespecial(this.objectType, "<init>", this.getDescriptor());
            code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
            return stacksize;
        }

        private String getDescriptor() {
            String desc3 = "(Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/Object;)V";
            if (this.stringParams == null) {
                if (this.withConstructorParams) {
                    return "(Ljava/lang/Object;[Ljava/lang/Object;)V";
                }
                return "(Ljava/lang/Object;)V";
            }
            if (this.withConstructorParams) {
                return "(Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/Object;)V";
            }
            return "(Ljava/lang/Object;[Ljava/lang/String;)V";
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            String desc;
            code2.addNew(this.objectType);
            code2.add(89);
            int stacksize = 2;
            if (this.stringParams == null) {
                desc = "()V";
            } else {
                desc = "([Ljava/lang/String;)V";
                stacksize += this.compileStringParameter(code2);
            }
            code2.addInvokespecial(this.objectType, "<init>", desc);
            code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
            return stacksize;
        }

        protected final int compileStringParameter(Bytecode code2) throws CannotCompileException {
            int nparam = this.stringParams.length;
            code2.addIconst(nparam);
            code2.addAnewarray(CtField.javaLangString);
            for (int j = 0; j < nparam; ++j) {
                code2.add(89);
                code2.addIconst(j);
                code2.addLdc(this.stringParams[j]);
                code2.add(83);
            }
            return 4;
        }
    }

    static class ParamInitializer
    extends Initializer {
        int nthParam;

        ParamInitializer() {
        }

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            if (parameters != null && this.nthParam < parameters.length) {
                code2.addAload(0);
                int nth = ParamInitializer.nthParamToLocal(this.nthParam, parameters, false);
                int s2 = code2.addLoad(nth, type) + 1;
                code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
                return s2;
            }
            return 0;
        }

        static int nthParamToLocal(int nth, CtClass[] params2, boolean isStatic) {
            CtClass longType = CtClass.longType;
            CtClass doubleType = CtClass.doubleType;
            int k = isStatic ? 0 : 1;
            for (int i = 0; i < nth; ++i) {
                CtClass type = params2[i];
                if (type == longType || type == doubleType) {
                    k += 2;
                    continue;
                }
                ++k;
            }
            return k;
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            return 0;
        }
    }

    static class PtreeInitializer
    extends CodeInitializer0 {
        private ASTree expression;

        PtreeInitializer(ASTree expr) {
            this.expression = expr;
        }

        @Override
        void compileExpr(Javac drv) throws CompileError {
            drv.compileExpr(this.expression);
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            return this.getConstantValue2(cp, type, this.expression);
        }
    }

    static class CodeInitializer
    extends CodeInitializer0 {
        private String expression;

        CodeInitializer(String expr) {
            this.expression = expr;
        }

        @Override
        void compileExpr(Javac drv) throws CompileError {
            drv.compileExpr(this.expression);
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            try {
                ASTree t = Javac.parseExpr(this.expression, new SymbolTable());
                return this.getConstantValue2(cp, type, t);
            }
            catch (CompileError e) {
                return 0;
            }
        }
    }

    static abstract class CodeInitializer0
    extends Initializer {
        CodeInitializer0() {
        }

        abstract void compileExpr(Javac var1) throws CompileError;

        @Override
        int compile(CtClass type, String name2, Bytecode code2, CtClass[] parameters, Javac drv) throws CannotCompileException {
            try {
                code2.addAload(0);
                this.compileExpr(drv);
                code2.addPutfield(Bytecode.THIS, name2, Descriptor.of(type));
                return code2.getMaxStack();
            }
            catch (CompileError e) {
                throw new CannotCompileException(e);
            }
        }

        @Override
        int compileIfStatic(CtClass type, String name2, Bytecode code2, Javac drv) throws CannotCompileException {
            try {
                this.compileExpr(drv);
                code2.addPutstatic(Bytecode.THIS, name2, Descriptor.of(type));
                return code2.getMaxStack();
            }
            catch (CompileError e) {
                throw new CannotCompileException(e);
            }
        }

        int getConstantValue2(ConstPool cp, CtClass type, ASTree tree) {
            if (type.isPrimitive()) {
                if (tree instanceof IntConst) {
                    long value2 = ((IntConst)tree).get();
                    if (type == CtClass.doubleType) {
                        return cp.addDoubleInfo(value2);
                    }
                    if (type == CtClass.floatType) {
                        return cp.addFloatInfo(value2);
                    }
                    if (type == CtClass.longType) {
                        return cp.addLongInfo(value2);
                    }
                    if (type != CtClass.voidType) {
                        return cp.addIntegerInfo((int)value2);
                    }
                } else if (tree instanceof DoubleConst) {
                    double value3 = ((DoubleConst)tree).get();
                    if (type == CtClass.floatType) {
                        return cp.addFloatInfo((float)value3);
                    }
                    if (type == CtClass.doubleType) {
                        return cp.addDoubleInfo(value3);
                    }
                }
            } else if (tree instanceof StringL && type.getName().equals(CtField.javaLangString)) {
                return cp.addStringInfo(((StringL)tree).get());
            }
            return 0;
        }
    }

    public static abstract class Initializer {
        public static Initializer constant(int i) {
            return new IntInitializer(i);
        }

        public static Initializer constant(boolean b) {
            return new IntInitializer(b ? 1 : 0);
        }

        public static Initializer constant(long l) {
            return new LongInitializer(l);
        }

        public static Initializer constant(float l) {
            return new FloatInitializer(l);
        }

        public static Initializer constant(double d) {
            return new DoubleInitializer(d);
        }

        public static Initializer constant(String s2) {
            return new StringInitializer(s2);
        }

        public static Initializer byParameter(int nth) {
            ParamInitializer i = new ParamInitializer();
            i.nthParam = nth;
            return i;
        }

        public static Initializer byNew(CtClass objectType) {
            NewInitializer i = new NewInitializer();
            i.objectType = objectType;
            i.stringParams = null;
            i.withConstructorParams = false;
            return i;
        }

        public static Initializer byNew(CtClass objectType, String[] stringParams) {
            NewInitializer i = new NewInitializer();
            i.objectType = objectType;
            i.stringParams = stringParams;
            i.withConstructorParams = false;
            return i;
        }

        public static Initializer byNewWithParams(CtClass objectType) {
            NewInitializer i = new NewInitializer();
            i.objectType = objectType;
            i.stringParams = null;
            i.withConstructorParams = true;
            return i;
        }

        public static Initializer byNewWithParams(CtClass objectType, String[] stringParams) {
            NewInitializer i = new NewInitializer();
            i.objectType = objectType;
            i.stringParams = stringParams;
            i.withConstructorParams = true;
            return i;
        }

        public static Initializer byCall(CtClass methodClass, String methodName) {
            MethodInitializer i = new MethodInitializer();
            i.objectType = methodClass;
            i.methodName = methodName;
            i.stringParams = null;
            i.withConstructorParams = false;
            return i;
        }

        public static Initializer byCall(CtClass methodClass, String methodName, String[] stringParams) {
            MethodInitializer i = new MethodInitializer();
            i.objectType = methodClass;
            i.methodName = methodName;
            i.stringParams = stringParams;
            i.withConstructorParams = false;
            return i;
        }

        public static Initializer byCallWithParams(CtClass methodClass, String methodName) {
            MethodInitializer i = new MethodInitializer();
            i.objectType = methodClass;
            i.methodName = methodName;
            i.stringParams = null;
            i.withConstructorParams = true;
            return i;
        }

        public static Initializer byCallWithParams(CtClass methodClass, String methodName, String[] stringParams) {
            MethodInitializer i = new MethodInitializer();
            i.objectType = methodClass;
            i.methodName = methodName;
            i.stringParams = stringParams;
            i.withConstructorParams = true;
            return i;
        }

        public static Initializer byNewArray(CtClass type, int size2) throws NotFoundException {
            return new ArrayInitializer(type.getComponentType(), size2);
        }

        public static Initializer byNewArray(CtClass type, int[] sizes) {
            return new MultiArrayInitializer(type, sizes);
        }

        public static Initializer byExpr(String source) {
            return new CodeInitializer(source);
        }

        static Initializer byExpr(ASTree source) {
            return new PtreeInitializer(source);
        }

        void check(String desc) throws CannotCompileException {
        }

        abstract int compile(CtClass var1, String var2, Bytecode var3, CtClass[] var4, Javac var5) throws CannotCompileException;

        abstract int compileIfStatic(CtClass var1, String var2, Bytecode var3, Javac var4) throws CannotCompileException;

        int getConstantValue(ConstPool cp, CtClass type) {
            return 0;
        }
    }
}

