/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.util.Hashtable;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.CtClass;
import javassist.CtClassType;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SyntheticAttribute;
import javassist.compiler.JvstCodeGen;

class CtNewWrappedMethod {
    private static final String addedWrappedMethod = "_added_m$";

    CtNewWrappedMethod() {
    }

    public static CtMethod wrapped(CtClass returnType, String mname, CtClass[] parameterTypes, CtClass[] exceptionTypes, CtMethod body2, CtMethod.ConstParameter constParam, CtClass declaring) throws CannotCompileException {
        CtMethod mt = new CtMethod(returnType, mname, parameterTypes, declaring);
        mt.setModifiers(body2.getModifiers());
        try {
            mt.setExceptionTypes(exceptionTypes);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        Bytecode code2 = CtNewWrappedMethod.makeBody(declaring, declaring.getClassFile2(), body2, parameterTypes, returnType, constParam);
        MethodInfo minfo = mt.getMethodInfo2();
        minfo.setCodeAttribute(code2.toCodeAttribute());
        return mt;
    }

    static Bytecode makeBody(CtClass clazz, ClassFile classfile, CtMethod wrappedBody, CtClass[] parameters, CtClass returnType, CtMethod.ConstParameter cparam) throws CannotCompileException {
        boolean isStatic = Modifier.isStatic(wrappedBody.getModifiers());
        Bytecode code2 = new Bytecode(classfile.getConstPool(), 0, 0);
        int stacksize = CtNewWrappedMethod.makeBody0(clazz, classfile, wrappedBody, isStatic, parameters, returnType, cparam, code2);
        code2.setMaxStack(stacksize);
        code2.setMaxLocals(isStatic, parameters, 0);
        return code2;
    }

    protected static int makeBody0(CtClass clazz, ClassFile classfile, CtMethod wrappedBody, boolean isStatic, CtClass[] parameters, CtClass returnType, CtMethod.ConstParameter cparam, Bytecode code2) throws CannotCompileException {
        String bodyname;
        String desc;
        int stacksize2;
        if (!(clazz instanceof CtClassType)) {
            throw new CannotCompileException("bad declaring class" + clazz.getName());
        }
        if (!isStatic) {
            code2.addAload(0);
        }
        int stacksize = CtNewWrappedMethod.compileParameterList(code2, parameters, isStatic ? 0 : 1);
        if (cparam == null) {
            stacksize2 = 0;
            desc = CtMethod.ConstParameter.defaultDescriptor();
        } else {
            stacksize2 = cparam.compile(code2);
            desc = cparam.descriptor();
        }
        CtNewWrappedMethod.checkSignature(wrappedBody, desc);
        try {
            bodyname = CtNewWrappedMethod.addBodyMethod((CtClassType)clazz, classfile, wrappedBody);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
        if (isStatic) {
            code2.addInvokestatic(Bytecode.THIS, bodyname, desc);
        } else {
            code2.addInvokespecial(Bytecode.THIS, bodyname, desc);
        }
        CtNewWrappedMethod.compileReturn(code2, returnType);
        if (stacksize < stacksize2 + 2) {
            stacksize = stacksize2 + 2;
        }
        return stacksize;
    }

    private static void checkSignature(CtMethod wrappedBody, String descriptor) throws CannotCompileException {
        if (!descriptor.equals(wrappedBody.getMethodInfo2().getDescriptor())) {
            throw new CannotCompileException("wrapped method with a bad signature: " + wrappedBody.getDeclaringClass().getName() + '.' + wrappedBody.getName());
        }
    }

    private static String addBodyMethod(CtClassType clazz, ClassFile classfile, CtMethod src) throws BadBytecode, CannotCompileException {
        Hashtable bodies = clazz.getHiddenMethods();
        String bodyname = (String)bodies.get(src);
        if (bodyname == null) {
            while (classfile.getMethod(bodyname = addedWrappedMethod + clazz.getUniqueNumber()) != null) {
            }
            ClassMap map2 = new ClassMap();
            map2.put(src.getDeclaringClass().getName(), clazz.getName());
            MethodInfo body2 = new MethodInfo(classfile.getConstPool(), bodyname, src.getMethodInfo2(), map2);
            int acc = body2.getAccessFlags();
            body2.setAccessFlags(AccessFlag.setPrivate(acc));
            body2.addAttribute(new SyntheticAttribute(classfile.getConstPool()));
            classfile.addMethod(body2);
            bodies.put(src, bodyname);
            CtMember.Cache cache = clazz.hasMemberCache();
            if (cache != null) {
                cache.addMethod(new CtMethod(body2, clazz));
            }
        }
        return bodyname;
    }

    static int compileParameterList(Bytecode code2, CtClass[] params2, int regno) {
        return JvstCodeGen.compileParameterList(code2, params2, regno);
    }

    private static void compileReturn(Bytecode code2, CtClass type) {
        if (type.isPrimitive()) {
            CtPrimitiveType pt = (CtPrimitiveType)type;
            if (pt != CtClass.voidType) {
                String wrapper = pt.getWrapperName();
                code2.addCheckcast(wrapper);
                code2.addInvokevirtual(wrapper, pt.getGetMethodName(), pt.getGetMethodDescriptor());
            }
            code2.addOpcode(pt.getReturnOp());
        } else {
            code2.addCheckcast(type);
            code2.addOpcode(176);
        }
    }
}

