/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import javassist.CtClass;
import javassist.CtPrimitiveType;
import javassist.bytecode.ByteVector;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.Opcode;

public class Bytecode
extends ByteVector
implements Cloneable,
Opcode {
    public static final CtClass THIS = ConstPool.THIS;
    ConstPool constPool;
    int maxStack;
    int maxLocals;
    ExceptionTable tryblocks;
    private int stackDepth;

    public Bytecode(ConstPool cp, int stacksize, int localvars) {
        this.constPool = cp;
        this.maxStack = stacksize;
        this.maxLocals = localvars;
        this.tryblocks = new ExceptionTable(cp);
        this.stackDepth = 0;
    }

    public Bytecode(ConstPool cp) {
        this(cp, 0, 0);
    }

    @Override
    public Object clone() {
        try {
            Bytecode bc = (Bytecode)super.clone();
            bc.tryblocks = (ExceptionTable)this.tryblocks.clone();
            return bc;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public ExceptionTable getExceptionTable() {
        return this.tryblocks;
    }

    public CodeAttribute toCodeAttribute() {
        return new CodeAttribute(this.constPool, this.maxStack, this.maxLocals, this.get(), this.tryblocks);
    }

    public int length() {
        return this.getSize();
    }

    public byte[] get() {
        return this.copy();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int size2) {
        this.maxStack = size2;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int size2) {
        this.maxLocals = size2;
    }

    public void setMaxLocals(boolean isStatic, CtClass[] params2, int locals) {
        if (!isStatic) {
            ++locals;
        }
        if (params2 != null) {
            CtClass doubleType = CtClass.doubleType;
            CtClass longType = CtClass.longType;
            for (CtClass type : params2) {
                if (type == doubleType || type == longType) {
                    locals += 2;
                    continue;
                }
                ++locals;
            }
        }
        this.maxLocals = locals;
    }

    public void incMaxLocals(int diff2) {
        this.maxLocals += diff2;
    }

    public void addExceptionHandler(int start2, int end2, int handler, CtClass type) {
        this.addExceptionHandler(start2, end2, handler, this.constPool.addClassInfo(type));
    }

    public void addExceptionHandler(int start2, int end2, int handler, String type) {
        this.addExceptionHandler(start2, end2, handler, this.constPool.addClassInfo(type));
    }

    public void addExceptionHandler(int start2, int end2, int handler, int type) {
        this.tryblocks.add(start2, end2, handler, type);
    }

    public int currentPc() {
        return this.getSize();
    }

    @Override
    public int read(int offset) {
        return super.read(offset);
    }

    public int read16bit(int offset) {
        int v1 = this.read(offset);
        int v2 = this.read(offset + 1);
        return (v1 << 8) + (v2 & 0xFF);
    }

    public int read32bit(int offset) {
        int v1 = this.read16bit(offset);
        int v2 = this.read16bit(offset + 2);
        return (v1 << 16) + (v2 & 0xFFFF);
    }

    @Override
    public void write(int offset, int value2) {
        super.write(offset, value2);
    }

    public void write16bit(int offset, int value2) {
        this.write(offset, value2 >> 8);
        this.write(offset + 1, value2);
    }

    public void write32bit(int offset, int value2) {
        this.write16bit(offset, value2 >> 16);
        this.write16bit(offset + 2, value2);
    }

    @Override
    public void add(int code2) {
        super.add(code2);
    }

    public void add32bit(int value2) {
        this.add(value2 >> 24, value2 >> 16, value2 >> 8, value2);
    }

    @Override
    public void addGap(int length) {
        super.addGap(length);
    }

    public void addOpcode(int code2) {
        this.add(code2);
        this.growStack(STACK_GROW[code2]);
    }

    public void growStack(int diff2) {
        this.setStackDepth(this.stackDepth + diff2);
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public void setStackDepth(int depth) {
        this.stackDepth = depth;
        if (this.stackDepth > this.maxStack) {
            this.maxStack = this.stackDepth;
        }
    }

    public void addIndex(int index2) {
        this.add(index2 >> 8, index2);
    }

    public void addAload(int n) {
        if (n < 4) {
            this.addOpcode(42 + n);
        } else if (n < 256) {
            this.addOpcode(25);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(25);
            this.addIndex(n);
        }
    }

    public void addAstore(int n) {
        if (n < 4) {
            this.addOpcode(75 + n);
        } else if (n < 256) {
            this.addOpcode(58);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(58);
            this.addIndex(n);
        }
    }

    public void addIconst(int n) {
        if (n < 6 && -2 < n) {
            this.addOpcode(3 + n);
        } else if (n <= 127 && -128 <= n) {
            this.addOpcode(16);
            this.add(n);
        } else if (n <= Short.MAX_VALUE && Short.MIN_VALUE <= n) {
            this.addOpcode(17);
            this.add(n >> 8);
            this.add(n);
        } else {
            this.addLdc(this.constPool.addIntegerInfo(n));
        }
    }

    public void addConstZero(CtClass type) {
        if (type.isPrimitive()) {
            if (type == CtClass.longType) {
                this.addOpcode(9);
            } else if (type == CtClass.floatType) {
                this.addOpcode(11);
            } else if (type == CtClass.doubleType) {
                this.addOpcode(14);
            } else {
                if (type == CtClass.voidType) {
                    throw new RuntimeException("void type?");
                }
                this.addOpcode(3);
            }
        } else {
            this.addOpcode(1);
        }
    }

    public void addIload(int n) {
        if (n < 4) {
            this.addOpcode(26 + n);
        } else if (n < 256) {
            this.addOpcode(21);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(21);
            this.addIndex(n);
        }
    }

    public void addIstore(int n) {
        if (n < 4) {
            this.addOpcode(59 + n);
        } else if (n < 256) {
            this.addOpcode(54);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(54);
            this.addIndex(n);
        }
    }

    public void addLconst(long n) {
        if (n == 0L || n == 1L) {
            this.addOpcode(9 + (int)n);
        } else {
            this.addLdc2w(n);
        }
    }

    public void addLload(int n) {
        if (n < 4) {
            this.addOpcode(30 + n);
        } else if (n < 256) {
            this.addOpcode(22);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(22);
            this.addIndex(n);
        }
    }

    public void addLstore(int n) {
        if (n < 4) {
            this.addOpcode(63 + n);
        } else if (n < 256) {
            this.addOpcode(55);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(55);
            this.addIndex(n);
        }
    }

    public void addDconst(double d) {
        if (d == 0.0 || d == 1.0) {
            this.addOpcode(14 + (int)d);
        } else {
            this.addLdc2w(d);
        }
    }

    public void addDload(int n) {
        if (n < 4) {
            this.addOpcode(38 + n);
        } else if (n < 256) {
            this.addOpcode(24);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(24);
            this.addIndex(n);
        }
    }

    public void addDstore(int n) {
        if (n < 4) {
            this.addOpcode(71 + n);
        } else if (n < 256) {
            this.addOpcode(57);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(57);
            this.addIndex(n);
        }
    }

    public void addFconst(float f2) {
        if (f2 == 0.0f || f2 == 1.0f || f2 == 2.0f) {
            this.addOpcode(11 + (int)f2);
        } else {
            this.addLdc(this.constPool.addFloatInfo(f2));
        }
    }

    public void addFload(int n) {
        if (n < 4) {
            this.addOpcode(34 + n);
        } else if (n < 256) {
            this.addOpcode(23);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(23);
            this.addIndex(n);
        }
    }

    public void addFstore(int n) {
        if (n < 4) {
            this.addOpcode(67 + n);
        } else if (n < 256) {
            this.addOpcode(56);
            this.add(n);
        } else {
            this.addOpcode(196);
            this.addOpcode(56);
            this.addIndex(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addLoad(int n, CtClass type) {
        if (!type.isPrimitive()) {
            this.addAload(n);
            return 1;
        }
        if (type == CtClass.booleanType || type == CtClass.charType || type == CtClass.byteType || type == CtClass.shortType || type == CtClass.intType) {
            this.addIload(n);
            return 1;
        }
        if (type == CtClass.longType) {
            this.addLload(n);
            return 2;
        }
        if (type == CtClass.floatType) {
            this.addFload(n);
            return 1;
        }
        if (type != CtClass.doubleType) throw new RuntimeException("void type?");
        this.addDload(n);
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addStore(int n, CtClass type) {
        if (!type.isPrimitive()) {
            this.addAstore(n);
            return 1;
        }
        if (type == CtClass.booleanType || type == CtClass.charType || type == CtClass.byteType || type == CtClass.shortType || type == CtClass.intType) {
            this.addIstore(n);
            return 1;
        }
        if (type == CtClass.longType) {
            this.addLstore(n);
            return 2;
        }
        if (type == CtClass.floatType) {
            this.addFstore(n);
            return 1;
        }
        if (type != CtClass.doubleType) throw new RuntimeException("void type?");
        this.addDstore(n);
        return 2;
    }

    public int addLoadParameters(CtClass[] params2, int offset) {
        int stacksize = 0;
        if (params2 != null) {
            int n = params2.length;
            for (int i = 0; i < n; ++i) {
                stacksize += this.addLoad(stacksize + offset, params2[i]);
            }
        }
        return stacksize;
    }

    public void addCheckcast(CtClass c) {
        this.addOpcode(192);
        this.addIndex(this.constPool.addClassInfo(c));
    }

    public void addCheckcast(String classname) {
        this.addOpcode(192);
        this.addIndex(this.constPool.addClassInfo(classname));
    }

    public void addInstanceof(String classname) {
        this.addOpcode(193);
        this.addIndex(this.constPool.addClassInfo(classname));
    }

    public void addGetfield(CtClass c, String name2, String type) {
        this.add(180);
        int ci = this.constPool.addClassInfo(c);
        this.addIndex(this.constPool.addFieldrefInfo(ci, name2, type));
        this.growStack(Descriptor.dataSize(type) - 1);
    }

    public void addGetfield(String c, String name2, String type) {
        this.add(180);
        int ci = this.constPool.addClassInfo(c);
        this.addIndex(this.constPool.addFieldrefInfo(ci, name2, type));
        this.growStack(Descriptor.dataSize(type) - 1);
    }

    public void addGetstatic(CtClass c, String name2, String type) {
        this.add(178);
        int ci = this.constPool.addClassInfo(c);
        this.addIndex(this.constPool.addFieldrefInfo(ci, name2, type));
        this.growStack(Descriptor.dataSize(type));
    }

    public void addGetstatic(String c, String name2, String type) {
        this.add(178);
        int ci = this.constPool.addClassInfo(c);
        this.addIndex(this.constPool.addFieldrefInfo(ci, name2, type));
        this.growStack(Descriptor.dataSize(type));
    }

    public void addInvokespecial(CtClass clazz, String name2, CtClass returnType, CtClass[] paramTypes2) {
        String desc = Descriptor.ofMethod(returnType, paramTypes2);
        this.addInvokespecial(clazz, name2, desc);
    }

    public void addInvokespecial(CtClass clazz, String name2, String desc) {
        this.addInvokespecial(this.constPool.addClassInfo(clazz), name2, desc);
    }

    public void addInvokespecial(String clazz, String name2, String desc) {
        this.addInvokespecial(this.constPool.addClassInfo(clazz), name2, desc);
    }

    public void addInvokespecial(int clazz, String name2, String desc) {
        this.add(183);
        this.addIndex(this.constPool.addMethodrefInfo(clazz, name2, desc));
        this.growStack(Descriptor.dataSize(desc) - 1);
    }

    public void addInvokestatic(CtClass clazz, String name2, CtClass returnType, CtClass[] paramTypes2) {
        String desc = Descriptor.ofMethod(returnType, paramTypes2);
        this.addInvokestatic(clazz, name2, desc);
    }

    public void addInvokestatic(CtClass clazz, String name2, String desc) {
        this.addInvokestatic(this.constPool.addClassInfo(clazz), name2, desc);
    }

    public void addInvokestatic(String classname, String name2, String desc) {
        this.addInvokestatic(this.constPool.addClassInfo(classname), name2, desc);
    }

    public void addInvokestatic(int clazz, String name2, String desc) {
        this.add(184);
        this.addIndex(this.constPool.addMethodrefInfo(clazz, name2, desc));
        this.growStack(Descriptor.dataSize(desc));
    }

    public void addInvokevirtual(CtClass clazz, String name2, CtClass returnType, CtClass[] paramTypes2) {
        String desc = Descriptor.ofMethod(returnType, paramTypes2);
        this.addInvokevirtual(clazz, name2, desc);
    }

    public void addInvokevirtual(CtClass clazz, String name2, String desc) {
        this.addInvokevirtual(this.constPool.addClassInfo(clazz), name2, desc);
    }

    public void addInvokevirtual(String classname, String name2, String desc) {
        this.addInvokevirtual(this.constPool.addClassInfo(classname), name2, desc);
    }

    public void addInvokevirtual(int clazz, String name2, String desc) {
        this.add(182);
        this.addIndex(this.constPool.addMethodrefInfo(clazz, name2, desc));
        this.growStack(Descriptor.dataSize(desc) - 1);
    }

    public void addInvokeinterface(CtClass clazz, String name2, CtClass returnType, CtClass[] paramTypes2, int count2) {
        String desc = Descriptor.ofMethod(returnType, paramTypes2);
        this.addInvokeinterface(clazz, name2, desc, count2);
    }

    public void addInvokeinterface(CtClass clazz, String name2, String desc, int count2) {
        this.addInvokeinterface(this.constPool.addClassInfo(clazz), name2, desc, count2);
    }

    public void addInvokeinterface(String classname, String name2, String desc, int count2) {
        this.addInvokeinterface(this.constPool.addClassInfo(classname), name2, desc, count2);
    }

    public void addInvokeinterface(int clazz, String name2, String desc, int count2) {
        this.add(185);
        this.addIndex(this.constPool.addInterfaceMethodrefInfo(clazz, name2, desc));
        this.add(count2);
        this.add(0);
        this.growStack(Descriptor.dataSize(desc) - 1);
    }

    public void addInvokedynamic(int bootstrap, String name2, String desc) {
        int nt = this.constPool.addNameAndTypeInfo(name2, desc);
        int dyn = this.constPool.addInvokeDynamicInfo(bootstrap, nt);
        this.add(186);
        this.addIndex(dyn);
        this.add(0, 0);
        this.growStack(Descriptor.dataSize(desc));
    }

    public void addLdc(String s2) {
        this.addLdc(this.constPool.addStringInfo(s2));
    }

    public void addLdc(int i) {
        if (i > 255) {
            this.addOpcode(19);
            this.addIndex(i);
        } else {
            this.addOpcode(18);
            this.add(i);
        }
    }

    public void addLdc2w(long l) {
        this.addOpcode(20);
        this.addIndex(this.constPool.addLongInfo(l));
    }

    public void addLdc2w(double d) {
        this.addOpcode(20);
        this.addIndex(this.constPool.addDoubleInfo(d));
    }

    public void addNew(CtClass clazz) {
        this.addOpcode(187);
        this.addIndex(this.constPool.addClassInfo(clazz));
    }

    public void addNew(String classname) {
        this.addOpcode(187);
        this.addIndex(this.constPool.addClassInfo(classname));
    }

    public void addAnewarray(String classname) {
        this.addOpcode(189);
        this.addIndex(this.constPool.addClassInfo(classname));
    }

    public void addAnewarray(CtClass clazz, int length) {
        this.addIconst(length);
        this.addOpcode(189);
        this.addIndex(this.constPool.addClassInfo(clazz));
    }

    public void addNewarray(int atype, int length) {
        this.addIconst(length);
        this.addOpcode(188);
        this.add(atype);
    }

    public int addMultiNewarray(CtClass clazz, int[] dimensions) {
        int len2 = dimensions.length;
        for (int i = 0; i < len2; ++i) {
            this.addIconst(dimensions[i]);
        }
        this.growStack(len2);
        return this.addMultiNewarray(clazz, len2);
    }

    public int addMultiNewarray(CtClass clazz, int dim) {
        this.add(197);
        this.addIndex(this.constPool.addClassInfo(clazz));
        this.add(dim);
        this.growStack(1 - dim);
        return dim;
    }

    public int addMultiNewarray(String desc, int dim) {
        this.add(197);
        this.addIndex(this.constPool.addClassInfo(desc));
        this.add(dim);
        this.growStack(1 - dim);
        return dim;
    }

    public void addPutfield(CtClass c, String name2, String desc) {
        this.addPutfield0(c, null, name2, desc);
    }

    public void addPutfield(String classname, String name2, String desc) {
        this.addPutfield0(null, classname, name2, desc);
    }

    private void addPutfield0(CtClass target, String classname, String name2, String desc) {
        this.add(181);
        int ci = classname == null ? this.constPool.addClassInfo(target) : this.constPool.addClassInfo(classname);
        this.addIndex(this.constPool.addFieldrefInfo(ci, name2, desc));
        this.growStack(-1 - Descriptor.dataSize(desc));
    }

    public void addPutstatic(CtClass c, String name2, String desc) {
        this.addPutstatic0(c, null, name2, desc);
    }

    public void addPutstatic(String classname, String fieldName, String desc) {
        this.addPutstatic0(null, classname, fieldName, desc);
    }

    private void addPutstatic0(CtClass target, String classname, String fieldName, String desc) {
        this.add(179);
        int ci = classname == null ? this.constPool.addClassInfo(target) : this.constPool.addClassInfo(classname);
        this.addIndex(this.constPool.addFieldrefInfo(ci, fieldName, desc));
        this.growStack(-Descriptor.dataSize(desc));
    }

    public void addReturn(CtClass type) {
        if (type == null) {
            this.addOpcode(177);
        } else if (type.isPrimitive()) {
            CtPrimitiveType ptype = (CtPrimitiveType)type;
            this.addOpcode(ptype.getReturnOp());
        } else {
            this.addOpcode(176);
        }
    }

    public void addRet(int var) {
        if (var < 256) {
            this.addOpcode(169);
            this.add(var);
        } else {
            this.addOpcode(196);
            this.addOpcode(169);
            this.addIndex(var);
        }
    }

    public void addPrintln(String message) {
        this.addGetstatic("java.lang.System", "err", "Ljava/io/PrintStream;");
        this.addLdc(message);
        this.addInvokevirtual("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
    }
}

