/*
 * Decompiled with CFR 0.152.
 */
package javassist.compiler.ast;

import javassist.compiler.CompileError;
import javassist.compiler.TokenId;
import javassist.compiler.ast.ASTList;
import javassist.compiler.ast.ASTree;
import javassist.compiler.ast.Symbol;
import javassist.compiler.ast.Visitor;

public class Declarator
extends ASTList
implements TokenId {
    protected int varType;
    protected int arrayDim;
    protected int localVar;
    protected String qualifiedClass;

    public Declarator(int type, int dim) {
        super(null);
        this.varType = type;
        this.arrayDim = dim;
        this.localVar = -1;
        this.qualifiedClass = null;
    }

    public Declarator(ASTList className, int dim) {
        super(null);
        this.varType = 307;
        this.arrayDim = dim;
        this.localVar = -1;
        this.qualifiedClass = Declarator.astToClassName(className, '/');
    }

    public Declarator(int type, String jvmClassName, int dim, int var, Symbol sym2) {
        super(null);
        this.varType = type;
        this.arrayDim = dim;
        this.localVar = var;
        this.qualifiedClass = jvmClassName;
        this.setLeft(sym2);
        Declarator.append(this, null);
    }

    public Declarator make(Symbol sym2, int dim, ASTree init2) {
        Declarator d = new Declarator(this.varType, this.arrayDim + dim);
        d.qualifiedClass = this.qualifiedClass;
        d.setLeft(sym2);
        Declarator.append(d, init2);
        return d;
    }

    public int getType() {
        return this.varType;
    }

    public int getArrayDim() {
        return this.arrayDim;
    }

    public void addArrayDim(int d) {
        this.arrayDim += d;
    }

    public String getClassName() {
        return this.qualifiedClass;
    }

    public void setClassName(String s2) {
        this.qualifiedClass = s2;
    }

    public Symbol getVariable() {
        return (Symbol)this.getLeft();
    }

    public void setVariable(Symbol sym2) {
        this.setLeft(sym2);
    }

    public ASTree getInitializer() {
        ASTList t = this.tail();
        if (t != null) {
            return t.head();
        }
        return null;
    }

    public void setLocalVar(int n) {
        this.localVar = n;
    }

    public int getLocalVar() {
        return this.localVar;
    }

    @Override
    public String getTag() {
        return "decl";
    }

    @Override
    public void accept(Visitor v) throws CompileError {
        v.atDeclarator(this);
    }

    public static String astToClassName(ASTList name2, char sep) {
        if (name2 == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        Declarator.astToClassName(sbuf, name2, sep);
        return sbuf.toString();
    }

    private static void astToClassName(StringBuffer sbuf, ASTList name2, char sep) {
        while (true) {
            ASTree h2;
            if ((h2 = name2.head()) instanceof Symbol) {
                sbuf.append(((Symbol)h2).get());
            } else if (h2 instanceof ASTList) {
                Declarator.astToClassName(sbuf, (ASTList)h2, sep);
            }
            name2 = name2.tail();
            if (name2 == null) break;
            sbuf.append(sep);
        }
    }
}

