/*
 * Decompiled with CFR 0.152.
 */
package javassist.tools.reflect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javassist.tools.reflect.CannotCreateException;
import javassist.tools.reflect.CannotInvokeException;

public class ClassMetaobject
implements Serializable {
    static final String methodPrefix = "_m_";
    static final int methodPrefixLen = 3;
    private Class javaClass;
    private Constructor[] constructors;
    private Method[] methods;
    public static boolean useContextClassLoader = false;

    public ClassMetaobject(String[] params2) {
        try {
            this.javaClass = this.getClassObject(params2[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("not found: " + params2[0] + ", useContextClassLoader: " + Boolean.toString(useContextClassLoader), e);
        }
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.javaClass.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.javaClass = this.getClassObject(in.readUTF());
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    private Class getClassObject(String name2) throws ClassNotFoundException {
        if (useContextClassLoader) {
            return Thread.currentThread().getContextClassLoader().loadClass(name2);
        }
        return Class.forName(name2);
    }

    public final Class getJavaClass() {
        return this.javaClass;
    }

    public final String getName() {
        return this.javaClass.getName();
    }

    public final boolean isInstance(Object obj2) {
        return this.javaClass.isInstance(obj2);
    }

    public final Object newInstance(Object[] args) throws CannotCreateException {
        int n = this.constructors.length;
        for (int i = 0; i < n; ++i) {
            try {
                return this.constructors[i].newInstance(args);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (InstantiationException e) {
                throw new CannotCreateException(e);
            }
            catch (IllegalAccessException e) {
                throw new CannotCreateException(e);
            }
            catch (InvocationTargetException e) {
                throw new CannotCreateException(e);
            }
        }
        throw new CannotCreateException("no constructor matches");
    }

    public Object trapFieldRead(String name2) {
        Class jc = this.getJavaClass();
        try {
            return jc.getField(name2).get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void trapFieldWrite(String name2, Object value2) {
        Class jc = this.getJavaClass();
        try {
            jc.getField(name2).set(null, value2);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static Object invoke(Object target, int identifier2, Object[] args) throws Throwable {
        Method[] allmethods = target.getClass().getMethods();
        int n = allmethods.length;
        String head2 = methodPrefix + identifier2;
        for (int i = 0; i < n; ++i) {
            if (!allmethods[i].getName().startsWith(head2)) continue;
            try {
                return allmethods[i].invoke(target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (IllegalAccessException e) {
                throw new CannotInvokeException(e);
            }
        }
        throw new CannotInvokeException("cannot find a method");
    }

    public Object trapMethodcall(int identifier2, Object[] args) throws Throwable {
        try {
            Method[] m = this.getReflectiveMethods();
            return m[identifier2].invoke(null, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw new CannotInvokeException(e);
        }
    }

    public final Method[] getReflectiveMethods() {
        int i;
        if (this.methods != null) {
            return this.methods;
        }
        Class baseclass = this.getJavaClass();
        Method[] allmethods = baseclass.getDeclaredMethods();
        int n = allmethods.length;
        int[] index2 = new int[n];
        int max2 = 0;
        for (i = 0; i < n; ++i) {
            char c;
            Method m = allmethods[i];
            String mname = m.getName();
            if (!mname.startsWith(methodPrefix)) continue;
            int k = 0;
            int j = 3;
            while ('0' <= (c = mname.charAt(j)) && c <= '9') {
                k = k * 10 + c - 48;
                ++j;
            }
            index2[i] = ++k;
            if (k <= max2) continue;
            max2 = k;
        }
        this.methods = new Method[max2];
        for (i = 0; i < n; ++i) {
            if (index2[i] <= 0) continue;
            this.methods[index2[i] - 1] = allmethods[i];
        }
        return this.methods;
    }

    public final Method getMethod(int identifier2) {
        return this.getReflectiveMethods()[identifier2];
    }

    public final String getMethodName(int identifier2) {
        char c;
        String mname = this.getReflectiveMethods()[identifier2].getName();
        int j = 3;
        while ((c = mname.charAt(j++)) >= '0' && '9' >= c) {
        }
        return mname.substring(j);
    }

    public final Class[] getParameterTypes(int identifier2) {
        return this.getReflectiveMethods()[identifier2].getParameterTypes();
    }

    public final Class getReturnType(int identifier2) {
        return this.getReflectiveMethods()[identifier2].getReturnType();
    }

    public final int getMethodIndex(String originalName, Class[] argTypes) throws NoSuchMethodException {
        Method[] mthds = this.getReflectiveMethods();
        for (int i = 0; i < mthds.length; ++i) {
            if (mthds[i] == null || !this.getMethodName(i).equals(originalName) || !Arrays.equals(argTypes, mthds[i].getParameterTypes())) continue;
            return i;
        }
        throw new NoSuchMethodException("Method " + originalName + " not found");
    }
}

