/*
 * Decompiled with CFR 0.152.
 */
package javassist.tools.reflect;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.Translator;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.tools.reflect.CannotReflectException;

public class Reflection
implements Translator {
    static final String classobjectField = "_classobject";
    static final String classobjectAccessor = "_getClass";
    static final String metaobjectField = "_metaobject";
    static final String metaobjectGetter = "_getMetaobject";
    static final String metaobjectSetter = "_setMetaobject";
    static final String readPrefix = "_r_";
    static final String writePrefix = "_w_";
    static final String metaobjectClassName = "javassist.tools.reflect.Metaobject";
    static final String classMetaobjectClassName = "javassist.tools.reflect.ClassMetaobject";
    protected CtMethod trapMethod;
    protected CtMethod trapStaticMethod;
    protected CtMethod trapRead;
    protected CtMethod trapWrite;
    protected CtClass[] readParam;
    protected ClassPool classPool = null;
    protected CodeConverter converter = new CodeConverter();

    private boolean isExcluded(String name2) {
        return name2.startsWith("_m_") || name2.equals(classobjectAccessor) || name2.equals(metaobjectSetter) || name2.equals(metaobjectGetter) || name2.startsWith(readPrefix) || name2.startsWith(writePrefix);
    }

    @Override
    public void start(ClassPool pool) throws NotFoundException {
        this.classPool = pool;
        String msg = "javassist.tools.reflect.Sample is not found or broken.";
        try {
            CtClass c = this.classPool.get("javassist.tools.reflect.Sample");
            this.rebuildClassFile(c.getClassFile());
            this.trapMethod = c.getDeclaredMethod("trap");
            this.trapStaticMethod = c.getDeclaredMethod("trapStatic");
            this.trapRead = c.getDeclaredMethod("trapRead");
            this.trapWrite = c.getDeclaredMethod("trapWrite");
            this.readParam = new CtClass[]{this.classPool.get("java.lang.Object")};
        }
        catch (NotFoundException e) {
            throw new RuntimeException("javassist.tools.reflect.Sample is not found or broken.");
        }
        catch (BadBytecode e) {
            throw new RuntimeException("javassist.tools.reflect.Sample is not found or broken.");
        }
    }

    @Override
    public void onLoad(ClassPool pool, String classname) throws CannotCompileException, NotFoundException {
        CtClass clazz = pool.get(classname);
        clazz.instrument(this.converter);
    }

    public boolean makeReflective(String classname, String metaobject, String metaclass) throws CannotCompileException, NotFoundException {
        return this.makeReflective(this.classPool.get(classname), this.classPool.get(metaobject), this.classPool.get(metaclass));
    }

    public boolean makeReflective(Class clazz, Class metaobject, Class metaclass) throws CannotCompileException, NotFoundException {
        return this.makeReflective(clazz.getName(), metaobject.getName(), metaclass.getName());
    }

    public boolean makeReflective(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, CannotReflectException, NotFoundException {
        if (clazz.isInterface()) {
            throw new CannotReflectException("Cannot reflect an interface: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(classMetaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of ClassMetaobject: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(metaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of Metaobject: " + clazz.getName());
        }
        this.registerReflectiveClass(clazz);
        return this.modifyClassfile(clazz, metaobject, metaclass);
    }

    private void registerReflectiveClass(CtClass clazz) {
        CtField[] fs = clazz.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            CtField f2 = fs[i];
            int mod = f2.getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name2 = f2.getName();
            this.converter.replaceFieldRead(f2, clazz, readPrefix + name2);
            this.converter.replaceFieldWrite(f2, clazz, writePrefix + name2);
        }
    }

    private boolean modifyClassfile(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, NotFoundException {
        CtField f2;
        boolean addMeta;
        if (clazz.getAttribute("Reflective") != null) {
            return false;
        }
        clazz.setAttribute("Reflective", new byte[0]);
        CtClass mlevel = this.classPool.get("javassist.tools.reflect.Metalevel");
        boolean bl = addMeta = !clazz.subtypeOf(mlevel);
        if (addMeta) {
            clazz.addInterface(mlevel);
        }
        this.processMethods(clazz, addMeta);
        this.processFields(clazz);
        if (addMeta) {
            f2 = new CtField(this.classPool.get(metaobjectClassName), metaobjectField, clazz);
            f2.setModifiers(4);
            clazz.addField(f2, CtField.Initializer.byNewWithParams(metaobject));
            clazz.addMethod(CtNewMethod.getter(metaobjectGetter, f2));
            clazz.addMethod(CtNewMethod.setter(metaobjectSetter, f2));
        }
        f2 = new CtField(this.classPool.get(classMetaobjectClassName), classobjectField, clazz);
        f2.setModifiers(10);
        clazz.addField(f2, CtField.Initializer.byNew(metaclass, new String[]{clazz.getName()}));
        clazz.addMethod(CtNewMethod.getter(classobjectAccessor, f2));
        return true;
    }

    private void processMethods(CtClass clazz, boolean dontSearch) throws CannotCompileException, NotFoundException {
        CtMethod[] ms = clazz.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            CtMethod m = ms[i];
            int mod = m.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isAbstract(mod)) continue;
            this.processMethods0(mod, clazz, m, i, dontSearch);
        }
    }

    private void processMethods0(int mod, CtClass clazz, CtMethod m, int identifier2, boolean dontSearch) throws CannotCompileException, NotFoundException {
        CtMethod m2;
        String name2 = m.getName();
        if (this.isExcluded(name2)) {
            return;
        }
        if (m.getDeclaringClass() == clazz) {
            if (Modifier.isNative(mod)) {
                return;
            }
            m2 = m;
            if (Modifier.isFinal(mod)) {
                m2.setModifiers(mod &= 0xFFFFFFEF);
            }
        } else {
            if (Modifier.isFinal(mod)) {
                return;
            }
            m2 = CtNewMethod.delegator(this.findOriginal(m, dontSearch), clazz);
            m2.setModifiers(mod &= 0xFFFFFEFF);
            clazz.addMethod(m2);
        }
        m2.setName("_m_" + identifier2 + "_" + name2);
        CtMethod body2 = Modifier.isStatic(mod) ? this.trapStaticMethod : this.trapMethod;
        CtMethod wmethod = CtNewMethod.wrapped(m.getReturnType(), name2, m.getParameterTypes(), m.getExceptionTypes(), body2, CtMethod.ConstParameter.integer(identifier2), clazz);
        wmethod.setModifiers(mod);
        clazz.addMethod(wmethod);
    }

    private CtMethod findOriginal(CtMethod m, boolean dontSearch) throws NotFoundException {
        if (dontSearch) {
            return m;
        }
        String name2 = m.getName();
        CtMethod[] ms = m.getDeclaringClass().getDeclaredMethods();
        for (int i = 0; i < ms.length; ++i) {
            String orgName = ms[i].getName();
            if (!orgName.endsWith(name2) || !orgName.startsWith("_m_") || !ms[i].getSignature().equals(m.getSignature())) continue;
            return ms[i];
        }
        return m;
    }

    private void processFields(CtClass clazz) throws CannotCompileException, NotFoundException {
        CtField[] fs = clazz.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            CtField f2 = fs[i];
            int mod = f2.getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name2 = f2.getName();
            CtClass ftype = f2.getType();
            CtMethod wmethod = CtNewMethod.wrapped(ftype, readPrefix + name2, this.readParam, null, this.trapRead, CtMethod.ConstParameter.string(name2), clazz);
            wmethod.setModifiers(mod |= 8);
            clazz.addMethod(wmethod);
            CtClass[] writeParam = new CtClass[]{this.classPool.get("java.lang.Object"), ftype};
            wmethod = CtNewMethod.wrapped(CtClass.voidType, writePrefix + name2, writeParam, null, this.trapWrite, CtMethod.ConstParameter.string(name2), clazz);
            wmethod.setModifiers(mod);
            clazz.addMethod(wmethod);
        }
    }

    public void rebuildClassFile(ClassFile cf) throws BadBytecode {
        if (ClassFile.MAJOR_VERSION < 50) {
            return;
        }
        for (MethodInfo mi : cf.getMethods()) {
            mi.rebuildStackMap(this.classPool);
        }
    }
}

