/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.basic;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oauth.signpost.http.HttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpURLConnectionRequestAdapter
implements HttpRequest {
    protected HttpURLConnection connection;

    public HttpURLConnectionRequestAdapter(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public String getMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public String getRequestUrl() {
        return this.connection.getURL().toExternalForm();
    }

    @Override
    public void setRequestUrl(String url) {
    }

    @Override
    public void setHeader(String name2, String value2) {
        this.connection.setRequestProperty(name2, value2);
    }

    @Override
    public String getHeader(String name2) {
        return this.connection.getRequestProperty(name2);
    }

    @Override
    public Map<String, String> getAllHeaders() {
        Map<String, List<String>> origHeaders = this.connection.getRequestProperties();
        HashMap<String, String> headers2 = new HashMap<String, String>(origHeaders.size());
        for (String name2 : origHeaders.keySet()) {
            List<String> values2 = origHeaders.get(name2);
            if (values2.isEmpty()) continue;
            headers2.put(name2, values2.get(0));
        }
        return headers2;
    }

    @Override
    public InputStream getMessagePayload() throws IOException {
        return null;
    }

    @Override
    public String getContentType() {
        return this.connection.getRequestProperty("Content-Type");
    }

    @Override
    public HttpURLConnection unwrap() {
        return this.connection;
    }
}

