/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.commonshttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import oauth.signpost.http.HttpRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestAdapter
implements HttpRequest {
    private HttpUriRequest request;
    private HttpEntity entity;

    public HttpRequestAdapter(HttpUriRequest request) {
        this.request = request;
        if (request instanceof HttpEntityEnclosingRequest) {
            this.entity = ((HttpEntityEnclosingRequest)((Object)request)).getEntity();
        }
    }

    @Override
    public String getMethod() {
        return this.request.getRequestLine().getMethod();
    }

    @Override
    public String getRequestUrl() {
        return this.request.getURI().toString();
    }

    @Override
    public void setRequestUrl(String url) {
        throw new RuntimeException(new UnsupportedOperationException());
    }

    @Override
    public String getHeader(String name2) {
        Header header2 = this.request.getFirstHeader(name2);
        if (header2 == null) {
            return null;
        }
        return header2.getValue();
    }

    @Override
    public void setHeader(String name2, String value2) {
        this.request.setHeader(name2, value2);
    }

    @Override
    public Map<String, String> getAllHeaders() {
        Header[] origHeaders = this.request.getAllHeaders();
        HashMap<String, String> headers2 = new HashMap<String, String>();
        for (Header h2 : origHeaders) {
            headers2.put(h2.getName(), h2.getValue());
        }
        return headers2;
    }

    @Override
    public String getContentType() {
        if (this.entity == null) {
            return null;
        }
        Header header2 = this.entity.getContentType();
        if (header2 == null) {
            return null;
        }
        return header2.getValue();
    }

    @Override
    public InputStream getMessagePayload() throws IOException {
        if (this.entity == null) {
            return null;
        }
        return this.entity.getContent();
    }

    @Override
    public Object unwrap() {
        return this.request;
    }
}

