/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.util.Iterator;
import oauth.signpost.OAuth;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.SigningStrategy;

public class AuthorizationHeaderSigningStrategy
implements SigningStrategy {
    private static final long serialVersionUID = 1L;

    public String writeSignature(String signature, HttpRequest request, HttpParameters requestParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth ");
        if (requestParameters.containsKey("realm")) {
            sb.append(requestParameters.getAsHeaderElement("realm"));
            sb.append(", ");
        }
        HttpParameters oauthParams = requestParameters.getOAuthParameters();
        oauthParams.put("oauth_signature", signature, true);
        Iterator<String> iter2 = oauthParams.keySet().iterator();
        while (iter2.hasNext()) {
            String key = iter2.next();
            sb.append(oauthParams.getAsHeaderElement(key));
            if (!iter2.hasNext()) continue;
            sb.append(", ");
        }
        String header2 = sb.toString();
        OAuth.debugOut("Auth Header", header2);
        request.setHeader("Authorization", header2);
        return header2;
    }
}

