/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.util.Iterator;
import oauth.signpost.OAuth;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.SigningStrategy;

public class QueryStringSigningStrategy
implements SigningStrategy {
    private static final long serialVersionUID = 1L;

    public String writeSignature(String signature, HttpRequest request, HttpParameters requestParameters) {
        HttpParameters oauthParams = requestParameters.getOAuthParameters();
        oauthParams.put("oauth_signature", signature, true);
        Iterator<String> iter2 = oauthParams.keySet().iterator();
        String firstKey = iter2.next();
        StringBuilder sb = new StringBuilder(OAuth.addQueryString(request.getRequestUrl(), oauthParams.getAsQueryString(firstKey)));
        while (iter2.hasNext()) {
            sb.append("&");
            String key = iter2.next();
            sb.append(oauthParams.getAsQueryString(key));
        }
        String signedUrl = sb.toString();
        request.setRequestUrl(signedUrl);
        return signedUrl;
    }
}

