/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import oauth.signpost.OAuth;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;

public class SignatureBaseString {
    private HttpRequest request;
    private HttpParameters requestParameters;

    public SignatureBaseString(HttpRequest request, HttpParameters requestParameters) {
        this.request = request;
        this.requestParameters = requestParameters;
    }

    public String generate() throws OAuthMessageSignerException {
        try {
            String normalizedUrl = this.normalizeRequestUrl();
            String normalizedParams = this.normalizeRequestParameters();
            return this.request.getMethod() + '&' + OAuth.percentEncode(normalizedUrl) + '&' + OAuth.percentEncode(normalizedParams);
        }
        catch (Exception e) {
            throw new OAuthMessageSignerException(e);
        }
    }

    public String normalizeRequestUrl() throws URISyntaxException {
        String path2;
        int index2;
        boolean dropPort;
        URI uri = new URI(this.request.getRequestUrl());
        String scheme2 = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme2.equals("http") && uri.getPort() == 80 || scheme2.equals("https") && uri.getPort() == 443;
        if (dropPort && (index2 = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index2);
        }
        if ((path2 = uri.getRawPath()) == null || path2.length() <= 0) {
            path2 = "/";
        }
        return scheme2 + "://" + authority + path2;
    }

    public String normalizeRequestParameters() throws IOException {
        if (this.requestParameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter2 = this.requestParameters.keySet().iterator();
        int i = 0;
        while (iter2.hasNext()) {
            String param2 = iter2.next();
            if (!"oauth_signature".equals(param2) && !"realm".equals(param2)) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(this.requestParameters.getAsQueryString(param2, false));
            }
            ++i;
        }
        return sb.toString();
    }
}

