/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.Utils;

public class QuotedPrintableCodec
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    private final Charset charset;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;

    public QuotedPrintableCodec() {
        this(Charsets.UTF_8);
    }

    public QuotedPrintableCodec(Charset charset2) {
        this.charset = charset2;
    }

    public QuotedPrintableCodec(String charsetName) throws IllegalCharsetNameException, IllegalArgumentException, UnsupportedCharsetException {
        this(Charset.forName(charsetName));
    }

    private static final void encodeQuotedPrintable(int b, ByteArrayOutputStream buffer2) {
        buffer2.write(61);
        char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
        char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
        buffer2.write(hex1);
        buffer2.write(hex2);
    }

    public static final byte[] encodeQuotedPrintable(BitSet printable, byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        if (printable == null) {
            printable = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream buffer2 = new ByteArrayOutputStream();
        for (int n : bytes2) {
            int b = n;
            if (b < 0) {
                b = 256 + b;
            }
            if (printable.get(b)) {
                buffer2.write(b);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(b, buffer2);
        }
        return buffer2.toByteArray();
    }

    public static final byte[] decodeQuotedPrintable(byte[] bytes2) throws DecoderException {
        if (bytes2 == null) {
            return null;
        }
        ByteArrayOutputStream buffer2 = new ByteArrayOutputStream();
        for (int i = 0; i < bytes2.length; ++i) {
            byte b = bytes2[i];
            if (b == 61) {
                try {
                    int u = Utils.digit16(bytes2[++i]);
                    int l = Utils.digit16(bytes2[++i]);
                    buffer2.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException("Invalid quoted-printable encoding", e);
                }
            }
            buffer2.write(b);
        }
        return buffer2.toByteArray();
    }

    @Override
    public byte[] encode(byte[] bytes2) {
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, bytes2);
    }

    @Override
    public byte[] decode(byte[] bytes2) throws DecoderException {
        return QuotedPrintableCodec.decodeQuotedPrintable(bytes2);
    }

    @Override
    public String encode(String str) throws EncoderException {
        return this.encode(str, this.getCharset());
    }

    public String decode(String str, Charset charset2) throws DecoderException {
        if (str == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(str)), charset2);
    }

    public String decode(String str, String charset2) throws DecoderException, UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(str)), charset2);
    }

    @Override
    public String decode(String str) throws DecoderException {
        return this.decode(str, this.getCharset());
    }

    @Override
    public Object encode(Object obj2) throws EncoderException {
        if (obj2 == null) {
            return null;
        }
        if (obj2 instanceof byte[]) {
            return this.encode((byte[])obj2);
        }
        if (obj2 instanceof String) {
            return this.encode((String)obj2);
        }
        throw new EncoderException("Objects of type " + obj2.getClass().getName() + " cannot be quoted-printable encoded");
    }

    @Override
    public Object decode(Object obj2) throws DecoderException {
        if (obj2 == null) {
            return null;
        }
        if (obj2 instanceof byte[]) {
            return this.decode((byte[])obj2);
        }
        if (obj2 instanceof String) {
            return this.decode((String)obj2);
        }
        throw new DecoderException("Objects of type " + obj2.getClass().getName() + " cannot be quoted-printable decoded");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    public String encode(String str, Charset charset2) {
        if (str == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(str.getBytes(charset2)));
    }

    public String encode(String str, String charset2) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(str.getBytes(charset2)));
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 33; i <= 60; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 62; i <= 126; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

