/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.StringUtils;

abstract class RFC1522Codec {
    protected static final char SEP = '?';
    protected static final String POSTFIX = "?=";
    protected static final String PREFIX = "=?";

    RFC1522Codec() {
    }

    protected String encodeText(String text2, Charset charset2) throws EncoderException {
        if (text2 == null) {
            return null;
        }
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append(PREFIX);
        buffer2.append(charset2);
        buffer2.append('?');
        buffer2.append(this.getEncoding());
        buffer2.append('?');
        byte[] rawData = this.doEncoding(text2.getBytes(charset2));
        buffer2.append(StringUtils.newStringUsAscii(rawData));
        buffer2.append(POSTFIX);
        return buffer2.toString();
    }

    protected String encodeText(String text2, String charsetName) throws EncoderException, UnsupportedEncodingException {
        if (text2 == null) {
            return null;
        }
        return this.encodeText(text2, Charset.forName(charsetName));
    }

    protected String decodeText(String text2) throws DecoderException, UnsupportedEncodingException {
        if (text2 == null) {
            return null;
        }
        if (!text2.startsWith(PREFIX) || !text2.endsWith(POSTFIX)) {
            throw new DecoderException("RFC 1522 violation: malformed encoded content");
        }
        int terminator = text2.length() - 2;
        int from2 = 2;
        int to2 = text2.indexOf(63, from2);
        if (to2 == terminator) {
            throw new DecoderException("RFC 1522 violation: charset token not found");
        }
        String charset2 = text2.substring(from2, to2);
        if (charset2.equals("")) {
            throw new DecoderException("RFC 1522 violation: charset not specified");
        }
        from2 = to2 + 1;
        if ((to2 = text2.indexOf(63, from2)) == terminator) {
            throw new DecoderException("RFC 1522 violation: encoding token not found");
        }
        String encoding = text2.substring(from2, to2);
        if (!this.getEncoding().equalsIgnoreCase(encoding)) {
            throw new DecoderException("This codec cannot decode " + encoding + " encoded content");
        }
        from2 = to2 + 1;
        to2 = text2.indexOf(63, from2);
        byte[] data = StringUtils.getBytesUsAscii(text2.substring(from2, to2));
        data = this.doDecoding(data);
        return new String(data, charset2);
    }

    protected abstract String getEncoding();

    protected abstract byte[] doEncoding(byte[] var1) throws EncoderException;

    protected abstract byte[] doDecoding(byte[] var1) throws DecoderException;
}

