/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.Utils;

public class URLCodec
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    static final int RADIX = 16;
    @Deprecated
    protected String charset;
    protected static final byte ESCAPE_CHAR = 37;
    protected static final BitSet WWW_FORM_URL;

    public URLCodec() {
        this("UTF-8");
    }

    public URLCodec(String charset2) {
        this.charset = charset2;
    }

    public static final byte[] encodeUrl(BitSet urlsafe, byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        if (urlsafe == null) {
            urlsafe = WWW_FORM_URL;
        }
        ByteArrayOutputStream buffer2 = new ByteArrayOutputStream();
        for (int n : bytes2) {
            int b = n;
            if (b < 0) {
                b = 256 + b;
            }
            if (urlsafe.get(b)) {
                if (b == 32) {
                    b = 43;
                }
                buffer2.write(b);
                continue;
            }
            buffer2.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buffer2.write(hex1);
            buffer2.write(hex2);
        }
        return buffer2.toByteArray();
    }

    public static final byte[] decodeUrl(byte[] bytes2) throws DecoderException {
        if (bytes2 == null) {
            return null;
        }
        ByteArrayOutputStream buffer2 = new ByteArrayOutputStream();
        for (int i = 0; i < bytes2.length; ++i) {
            byte b = bytes2[i];
            if (b == 43) {
                buffer2.write(32);
                continue;
            }
            if (b == 37) {
                try {
                    int u = Utils.digit16(bytes2[++i]);
                    int l = Utils.digit16(bytes2[++i]);
                    buffer2.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException("Invalid URL encoding: ", e);
                }
            }
            buffer2.write(b);
        }
        return buffer2.toByteArray();
    }

    @Override
    public byte[] encode(byte[] bytes2) {
        return URLCodec.encodeUrl(WWW_FORM_URL, bytes2);
    }

    @Override
    public byte[] decode(byte[] bytes2) throws DecoderException {
        return URLCodec.decodeUrl(bytes2);
    }

    public String encode(String str, String charset2) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(str.getBytes(charset2)));
    }

    @Override
    public String encode(String str) throws EncoderException {
        if (str == null) {
            return null;
        }
        try {
            return this.encode(str, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e.getMessage(), e);
        }
    }

    public String decode(String str, String charset2) throws DecoderException, UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(str)), charset2);
    }

    @Override
    public String decode(String str) throws DecoderException {
        if (str == null) {
            return null;
        }
        try {
            return this.decode(str, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new DecoderException(e.getMessage(), e);
        }
    }

    @Override
    public Object encode(Object obj2) throws EncoderException {
        if (obj2 == null) {
            return null;
        }
        if (obj2 instanceof byte[]) {
            return this.encode((byte[])obj2);
        }
        if (obj2 instanceof String) {
            return this.encode((String)obj2);
        }
        throw new EncoderException("Objects of type " + obj2.getClass().getName() + " cannot be URL encoded");
    }

    @Override
    public Object decode(Object obj2) throws DecoderException {
        if (obj2 == null) {
            return null;
        }
        if (obj2 instanceof byte[]) {
            return this.decode((byte[])obj2);
        }
        if (obj2 instanceof String) {
            return this.decode((String)obj2);
        }
        throw new DecoderException("Objects of type " + obj2.getClass().getName() + " cannot be URL decoded");
    }

    public String getDefaultCharset() {
        return this.charset;
    }

    @Deprecated
    public String getEncoding() {
        return this.charset;
    }

    static {
        int i;
        WWW_FORM_URL = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            WWW_FORM_URL.set(i);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
        WWW_FORM_URL.set(32);
    }
}

