/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringBuilder
implements Builder<String> {
    private static volatile ToStringStyle defaultStyle = ToStringStyle.DEFAULT_STYLE;
    private final StringBuffer buffer;
    private final Object object;
    private final ToStringStyle style;

    public static ToStringStyle getDefaultStyle() {
        return defaultStyle;
    }

    public static void setDefaultStyle(ToStringStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("The style must not be null");
        }
        defaultStyle = style;
    }

    public static String reflectionToString(Object object) {
        return ReflectionToStringBuilder.toString(object);
    }

    public static String reflectionToString(Object object, ToStringStyle style) {
        return ReflectionToStringBuilder.toString(object, style);
    }

    public static String reflectionToString(Object object, ToStringStyle style, boolean outputTransients) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, null);
    }

    public static <T> String reflectionToString(T object, ToStringStyle style, boolean outputTransients, Class<? super T> reflectUpToClass) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, reflectUpToClass);
    }

    public ToStringBuilder(Object object) {
        this(object, null, null);
    }

    public ToStringBuilder(Object object, ToStringStyle style) {
        this(object, style, null);
    }

    public ToStringBuilder(Object object, ToStringStyle style, StringBuffer buffer2) {
        if (style == null) {
            style = ToStringBuilder.getDefaultStyle();
        }
        if (buffer2 == null) {
            buffer2 = new StringBuffer(512);
        }
        this.buffer = buffer2;
        this.style = style;
        this.object = object;
        style.appendStart(buffer2, object);
    }

    public ToStringBuilder append(boolean value2) {
        this.style.append(this.buffer, null, value2);
        return this;
    }

    public ToStringBuilder append(boolean[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(byte value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(byte[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(char value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(char[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(double value2) {
        this.style.append(this.buffer, null, value2);
        return this;
    }

    public ToStringBuilder append(double[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(float value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(float[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(int value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(int[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(long value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(long[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(Object obj2) {
        this.style.append(this.buffer, null, obj2, null);
        return this;
    }

    public ToStringBuilder append(Object[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(short value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(short[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, boolean value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, boolean[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, boolean[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, byte value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, byte[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, byte[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, char value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, char[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, char[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, double value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, double[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, double[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, float value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, float[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, float[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, int value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, int[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, int[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, long value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, long[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, long[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object obj2) {
        this.style.append(this.buffer, fieldName, obj2, null);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object obj2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, obj2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName, short value2) {
        this.style.append(this.buffer, fieldName, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName, short[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, short[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder appendAsObjectToString(Object object) {
        ObjectUtils.identityToString(this.getStringBuffer(), object);
        return this;
    }

    public ToStringBuilder appendSuper(String superToString) {
        if (superToString != null) {
            this.style.appendSuper(this.buffer, superToString);
        }
        return this;
    }

    public ToStringBuilder appendToString(String toString2) {
        if (toString2 != null) {
            this.style.appendToString(this.buffer, toString2);
        }
        return this;
    }

    public Object getObject() {
        return this.object;
    }

    public StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public ToStringStyle getStyle() {
        return this.style;
    }

    public String toString() {
        if (this.getObject() == null) {
            this.getStringBuffer().append(this.getStyle().getNullText());
        } else {
            this.style.appendEnd(this.getStringBuffer(), this.getObject());
        }
        return this.getStringBuffer().toString();
    }

    @Override
    public String build() {
        return this.toString();
    }
}

