/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String label2, Object value2) {
        this.contextValues.add(new ImmutablePair<String, Object>(label2, value2));
        return this;
    }

    @Override
    public DefaultExceptionContext setContextValue(String label2, Object value2) {
        Iterator<Pair<String, Object>> iter2 = this.contextValues.iterator();
        while (iter2.hasNext()) {
            Pair<String, Object> p = iter2.next();
            if (!StringUtils.equals(label2, p.getKey())) continue;
            iter2.remove();
        }
        this.addContextValue(label2, value2);
        return this;
    }

    @Override
    public List<Object> getContextValues(String label2) {
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (Pair<String, Object> pair2 : this.contextValues) {
            if (!StringUtils.equals(label2, pair2.getKey())) continue;
            values2.add(pair2.getValue());
        }
        return values2;
    }

    @Override
    public Object getFirstContextValue(String label2) {
        for (Pair<String, Object> pair2 : this.contextValues) {
            if (!StringUtils.equals(label2, pair2.getKey())) continue;
            return pair2.getValue();
        }
        return null;
    }

    @Override
    public Set<String> getContextLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (Pair<String, Object> pair2 : this.contextValues) {
            labels.add(pair2.getKey());
        }
        return labels;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder buffer2 = new StringBuilder(256);
        if (baseMessage != null) {
            buffer2.append(baseMessage);
        }
        if (this.contextValues.size() > 0) {
            if (buffer2.length() > 0) {
                buffer2.append('\n');
            }
            buffer2.append("Exception Context:\n");
            int i = 0;
            for (Pair<String, Object> pair2 : this.contextValues) {
                buffer2.append("\t[");
                buffer2.append(++i);
                buffer2.append(':');
                buffer2.append(pair2.getKey());
                buffer2.append("=");
                Object value2 = pair2.getValue();
                if (value2 == null) {
                    buffer2.append("null");
                } else {
                    String valueStr;
                    try {
                        valueStr = value2.toString();
                    }
                    catch (Exception e) {
                        valueStr = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(e);
                    }
                    buffer2.append(valueStr);
                }
                buffer2.append("]\n");
            }
            buffer2.append("---------------------------------");
        }
        return buffer2.toString();
    }
}

