/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.Mutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableDouble
extends Number
implements Comparable<MutableDouble>,
Mutable<Number> {
    private static final long serialVersionUID = 1587163916L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value2) {
        this.value = value2;
    }

    public MutableDouble(Number value2) {
        this.value = value2.doubleValue();
    }

    public MutableDouble(String value2) throws NumberFormatException {
        this.value = Double.parseDouble(value2);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value2) {
        this.value = value2;
    }

    @Override
    public void setValue(Number value2) {
        this.value = value2.doubleValue();
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public void increment() {
        this.value += 1.0;
    }

    public void decrement() {
        this.value -= 1.0;
    }

    public void add(double operand) {
        this.value += operand;
    }

    public void add(Number operand) {
        this.value += operand.doubleValue();
    }

    public void subtract(double operand) {
        this.value -= operand;
    }

    public void subtract(Number operand) {
        this.value -= operand.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public Double toDouble() {
        return this.doubleValue();
    }

    public boolean equals(Object obj2) {
        return obj2 instanceof MutableDouble && Double.doubleToLongBits(((MutableDouble)obj2).value) == Double.doubleToLongBits(this.value);
    }

    public int hashCode() {
        long bits2 = Double.doubleToLongBits(this.value);
        return (int)(bits2 ^ bits2 >>> 32);
    }

    @Override
    public int compareTo(MutableDouble other) {
        double anotherVal = other.value;
        return Double.compare(this.value, anotherVal);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

