/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.commons.lang3.text.StrMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final int HASH_SEED = 31;
    private static final String DUMMY_PATTERN = "";
    private static final String ESCAPED_QUOTE = "''";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map<String, ? extends FormatFactory> registry;

    public ExtendedMessageFormat(String pattern2) {
        this(pattern2, Locale.getDefault());
    }

    public ExtendedMessageFormat(String pattern2, Locale locale) {
        this(pattern2, locale, null);
    }

    public ExtendedMessageFormat(String pattern2, Map<String, ? extends FormatFactory> registry) {
        this(pattern2, Locale.getDefault(), registry);
    }

    public ExtendedMessageFormat(String pattern2, Locale locale, Map<String, ? extends FormatFactory> registry) {
        super(DUMMY_PATTERN);
        this.setLocale(locale);
        this.registry = registry;
        this.applyPattern(pattern2);
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }

    @Override
    public final void applyPattern(String pattern2) {
        if (this.registry == null) {
            super.applyPattern(pattern2);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList<Format> foundFormats = new ArrayList<Format>();
        ArrayList<String> foundDescriptions = new ArrayList<String>();
        StringBuilder stripCustom = new StringBuilder(pattern2.length());
        ParsePosition pos = new ParsePosition(0);
        char[] c = pattern2.toCharArray();
        int fmtCount = 0;
        block4: while (pos.getIndex() < pattern2.length()) {
            switch (c[pos.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(pattern2, pos, stripCustom, true);
                    continue block4;
                }
                case '{': {
                    ++fmtCount;
                    this.seekNonWs(pattern2, pos);
                    int start2 = pos.getIndex();
                    int index2 = this.readArgumentIndex(pattern2, this.next(pos));
                    stripCustom.append('{').append(index2);
                    this.seekNonWs(pattern2, pos);
                    Format format2 = null;
                    String formatDescription = null;
                    if (c[pos.getIndex()] == ',' && (format2 = this.getFormat(formatDescription = this.parseFormatDescription(pattern2, this.next(pos)))) == null) {
                        stripCustom.append(',').append(formatDescription);
                    }
                    foundFormats.add(format2);
                    foundDescriptions.add(format2 == null ? null : formatDescription);
                    Validate.isTrue(foundFormats.size() == fmtCount);
                    Validate.isTrue(foundDescriptions.size() == fmtCount);
                    if (c[pos.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + start2);
                }
            }
            stripCustom.append(c[pos.getIndex()]);
            this.next(pos);
        }
        super.applyPattern(stripCustom.toString());
        this.toPattern = this.insertFormats(super.toPattern(), foundDescriptions);
        if (this.containsElements(foundFormats)) {
            Format[] origFormats = this.getFormats();
            int i = 0;
            for (Format f2 : foundFormats) {
                if (f2 != null) {
                    origFormats[i] = f2;
                }
                ++i;
            }
            super.setFormats(origFormats);
        }
    }

    @Override
    public void setFormat(int formatElementIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormats(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (!super.equals(obj2)) {
            return false;
        }
        if (ObjectUtils.notEqual(this.getClass(), obj2.getClass())) {
            return false;
        }
        ExtendedMessageFormat rhs = (ExtendedMessageFormat)obj2;
        if (ObjectUtils.notEqual(this.toPattern, rhs.toPattern)) {
            return false;
        }
        return !ObjectUtils.notEqual(this.registry, rhs.registry);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + ObjectUtils.hashCode(this.registry);
        result2 = 31 * result2 + ObjectUtils.hashCode(this.toPattern);
        return result2;
    }

    private Format getFormat(String desc) {
        if (this.registry != null) {
            FormatFactory factory;
            String name2 = desc;
            String args = null;
            int i = desc.indexOf(44);
            if (i > 0) {
                name2 = desc.substring(0, i).trim();
                args = desc.substring(i + 1).trim();
            }
            if ((factory = this.registry.get(name2)) != null) {
                return factory.getFormat(name2, args, this.getLocale());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String pattern, ParsePosition pos) {
        start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        result = new StringBuffer();
        error = false;
        while (!error && pos.getIndex() < pattern.length()) {
            c = pattern.charAt(pos.getIndex());
            if (!Character.isWhitespace(c)) ** GOTO lbl-1000
            this.seekNonWs(pattern, pos);
            c = pattern.charAt(pos.getIndex());
            if (c != ',' && c != '}') {
                error = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((c == ',' || c == '}') && result.length() > 0) {
                    try {
                        return Integer.parseInt(result.toString());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                error = Character.isDigit(c) == false;
                result.append(c);
            }
            this.next(pos);
        }
        if (error) {
            throw new IllegalArgumentException("Invalid format argument index at position " + start + ": " + pattern.substring(start, pos.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start);
    }

    private String parseFormatDescription(String pattern2, ParsePosition pos) {
        int start2 = pos.getIndex();
        this.seekNonWs(pattern2, pos);
        int text2 = pos.getIndex();
        int depth = 1;
        while (pos.getIndex() < pattern2.length()) {
            switch (pattern2.charAt(pos.getIndex())) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth != 0) break;
                    return pattern2.substring(text2, pos.getIndex());
                }
                case '\'': {
                    this.getQuotedString(pattern2, pos, false);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start2);
    }

    private String insertFormats(String pattern2, ArrayList<String> customPatterns) {
        if (!this.containsElements(customPatterns)) {
            return pattern2;
        }
        StringBuilder sb = new StringBuilder(pattern2.length() * 2);
        ParsePosition pos = new ParsePosition(0);
        int fe = -1;
        int depth = 0;
        block5: while (pos.getIndex() < pattern2.length()) {
            char c = pattern2.charAt(pos.getIndex());
            switch (c) {
                case '\'': {
                    this.appendQuotedString(pattern2, pos, sb, false);
                    break;
                }
                case '{': {
                    String customPattern;
                    if (++depth != 1) continue block5;
                    sb.append('{').append(this.readArgumentIndex(pattern2, this.next(pos)));
                    if ((customPattern = customPatterns.get(++fe)) == null) continue block5;
                    sb.append(',').append(customPattern);
                    break;
                }
                case '}': {
                    --depth;
                }
                default: {
                    sb.append(c);
                    this.next(pos);
                }
            }
        }
        return sb.toString();
    }

    private void seekNonWs(String pattern2, ParsePosition pos) {
        int len2 = 0;
        char[] buffer2 = pattern2.toCharArray();
        do {
            len2 = StrMatcher.splitMatcher().isMatch(buffer2, pos.getIndex());
            pos.setIndex(pos.getIndex() + len2);
        } while (len2 > 0 && pos.getIndex() < pattern2.length());
    }

    private ParsePosition next(ParsePosition pos) {
        pos.setIndex(pos.getIndex() + 1);
        return pos;
    }

    private StringBuilder appendQuotedString(String pattern2, ParsePosition pos, StringBuilder appendTo, boolean escapingOn) {
        int start2 = pos.getIndex();
        char[] c = pattern2.toCharArray();
        if (escapingOn && c[start2] == '\'') {
            this.next(pos);
            return appendTo == null ? null : appendTo.append('\'');
        }
        int lastHold = start2;
        for (int i = pos.getIndex(); i < pattern2.length(); ++i) {
            if (escapingOn && pattern2.substring(i).startsWith(ESCAPED_QUOTE)) {
                appendTo.append(c, lastHold, pos.getIndex() - lastHold).append('\'');
                pos.setIndex(i + ESCAPED_QUOTE.length());
                lastHold = pos.getIndex();
                continue;
            }
            switch (c[pos.getIndex()]) {
                case '\'': {
                    this.next(pos);
                    return appendTo == null ? null : appendTo.append(c, lastHold, pos.getIndex() - lastHold);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + start2);
    }

    private void getQuotedString(String pattern2, ParsePosition pos, boolean escapingOn) {
        this.appendQuotedString(pattern2, pos, null, escapingOn);
    }

    private boolean containsElements(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        for (Object name2 : coll) {
            if (name2 == null) continue;
            return true;
        }
        return false;
    }
}

