/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.io.Serializable;
import java.util.Locale;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.LangUtils;

public final class HttpHost
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7529410654042457626L;
    public static final String DEFAULT_SCHEME_NAME = "http";
    protected final String hostname;
    protected final String lcHostname;
    protected final int port;
    protected final String schemeName;

    public HttpHost(String hostname, int port, String scheme2) {
        if (hostname == null) {
            throw new IllegalArgumentException("Host name may not be null");
        }
        this.hostname = hostname;
        this.lcHostname = hostname.toLowerCase(Locale.ENGLISH);
        this.schemeName = scheme2 != null ? scheme2.toLowerCase(Locale.ENGLISH) : DEFAULT_SCHEME_NAME;
        this.port = port;
    }

    public HttpHost(String hostname, int port) {
        this(hostname, port, null);
    }

    public HttpHost(String hostname) {
        this(hostname, -1, null);
    }

    public HttpHost(HttpHost httphost) {
        this(httphost.hostname, httphost.port, httphost.schemeName);
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String toURI() {
        CharArrayBuffer buffer2 = new CharArrayBuffer(32);
        buffer2.append(this.schemeName);
        buffer2.append("://");
        buffer2.append(this.hostname);
        if (this.port != -1) {
            buffer2.append(':');
            buffer2.append(Integer.toString(this.port));
        }
        return buffer2.toString();
    }

    public String toHostString() {
        if (this.port != -1) {
            CharArrayBuffer buffer2 = new CharArrayBuffer(this.hostname.length() + 6);
            buffer2.append(this.hostname);
            buffer2.append(":");
            buffer2.append(Integer.toString(this.port));
            return buffer2.toString();
        }
        return this.hostname;
    }

    public String toString() {
        return this.toURI();
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 instanceof HttpHost) {
            HttpHost that = (HttpHost)obj2;
            return this.lcHostname.equals(that.lcHostname) && this.port == that.port && this.schemeName.equals(that.schemeName);
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = LangUtils.hashCode(hash2, this.lcHostname);
        hash2 = LangUtils.hashCode(hash2, this.port);
        hash2 = LangUtils.hashCode(hash2, this.schemeName);
        return hash2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

