/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTUserPrincipal;
import org.apache.http.util.LangUtils;

@Immutable
public class NTCredentials
implements Credentials,
Serializable {
    private static final long serialVersionUID = -7385699315228907265L;
    private final NTUserPrincipal principal;
    private final String password;
    private final String workstation;

    public NTCredentials(String usernamePassword) {
        String username2;
        if (usernamePassword == null) {
            throw new IllegalArgumentException("Username:password string may not be null");
        }
        int atColon = usernamePassword.indexOf(58);
        if (atColon >= 0) {
            username2 = usernamePassword.substring(0, atColon);
            this.password = usernamePassword.substring(atColon + 1);
        } else {
            username2 = usernamePassword;
            this.password = null;
        }
        int atSlash = username2.indexOf(47);
        this.principal = atSlash >= 0 ? new NTUserPrincipal(username2.substring(0, atSlash).toUpperCase(Locale.ENGLISH), username2.substring(atSlash + 1)) : new NTUserPrincipal(null, username2.substring(atSlash + 1));
        this.workstation = null;
    }

    public NTCredentials(String userName, String password, String workstation, String domain2) {
        if (userName == null) {
            throw new IllegalArgumentException("User name may not be null");
        }
        this.principal = new NTUserPrincipal(domain2, userName);
        this.password = password;
        this.workstation = workstation != null ? workstation.toUpperCase(Locale.ENGLISH) : null;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getUsername();
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.principal.getDomain();
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = LangUtils.hashCode(hash2, this.principal);
        hash2 = LangUtils.hashCode(hash2, this.workstation);
        return hash2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NTCredentials) {
            NTCredentials that = (NTCredentials)o;
            if (LangUtils.equals(this.principal, that.principal) && LangUtils.equals(this.workstation, that.workstation)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append("[principal: ");
        buffer2.append(this.principal);
        buffer2.append("][workstation: ");
        buffer2.append(this.workstation);
        buffer2.append("]");
        return buffer2.toString();
    }
}

