/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;

@Immutable
public class URIUtils {
    public static URI createURI(String scheme2, String host2, int port, String path2, String query, String fragment) throws URISyntaxException {
        StringBuilder buffer2 = new StringBuilder();
        if (host2 != null) {
            if (scheme2 != null) {
                buffer2.append(scheme2);
                buffer2.append("://");
            }
            buffer2.append(host2);
            if (port > 0) {
                buffer2.append(':');
                buffer2.append(port);
            }
        }
        if (path2 == null || !path2.startsWith("/")) {
            buffer2.append('/');
        }
        if (path2 != null) {
            buffer2.append(path2);
        }
        if (query != null) {
            buffer2.append('?');
            buffer2.append(query);
        }
        if (fragment != null) {
            buffer2.append('#');
            buffer2.append(fragment);
        }
        return new URI(buffer2.toString());
    }

    public static URI rewriteURI(URI uri, HttpHost target, boolean dropFragment) throws URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null");
        }
        if (target != null) {
            return URIUtils.createURI(target.getSchemeName(), target.getHostName(), target.getPort(), URIUtils.normalizePath(uri.getRawPath()), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
        }
        return URIUtils.createURI(null, null, -1, URIUtils.normalizePath(uri.getRawPath()), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
    }

    private static String normalizePath(String path2) {
        int n;
        if (path2 == null) {
            return null;
        }
        for (n = 0; n < path2.length() && path2.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            path2 = path2.substring(n - 1);
        }
        return path2;
    }

    public static URI rewriteURI(URI uri, HttpHost target) throws URISyntaxException {
        return URIUtils.rewriteURI(uri, target, false);
    }

    public static URI resolve(URI baseURI, String reference) {
        return URIUtils.resolve(baseURI, URI.create(reference));
    }

    public static URI resolve(URI baseURI, URI reference) {
        boolean emptyReference;
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI may nor be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Reference URI may nor be null");
        }
        String s2 = reference.toString();
        if (s2.startsWith("?")) {
            return URIUtils.resolveReferenceStartingWithQueryString(baseURI, reference);
        }
        boolean bl = emptyReference = s2.length() == 0;
        if (emptyReference) {
            reference = URI.create("#");
        }
        URI resolved = baseURI.resolve(reference);
        if (emptyReference) {
            String resolvedString = resolved.toString();
            resolved = URI.create(resolvedString.substring(0, resolvedString.indexOf(35)));
        }
        return URIUtils.removeDotSegments(resolved);
    }

    private static URI resolveReferenceStartingWithQueryString(URI baseURI, URI reference) {
        String baseUri = baseURI.toString();
        baseUri = baseUri.indexOf(63) > -1 ? baseUri.substring(0, baseUri.indexOf(63)) : baseUri;
        return URI.create(baseUri + reference.toString());
    }

    private static URI removeDotSegments(URI uri) {
        String path2 = uri.getPath();
        if (path2 == null || path2.indexOf("/.") == -1) {
            return uri;
        }
        String[] inputSegments = path2.split("/");
        Stack<String> outputSegments = new Stack<String>();
        for (int i = 0; i < inputSegments.length; ++i) {
            if (inputSegments[i].length() == 0 || ".".equals(inputSegments[i])) continue;
            if ("..".equals(inputSegments[i])) {
                if (outputSegments.isEmpty()) continue;
                outputSegments.pop();
                continue;
            }
            outputSegments.push(inputSegments[i]);
        }
        StringBuilder outputBuffer = new StringBuilder();
        for (String outputSegment : outputSegments) {
            outputBuffer.append('/').append(outputSegment);
        }
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), outputBuffer.toString(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static HttpHost extractHost(URI uri) {
        if (uri == null) {
            return null;
        }
        HttpHost target = null;
        if (uri.isAbsolute()) {
            int port = uri.getPort();
            String host2 = uri.getHost();
            if (host2 == null && (host2 = uri.getAuthority()) != null) {
                int colon2;
                int at2 = host2.indexOf(64);
                if (at2 >= 0) {
                    host2 = host2.length() > at2 + 1 ? host2.substring(at2 + 1) : null;
                }
                if (host2 != null && (colon2 = host2.indexOf(58)) >= 0) {
                    if (colon2 + 1 < host2.length()) {
                        port = Integer.parseInt(host2.substring(colon2 + 1));
                    }
                    host2 = host2.substring(0, colon2);
                }
            }
            String scheme2 = uri.getScheme();
            if (host2 != null) {
                target = new HttpHost(host2, port, scheme2);
            }
        }
        return target;
    }

    private URIUtils() {
    }
}

