/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;

@NotThreadSafe
public class BasicScheme
extends RFC2617Scheme {
    private boolean complete = false;

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(Header header2) throws MalformedChallengeException {
        super.processChallenge(header2);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String charset2 = AuthParams.getCredentialCharset(request.getParams());
        return BasicScheme.authenticate(credentials, charset2, this.isProxy());
    }

    public static Header authenticate(Credentials credentials, String charset2, boolean proxy) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (charset2 == null) {
            throw new IllegalArgumentException("charset may not be null");
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = Base64.encodeBase64(EncodingUtils.getBytes(tmp.toString(), charset2));
        CharArrayBuffer buffer2 = new CharArrayBuffer(32);
        if (proxy) {
            buffer2.append("Proxy-Authorization");
        } else {
            buffer2.append("Authorization");
        }
        buffer2.append(": Basic ");
        buffer2.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer2);
    }
}

