/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.auth.UnsupportedDigestAlgorithmException;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;

@NotThreadSafe
public class DigestScheme
extends RFC2617Scheme {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private boolean complete = false;
    private static final int QOP_UNKNOWN = -1;
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private String lastNonce;
    private long nounceCount;
    private String cnonce;
    private String a1;
    private String a2;

    public void processChallenge(Header header2) throws MalformedChallengeException {
        super.processChallenge(header2);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("missing realm in challenge");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("missing nonce in challenge");
        }
        this.complete = true;
    }

    public boolean isComplete() {
        String s2 = this.getParameter("stale");
        if ("true".equalsIgnoreCase(s2)) {
            return false;
        }
        return this.complete;
    }

    public String getSchemeName() {
        return "digest";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public void overrideParamter(String name2, String value2) {
        this.getParameters().put(name2, value2);
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.getParameters().put("methodname", request.getRequestLine().getMethod());
        this.getParameters().put("uri", request.getRequestLine().getUri());
        String charset2 = this.getParameter("charset");
        if (charset2 == null) {
            charset2 = AuthParams.getCredentialCharset(request.getParams());
            this.getParameters().put("charset", charset2);
        }
        return this.createDigestHeader(credentials);
    }

    private static MessageDigest createMessageDigest(String digAlg) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(digAlg);
        }
        catch (Exception e) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + digAlg);
        }
    }

    private Header createDigestHeader(Credentials credentials) throws AuthenticationException {
        String digestValue;
        MessageDigest digester;
        String digAlg;
        String charset2;
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String opaque = this.getParameter("opaque");
        String method = this.getParameter("methodname");
        String algorithm2 = this.getParameter("algorithm");
        if (uri == null) {
            throw new IllegalStateException("URI may not be null");
        }
        if (realm == null) {
            throw new IllegalStateException("Realm may not be null");
        }
        if (nonce == null) {
            throw new IllegalStateException("Nonce may not be null");
        }
        int qop = -1;
        String qoplist = this.getParameter("qop");
        if (qoplist != null) {
            StringTokenizer tok = new StringTokenizer(qoplist, ",");
            while (tok.hasMoreTokens()) {
                String variant = tok.nextToken().trim();
                if (!variant.equals("auth")) continue;
                qop = 2;
                break;
            }
        } else {
            qop = 0;
        }
        if (qop == -1) {
            throw new AuthenticationException("None of the qop methods is supported: " + qoplist);
        }
        if (algorithm2 == null) {
            algorithm2 = "MD5";
        }
        if ((charset2 = this.getParameter("charset")) == null) {
            charset2 = "ISO-8859-1";
        }
        if ((digAlg = algorithm2).equalsIgnoreCase("MD5-sess")) {
            digAlg = "MD5";
        }
        try {
            digester = DigestScheme.createMessageDigest(digAlg);
        }
        catch (UnsupportedDigestAlgorithmException ex) {
            throw new AuthenticationException("Unsuppported digest algorithm: " + digAlg);
        }
        String uname = credentials.getUserPrincipal().getName();
        String pwd = credentials.getPassword();
        if (nonce.equals(this.lastNonce)) {
            ++this.nounceCount;
        } else {
            this.nounceCount = 1L;
            this.cnonce = null;
            this.lastNonce = nonce;
        }
        StringBuilder sb = new StringBuilder(256);
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%08x", this.nounceCount);
        String nc = sb.toString();
        if (this.cnonce == null) {
            this.cnonce = DigestScheme.createCnonce();
        }
        this.a1 = null;
        this.a2 = null;
        if (algorithm2.equalsIgnoreCase("MD5-sess")) {
            sb.setLength(0);
            sb.append(uname).append(':').append(realm).append(':').append(pwd);
            String checksum = DigestScheme.encode(digester.digest(EncodingUtils.getBytes(sb.toString(), charset2)));
            sb.setLength(0);
            sb.append(checksum).append(':').append(nonce).append(':').append(this.cnonce);
            this.a1 = sb.toString();
        } else {
            sb.setLength(0);
            sb.append(uname).append(':').append(realm).append(':').append(pwd);
            this.a1 = sb.toString();
        }
        String hasha1 = DigestScheme.encode(digester.digest(EncodingUtils.getBytes(this.a1, charset2)));
        if (qop == 2) {
            this.a2 = method + ':' + uri;
        } else {
            if (qop == 1) {
                throw new AuthenticationException("qop-int method is not suppported");
            }
            this.a2 = method + ':' + uri;
        }
        String hasha2 = DigestScheme.encode(digester.digest(EncodingUtils.getBytes(this.a2, charset2)));
        if (qop == 0) {
            sb.setLength(0);
            sb.append(hasha1).append(':').append(nonce).append(':').append(hasha2);
            digestValue = sb.toString();
        } else {
            sb.setLength(0);
            sb.append(hasha1).append(':').append(nonce).append(':').append(nc).append(':').append(this.cnonce).append(':').append(qop == 1 ? "auth-int" : "auth").append(':').append(hasha2);
            digestValue = sb.toString();
        }
        String digest2 = DigestScheme.encode(digester.digest(EncodingUtils.getAsciiBytes(digestValue)));
        CharArrayBuffer buffer2 = new CharArrayBuffer(128);
        if (this.isProxy()) {
            buffer2.append("Proxy-Authorization");
        } else {
            buffer2.append("Authorization");
        }
        buffer2.append(": Digest ");
        ArrayList<BasicNameValuePair> params2 = new ArrayList<BasicNameValuePair>(20);
        params2.add(new BasicNameValuePair("username", uname));
        params2.add(new BasicNameValuePair("realm", realm));
        params2.add(new BasicNameValuePair("nonce", nonce));
        params2.add(new BasicNameValuePair("uri", uri));
        params2.add(new BasicNameValuePair("response", digest2));
        if (qop != 0) {
            params2.add(new BasicNameValuePair("qop", qop == 1 ? "auth-int" : "auth"));
            params2.add(new BasicNameValuePair("nc", nc));
            params2.add(new BasicNameValuePair("cnonce", this.cnonce));
        }
        if (algorithm2 != null) {
            params2.add(new BasicNameValuePair("algorithm", algorithm2));
        }
        if (opaque != null) {
            params2.add(new BasicNameValuePair("opaque", opaque));
        }
        for (int i = 0; i < params2.size(); ++i) {
            BasicNameValuePair param2 = (BasicNameValuePair)params2.get(i);
            if (i > 0) {
                buffer2.append(", ");
            }
            boolean noQuotes = "nc".equals(param2.getName()) || "qop".equals(param2.getName());
            BasicHeaderValueFormatter.DEFAULT.formatNameValuePair(buffer2, param2, !noQuotes);
        }
        return new BufferedHeader(buffer2);
    }

    String getCnonce() {
        return this.cnonce;
    }

    String getA1() {
        return this.a1;
    }

    String getA2() {
        return this.a2;
    }

    private static String encode(byte[] binaryData) {
        int n = binaryData.length;
        char[] buffer2 = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer2[i * 2] = HEXADECIMAL[high];
            buffer2[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer2);
    }

    public static String createCnonce() {
        SecureRandom rnd = new SecureRandom();
        byte[] tmp = new byte[8];
        rnd.nextBytes(tmp);
        return DigestScheme.encode(tmp);
    }
}

