/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.SetCookie;

@NotThreadSafe
public class BasicClientCookie
implements SetCookie,
ClientCookie,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3869795591041535538L;
    private final String name;
    private Map<String, String> attribs;
    private String value;
    private String cookieComment;
    private String cookieDomain;
    private Date cookieExpiryDate;
    private String cookiePath;
    private boolean isSecure;
    private int cookieVersion;

    public BasicClientCookie(String name2, String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name2;
        this.attribs = new HashMap<String, String>();
        this.value = value2;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public String getComment() {
        return this.cookieComment;
    }

    public void setComment(String comment2) {
        this.cookieComment = comment2;
    }

    public String getCommentURL() {
        return null;
    }

    public Date getExpiryDate() {
        return this.cookieExpiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.cookieExpiryDate = expiryDate;
    }

    public boolean isPersistent() {
        return null != this.cookieExpiryDate;
    }

    public String getDomain() {
        return this.cookieDomain;
    }

    public void setDomain(String domain2) {
        this.cookieDomain = domain2 != null ? domain2.toLowerCase(Locale.ENGLISH) : null;
    }

    public String getPath() {
        return this.cookiePath;
    }

    public void setPath(String path2) {
        this.cookiePath = path2;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean secure2) {
        this.isSecure = secure2;
    }

    public int[] getPorts() {
        return null;
    }

    public int getVersion() {
        return this.cookieVersion;
    }

    public void setVersion(int version2) {
        this.cookieVersion = version2;
    }

    public boolean isExpired(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date may not be null");
        }
        return this.cookieExpiryDate != null && this.cookieExpiryDate.getTime() <= date.getTime();
    }

    public void setAttribute(String name2, String value2) {
        this.attribs.put(name2, value2);
    }

    public String getAttribute(String name2) {
        return this.attribs.get(name2);
    }

    public boolean containsAttribute(String name2) {
        return this.attribs.get(name2) != null;
    }

    public Object clone() throws CloneNotSupportedException {
        BasicClientCookie clone2 = (BasicClientCookie)super.clone();
        clone2.attribs = new HashMap<String, String>(this.attribs);
        return clone2;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append("[version: ");
        buffer2.append(Integer.toString(this.cookieVersion));
        buffer2.append("]");
        buffer2.append("[name: ");
        buffer2.append(this.name);
        buffer2.append("]");
        buffer2.append("[value: ");
        buffer2.append(this.value);
        buffer2.append("]");
        buffer2.append("[domain: ");
        buffer2.append(this.cookieDomain);
        buffer2.append("]");
        buffer2.append("[path: ");
        buffer2.append(this.cookiePath);
        buffer2.append("]");
        buffer2.append("[expiry: ");
        buffer2.append(this.cookieExpiryDate);
        buffer2.append("]");
        return buffer2.toString();
    }
}

