/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;

@Immutable
public class BasicDomainHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie2, String value2) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (value2.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        cookie2.setDomain(value2);
    }

    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host2 = origin.getHost();
        String domain2 = cookie2.getDomain();
        if (domain2 == null) {
            throw new CookieRestrictionViolationException("Cookie domain may not be null");
        }
        if (host2.contains(".")) {
            if (!host2.endsWith(domain2)) {
                if (domain2.startsWith(".")) {
                    domain2 = domain2.substring(1, domain2.length());
                }
                if (!host2.equals(domain2)) {
                    throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain2 + "\". Domain of origin: \"" + host2 + "\"");
                }
            }
        } else if (!host2.equals(domain2)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain2 + "\". Domain of origin: \"" + host2 + "\"");
        }
    }

    public boolean match(Cookie cookie2, CookieOrigin origin) {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host2 = origin.getHost();
        String domain2 = cookie2.getDomain();
        if (domain2 == null) {
            return false;
        }
        if (host2.equals(domain2)) {
            return true;
        }
        if (!domain2.startsWith(".")) {
            domain2 = '.' + domain2;
        }
        return host2.endsWith(domain2) || host2.equals(domain2.substring(1));
    }
}

