/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicDomainHandler;

@Immutable
public class NetscapeDomainHandler
extends BasicDomainHandler {
    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        super.validate(cookie2, origin);
        String host2 = origin.getHost();
        String domain2 = cookie2.getDomain();
        if (host2.contains(".")) {
            int domainParts = new StringTokenizer(domain2, ".").countTokens();
            if (NetscapeDomainHandler.isSpecialDomain(domain2)) {
                if (domainParts < 2) {
                    throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates the Netscape cookie specification for " + "special domains");
                }
            } else if (domainParts < 3) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates the Netscape cookie specification");
            }
        }
    }

    private static boolean isSpecialDomain(String domain2) {
        String ucDomain = domain2.toUpperCase(Locale.ENGLISH);
        return ucDomain.endsWith(".COM") || ucDomain.endsWith(".EDU") || ucDomain.endsWith(".NET") || ucDomain.endsWith(".GOV") || ucDomain.endsWith(".MIL") || ucDomain.endsWith(".ORG") || ucDomain.endsWith(".INT");
    }

    public boolean match(Cookie cookie2, CookieOrigin origin) {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host2 = origin.getHost();
        String domain2 = cookie2.getDomain();
        if (domain2 == null) {
            return false;
        }
        return host2.endsWith(domain2);
    }
}

