/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();

    public HeaderElement parseHeader(CharArrayBuffer buffer2, ParserCursor cursor) throws ParseException {
        if (buffer2 == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        NameValuePair nvp = this.parseNameValuePair(buffer2, cursor);
        ArrayList<NameValuePair> params2 = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param2 = this.parseNameValuePair(buffer2, cursor);
            params2.add(param2);
        }
        return new BasicHeaderElement(nvp.getName(), nvp.getValue(), params2.toArray(new NameValuePair[params2.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer buffer2, ParserCursor cursor) {
        char ch;
        int pos;
        boolean terminated = false;
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        String name2 = null;
        for (pos = cursor.getPos(); pos < indexTo && (ch = buffer2.charAt(pos)) != '='; ++pos) {
            if (ch != ';') continue;
            terminated = true;
            break;
        }
        if (pos == indexTo) {
            terminated = true;
            name2 = buffer2.substringTrimmed(indexFrom, indexTo);
        } else {
            name2 = buffer2.substringTrimmed(indexFrom, pos);
            ++pos;
        }
        if (terminated) {
            cursor.updatePos(pos);
            return new BasicNameValuePair(name2, null);
        }
        String value2 = null;
        int i1 = pos;
        while (pos < indexTo) {
            char ch2 = buffer2.charAt(pos);
            if (ch2 == ';') {
                terminated = true;
                break;
            }
            ++pos;
        }
        int i2 = pos;
        while (i1 < i2 && HTTP.isWhitespace(buffer2.charAt(i1))) {
            ++i1;
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer2.charAt(i2 - 1))) {
            --i2;
        }
        value2 = buffer2.substring(i1, i2);
        if (terminated) {
            ++pos;
        }
        cursor.updatePos(pos);
        return new BasicNameValuePair(name2, value2);
    }
}

