/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.client.utils.Punycode;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicSuffixFilter
implements CookieAttributeHandler {
    private final CookieAttributeHandler wrapped;
    private Set<String> exceptions;
    private Set<String> suffixes;

    public PublicSuffixFilter(CookieAttributeHandler wrapped) {
        this.wrapped = wrapped;
    }

    public void setPublicSuffixes(Collection<String> suffixes) {
        this.suffixes = new HashSet<String>(suffixes);
    }

    public void setExceptions(Collection<String> exceptions2) {
        this.exceptions = new HashSet<String>(exceptions2);
    }

    @Override
    public boolean match(Cookie cookie2, CookieOrigin origin) {
        if (this.isForPublicSuffix(cookie2)) {
            return false;
        }
        return this.wrapped.match(cookie2, origin);
    }

    @Override
    public void parse(SetCookie cookie2, String value2) throws MalformedCookieException {
        this.wrapped.parse(cookie2, value2);
    }

    @Override
    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        this.wrapped.validate(cookie2, origin);
    }

    private boolean isForPublicSuffix(Cookie cookie2) {
        int nextdot;
        String domain2 = cookie2.getDomain();
        if (domain2.startsWith(".")) {
            domain2 = domain2.substring(1);
        }
        domain2 = Punycode.toUnicode(domain2);
        if (this.exceptions != null && this.exceptions.contains(domain2)) {
            return false;
        }
        if (this.suffixes == null) {
            return false;
        }
        do {
            if (this.suffixes.contains(domain2)) {
                return true;
            }
            if (!domain2.startsWith("*.")) continue;
            domain2 = domain2.substring(2);
        } while ((nextdot = domain2.indexOf(46)) != -1 && (domain2 = "*" + domain2.substring(nextdot)).length() > 0);
        return false;
    }
}

